/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Arguments used for the command to generate the docker copy script. This is applicable for Openshift deployments, where we cannot perform the image copying ourselves.")
public class ApiGenerateCopyDockerArgs {
    @SerializedName(value="remoteRepoUrl")
    private String remoteRepoUrl = null;
    @SerializedName(value="dockerRegistry")
    private String dockerRegistry = null;
    @SerializedName(value="controlPlaneUuid")
    private String controlPlaneUuid = null;
    @SerializedName(value="selectedFeatures")
    private String selectedFeatures = null;
    @SerializedName(value="selectedFeaturesOnly")
    private Boolean selectedFeaturesOnly = null;

    public ApiGenerateCopyDockerArgs remoteRepoUrl(String remoteRepoUrl) {
        this.remoteRepoUrl = remoteRepoUrl;
        return this;
    }

    @Schema(description="The url of the remote repository where the private cloud artifacts to install are hosted")
    public String getRemoteRepoUrl() {
        return this.remoteRepoUrl;
    }

    public void setRemoteRepoUrl(String remoteRepoUrl) {
        this.remoteRepoUrl = remoteRepoUrl;
    }

    public ApiGenerateCopyDockerArgs dockerRegistry(String dockerRegistry) {
        this.dockerRegistry = dockerRegistry;
        return this;
    }

    @Schema(description="The url of the Docker Registry where images required for install will be copied to")
    public String getDockerRegistry() {
        return this.dockerRegistry;
    }

    public void setDockerRegistry(String dockerRegistry) {
        this.dockerRegistry = dockerRegistry;
    }

    public ApiGenerateCopyDockerArgs controlPlaneUuid(String controlPlaneUuid) {
        this.controlPlaneUuid = controlPlaneUuid;
        return this;
    }

    @Schema(description="Optional. The uuid of the control plane, if copying docker images for an upgrade")
    public String getControlPlaneUuid() {
        return this.controlPlaneUuid;
    }

    public void setControlPlaneUuid(String controlPlaneUuid) {
        this.controlPlaneUuid = controlPlaneUuid;
    }

    public ApiGenerateCopyDockerArgs selectedFeatures(String selectedFeatures) {
        this.selectedFeatures = selectedFeatures;
        return this;
    }

    @Schema(description="Optional. The name of the feature(s) in a comma separated list that container images/packages are associated with. When it is null, copy all the images.")
    public String getSelectedFeatures() {
        return this.selectedFeatures;
    }

    public void setSelectedFeatures(String selectedFeatures) {
        this.selectedFeatures = selectedFeatures;
    }

    public ApiGenerateCopyDockerArgs selectedFeaturesOnly(Boolean selectedFeaturesOnly) {
        this.selectedFeaturesOnly = selectedFeaturesOnly;
        return this;
    }

    @Schema(required=true, description="Optional. If true, then only images/packages that belong to the selected features will be processed. If false, then images/packages that don't belong to any features will also be processed in addition to the ones that belong to the selected features. This should be set to false (default) for install/upgrades. to true when copying specific images/packages associated with a specific feature.")
    public Boolean isSelectedFeaturesOnly() {
        return this.selectedFeaturesOnly;
    }

    public void setSelectedFeaturesOnly(Boolean selectedFeaturesOnly) {
        this.selectedFeaturesOnly = selectedFeaturesOnly;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiGenerateCopyDockerArgs apiGenerateCopyDockerArgs = (ApiGenerateCopyDockerArgs)o;
        return Objects.equals(this.remoteRepoUrl, apiGenerateCopyDockerArgs.remoteRepoUrl) && Objects.equals(this.dockerRegistry, apiGenerateCopyDockerArgs.dockerRegistry) && Objects.equals(this.controlPlaneUuid, apiGenerateCopyDockerArgs.controlPlaneUuid) && Objects.equals(this.selectedFeatures, apiGenerateCopyDockerArgs.selectedFeatures) && Objects.equals(this.selectedFeaturesOnly, apiGenerateCopyDockerArgs.selectedFeaturesOnly);
    }

    public int hashCode() {
        return Objects.hash(this.remoteRepoUrl, this.dockerRegistry, this.controlPlaneUuid, this.selectedFeatures, this.selectedFeaturesOnly);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiGenerateCopyDockerArgs {\n");
        sb.append("    remoteRepoUrl: ").append(this.toIndentedString(this.remoteRepoUrl)).append("\n");
        sb.append("    dockerRegistry: ").append(this.toIndentedString(this.dockerRegistry)).append("\n");
        sb.append("    controlPlaneUuid: ").append(this.toIndentedString(this.controlPlaneUuid)).append("\n");
        sb.append("    selectedFeatures: ").append(this.toIndentedString(this.selectedFeatures)).append("\n");
        sb.append("    selectedFeaturesOnly: ").append(this.toIndentedString(this.selectedFeaturesOnly)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

