/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.cloudera.api.swagger.model.ApiHdfsSnapshot;
import com.cloudera.api.swagger.model.ApiHdfsSnapshotError;
import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Detailed information about an HDFS snapshot command.")
public class ApiHdfsSnapshotResult {
    @SerializedName(value="processedPathCount")
    private BigDecimal processedPathCount = null;
    @SerializedName(value="processedPaths")
    private List<String> processedPaths = null;
    @SerializedName(value="unprocessedPathCount")
    private BigDecimal unprocessedPathCount = null;
    @SerializedName(value="unprocessedPaths")
    private List<String> unprocessedPaths = null;
    @SerializedName(value="createdSnapshotCount")
    private BigDecimal createdSnapshotCount = null;
    @SerializedName(value="createdSnapshots")
    private List<ApiHdfsSnapshot> createdSnapshots = null;
    @SerializedName(value="deletedSnapshotCount")
    private BigDecimal deletedSnapshotCount = null;
    @SerializedName(value="deletedSnapshots")
    private List<ApiHdfsSnapshot> deletedSnapshots = null;
    @SerializedName(value="creationErrorCount")
    private BigDecimal creationErrorCount = null;
    @SerializedName(value="creationErrors")
    private List<ApiHdfsSnapshotError> creationErrors = null;
    @SerializedName(value="deletionErrorCount")
    private BigDecimal deletionErrorCount = null;
    @SerializedName(value="deletionErrors")
    private List<ApiHdfsSnapshotError> deletionErrors = null;

    public ApiHdfsSnapshotResult processedPathCount(BigDecimal processedPathCount) {
        this.processedPathCount = processedPathCount;
        return this;
    }

    @Schema(description="Number of processed paths.")
    public BigDecimal getProcessedPathCount() {
        return this.processedPathCount;
    }

    public void setProcessedPathCount(BigDecimal processedPathCount) {
        this.processedPathCount = processedPathCount;
    }

    public ApiHdfsSnapshotResult processedPaths(List<String> processedPaths) {
        this.processedPaths = processedPaths;
        return this;
    }

    public ApiHdfsSnapshotResult addProcessedPathsItem(String processedPathsItem) {
        if (this.processedPaths == null) {
            this.processedPaths = new ArrayList<String>();
        }
        this.processedPaths.add(processedPathsItem);
        return this;
    }

    @Schema(description="The list of processed paths. <p/> This is only available in the full view.")
    public List<String> getProcessedPaths() {
        return this.processedPaths;
    }

    public void setProcessedPaths(List<String> processedPaths) {
        this.processedPaths = processedPaths;
    }

    public ApiHdfsSnapshotResult unprocessedPathCount(BigDecimal unprocessedPathCount) {
        this.unprocessedPathCount = unprocessedPathCount;
        return this;
    }

    @Schema(description="Number of unprocessed paths.")
    public BigDecimal getUnprocessedPathCount() {
        return this.unprocessedPathCount;
    }

    public void setUnprocessedPathCount(BigDecimal unprocessedPathCount) {
        this.unprocessedPathCount = unprocessedPathCount;
    }

    public ApiHdfsSnapshotResult unprocessedPaths(List<String> unprocessedPaths) {
        this.unprocessedPaths = unprocessedPaths;
        return this;
    }

    public ApiHdfsSnapshotResult addUnprocessedPathsItem(String unprocessedPathsItem) {
        if (this.unprocessedPaths == null) {
            this.unprocessedPaths = new ArrayList<String>();
        }
        this.unprocessedPaths.add(unprocessedPathsItem);
        return this;
    }

    @Schema(description="The list of unprocessed paths. Note that paths that are currently being processed will also be included in this list. <p/> This is only available in the full view.")
    public List<String> getUnprocessedPaths() {
        return this.unprocessedPaths;
    }

    public void setUnprocessedPaths(List<String> unprocessedPaths) {
        this.unprocessedPaths = unprocessedPaths;
    }

    public ApiHdfsSnapshotResult createdSnapshotCount(BigDecimal createdSnapshotCount) {
        this.createdSnapshotCount = createdSnapshotCount;
        return this;
    }

    @Schema(description="Number of snapshots created.")
    public BigDecimal getCreatedSnapshotCount() {
        return this.createdSnapshotCount;
    }

    public void setCreatedSnapshotCount(BigDecimal createdSnapshotCount) {
        this.createdSnapshotCount = createdSnapshotCount;
    }

    public ApiHdfsSnapshotResult createdSnapshots(List<ApiHdfsSnapshot> createdSnapshots) {
        this.createdSnapshots = createdSnapshots;
        return this;
    }

    public ApiHdfsSnapshotResult addCreatedSnapshotsItem(ApiHdfsSnapshot createdSnapshotsItem) {
        if (this.createdSnapshots == null) {
            this.createdSnapshots = new ArrayList<ApiHdfsSnapshot>();
        }
        this.createdSnapshots.add(createdSnapshotsItem);
        return this;
    }

    @Schema(description="List of snapshots created. <p/> This is only available in the full view.")
    public List<ApiHdfsSnapshot> getCreatedSnapshots() {
        return this.createdSnapshots;
    }

    public void setCreatedSnapshots(List<ApiHdfsSnapshot> createdSnapshots) {
        this.createdSnapshots = createdSnapshots;
    }

    public ApiHdfsSnapshotResult deletedSnapshotCount(BigDecimal deletedSnapshotCount) {
        this.deletedSnapshotCount = deletedSnapshotCount;
        return this;
    }

    @Schema(description="Number of snapshots deleted.")
    public BigDecimal getDeletedSnapshotCount() {
        return this.deletedSnapshotCount;
    }

    public void setDeletedSnapshotCount(BigDecimal deletedSnapshotCount) {
        this.deletedSnapshotCount = deletedSnapshotCount;
    }

    public ApiHdfsSnapshotResult deletedSnapshots(List<ApiHdfsSnapshot> deletedSnapshots) {
        this.deletedSnapshots = deletedSnapshots;
        return this;
    }

    public ApiHdfsSnapshotResult addDeletedSnapshotsItem(ApiHdfsSnapshot deletedSnapshotsItem) {
        if (this.deletedSnapshots == null) {
            this.deletedSnapshots = new ArrayList<ApiHdfsSnapshot>();
        }
        this.deletedSnapshots.add(deletedSnapshotsItem);
        return this;
    }

    @Schema(description="List of snapshots deleted. <p/> This is only available in the full view.")
    public List<ApiHdfsSnapshot> getDeletedSnapshots() {
        return this.deletedSnapshots;
    }

    public void setDeletedSnapshots(List<ApiHdfsSnapshot> deletedSnapshots) {
        this.deletedSnapshots = deletedSnapshots;
    }

    public ApiHdfsSnapshotResult creationErrorCount(BigDecimal creationErrorCount) {
        this.creationErrorCount = creationErrorCount;
        return this;
    }

    @Schema(description="Number of errors detected when creating snapshots.")
    public BigDecimal getCreationErrorCount() {
        return this.creationErrorCount;
    }

    public void setCreationErrorCount(BigDecimal creationErrorCount) {
        this.creationErrorCount = creationErrorCount;
    }

    public ApiHdfsSnapshotResult creationErrors(List<ApiHdfsSnapshotError> creationErrors) {
        this.creationErrors = creationErrors;
        return this;
    }

    public ApiHdfsSnapshotResult addCreationErrorsItem(ApiHdfsSnapshotError creationErrorsItem) {
        if (this.creationErrors == null) {
            this.creationErrors = new ArrayList<ApiHdfsSnapshotError>();
        }
        this.creationErrors.add(creationErrorsItem);
        return this;
    }

    @Schema(description="List of errors encountered when creating snapshots. <p/> This is only available in the full view.")
    public List<ApiHdfsSnapshotError> getCreationErrors() {
        return this.creationErrors;
    }

    public void setCreationErrors(List<ApiHdfsSnapshotError> creationErrors) {
        this.creationErrors = creationErrors;
    }

    public ApiHdfsSnapshotResult deletionErrorCount(BigDecimal deletionErrorCount) {
        this.deletionErrorCount = deletionErrorCount;
        return this;
    }

    @Schema(description="Number of errors detected when deleting snapshots.")
    public BigDecimal getDeletionErrorCount() {
        return this.deletionErrorCount;
    }

    public void setDeletionErrorCount(BigDecimal deletionErrorCount) {
        this.deletionErrorCount = deletionErrorCount;
    }

    public ApiHdfsSnapshotResult deletionErrors(List<ApiHdfsSnapshotError> deletionErrors) {
        this.deletionErrors = deletionErrors;
        return this;
    }

    public ApiHdfsSnapshotResult addDeletionErrorsItem(ApiHdfsSnapshotError deletionErrorsItem) {
        if (this.deletionErrors == null) {
            this.deletionErrors = new ArrayList<ApiHdfsSnapshotError>();
        }
        this.deletionErrors.add(deletionErrorsItem);
        return this;
    }

    @Schema(description="List of errors encountered when deleting snapshots. <p/> This is only available in the full view.")
    public List<ApiHdfsSnapshotError> getDeletionErrors() {
        return this.deletionErrors;
    }

    public void setDeletionErrors(List<ApiHdfsSnapshotError> deletionErrors) {
        this.deletionErrors = deletionErrors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiHdfsSnapshotResult apiHdfsSnapshotResult = (ApiHdfsSnapshotResult)o;
        return Objects.equals(this.processedPathCount, apiHdfsSnapshotResult.processedPathCount) && Objects.equals(this.processedPaths, apiHdfsSnapshotResult.processedPaths) && Objects.equals(this.unprocessedPathCount, apiHdfsSnapshotResult.unprocessedPathCount) && Objects.equals(this.unprocessedPaths, apiHdfsSnapshotResult.unprocessedPaths) && Objects.equals(this.createdSnapshotCount, apiHdfsSnapshotResult.createdSnapshotCount) && Objects.equals(this.createdSnapshots, apiHdfsSnapshotResult.createdSnapshots) && Objects.equals(this.deletedSnapshotCount, apiHdfsSnapshotResult.deletedSnapshotCount) && Objects.equals(this.deletedSnapshots, apiHdfsSnapshotResult.deletedSnapshots) && Objects.equals(this.creationErrorCount, apiHdfsSnapshotResult.creationErrorCount) && Objects.equals(this.creationErrors, apiHdfsSnapshotResult.creationErrors) && Objects.equals(this.deletionErrorCount, apiHdfsSnapshotResult.deletionErrorCount) && Objects.equals(this.deletionErrors, apiHdfsSnapshotResult.deletionErrors);
    }

    public int hashCode() {
        return Objects.hash(this.processedPathCount, this.processedPaths, this.unprocessedPathCount, this.unprocessedPaths, this.createdSnapshotCount, this.createdSnapshots, this.deletedSnapshotCount, this.deletedSnapshots, this.creationErrorCount, this.creationErrors, this.deletionErrorCount, this.deletionErrors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiHdfsSnapshotResult {\n");
        sb.append("    processedPathCount: ").append(this.toIndentedString(this.processedPathCount)).append("\n");
        sb.append("    processedPaths: ").append(this.toIndentedString(this.processedPaths)).append("\n");
        sb.append("    unprocessedPathCount: ").append(this.toIndentedString(this.unprocessedPathCount)).append("\n");
        sb.append("    unprocessedPaths: ").append(this.toIndentedString(this.unprocessedPaths)).append("\n");
        sb.append("    createdSnapshotCount: ").append(this.toIndentedString(this.createdSnapshotCount)).append("\n");
        sb.append("    createdSnapshots: ").append(this.toIndentedString(this.createdSnapshots)).append("\n");
        sb.append("    deletedSnapshotCount: ").append(this.toIndentedString(this.deletedSnapshotCount)).append("\n");
        sb.append("    deletedSnapshots: ").append(this.toIndentedString(this.deletedSnapshots)).append("\n");
        sb.append("    creationErrorCount: ").append(this.toIndentedString(this.creationErrorCount)).append("\n");
        sb.append("    creationErrors: ").append(this.toIndentedString(this.creationErrors)).append("\n");
        sb.append("    deletionErrorCount: ").append(this.toIndentedString(this.deletionErrorCount)).append("\n");
        sb.append("    deletionErrors: ").append(this.toIndentedString(this.deletionErrors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

