/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.metrics.impl.instr;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.httpclient.HttpClientMetricNameStrategy;
import com.codahale.metrics.httpclient.InstrumentedHttpRequestExecutor;
import java.net.URISyntaxException;
import java.util.Locale;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.RequestLine;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.knox.gateway.services.metrics.InstrumentationProvider;
import org.apache.knox.gateway.services.metrics.MetricsContext;
import org.apache.knox.gateway.services.metrics.impl.instr.InstrUtils;

public class InstrHttpClientBuilderProvider
implements InstrumentationProvider<HttpClientBuilder> {
    private static final HttpClientMetricNameStrategy TOPOLOGY_URL_AND_METHOD = new HttpClientMetricNameStrategy(){

        public String getNameFor(String name, HttpRequest request) {
            try {
                String context = "";
                Header header = request.getFirstHeader("X-Forwarded-Context");
                if (header != null) {
                    context = header.getValue();
                }
                RequestLine requestLine = request.getRequestLine();
                URIBuilder uriBuilder = new URIBuilder(requestLine.getUri());
                String resourcePath = InstrUtils.getServiceResourcePath(uriBuilder.removeQuery().build().toString());
                return MetricRegistry.name((String)"service", (String[])new String[]{name, context + resourcePath, this.methodNameString(request)});
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }

        private String methodNameString(HttpRequest request) {
            return request.getRequestLine().getMethod().toLowerCase(Locale.ROOT) + "-requests";
        }
    };

    public HttpClientBuilder getInstrumented(MetricsContext metricsContext) {
        MetricRegistry registry = (MetricRegistry)metricsContext.getProperty("metrics-registry");
        return HttpClientBuilder.create().setRequestExecutor((HttpRequestExecutor)new InstrumentedHttpRequestExecutor(registry, TOPOLOGY_URL_AND_METHOD));
    }

    public HttpClientBuilder getInstrumented(HttpClientBuilder instanceClass, MetricsContext metricsContext) {
        throw new UnsupportedOperationException();
    }
}

