/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery;

import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.Service;
import org.apache.knox.gateway.topology.discovery.GatewayService;
import org.apache.knox.gateway.topology.discovery.ServiceDiscovery;
import org.apache.knox.gateway.topology.discovery.ServiceDiscoveryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ServiceDiscoveryFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceDiscoveryFactory.class);
    private static final Service[] NO_GATEWAY_SERVICS = new Service[0];

    public static ServiceDiscovery get(String type) {
        return ServiceDiscoveryFactory.get(type, NO_GATEWAY_SERVICS);
    }

    public static Set<ServiceDiscovery> getAllServiceDiscoveries() {
        return ServiceDiscoveryFactory.getAllServiceDiscoveries(null);
    }

    public static Set<ServiceDiscovery> getAllServiceDiscoveries(GatewayConfig gatewayConfig) {
        HashSet<ServiceDiscovery> serviceDiscoveries = new HashSet<ServiceDiscovery>();
        ServiceLoader.load(ServiceDiscoveryType.class).forEach(serviceDiscoveryType -> serviceDiscoveries.add(serviceDiscoveryType.newInstance(gatewayConfig)));
        return serviceDiscoveries;
    }

    public static ServiceDiscovery get(String type, Service ... gatewayServices) {
        return ServiceDiscoveryFactory.get(type, null, gatewayServices);
    }

    public static ServiceDiscovery get(String type, GatewayConfig gatewayConfig, Service ... gatewayServices) {
        ServiceDiscovery sd = ServiceDiscoveryFactory.getAllServiceDiscoveries(gatewayConfig).stream().filter(serviceDiscovery -> serviceDiscovery.getType().equalsIgnoreCase(type)).findFirst().orElse(null);
        ServiceDiscoveryFactory.injectGatewayServices(sd, gatewayServices);
        return sd;
    }

    private static void injectGatewayServices(ServiceDiscovery serviceDiscovery, Service ... gatewayServices) {
        if (serviceDiscovery != null && ArrayUtils.isNotEmpty((Object[])gatewayServices)) {
            try {
                for (Field field : serviceDiscovery.getClass().getDeclaredFields()) {
                    if (field.getDeclaredAnnotation(GatewayService.class) == null) continue;
                    for (Service gatewayService : gatewayServices) {
                        if (gatewayService == null || !field.getType().isAssignableFrom(gatewayService.getClass())) continue;
                        field.setAccessible(true);
                        field.set(serviceDiscovery, gatewayService);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("Error while injecting Gateway Services in service discoveries", (Throwable)e);
            }
        }
    }
}

