/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.webappsec.filter;

import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public class SecurityHeaderFilter
implements Filter {
    private Map<String, String> securityHeaders = new HashMap<String, String>();

    public void init(FilterConfig filterConfig) throws ServletException {
        Enumeration initParamNames = filterConfig.getInitParameterNames();
        while (initParamNames.hasMoreElements()) {
            String headerName = (String)initParamNames.nextElement();
            if ("enabled".equals(headerName)) continue;
            String headerValue = filterConfig.getInitParameter(headerName);
            this.securityHeaders.put(headerName, headerValue);
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SecurityHeaderResponseWrapper httpResponse = new SecurityHeaderResponseWrapper((HttpServletResponse)response);
        for (Map.Entry<String, String> entry : this.securityHeaders.entrySet()) {
            String headerName = entry.getKey();
            String headerValue = entry.getValue();
            httpResponse.setHeader(headerName, headerValue);
        }
        chain.doFilter(request, (ServletResponse)httpResponse);
    }

    public void destroy() {
    }

    class SecurityHeaderResponseWrapper
    extends HttpServletResponseWrapper {
        SecurityHeaderResponseWrapper(HttpServletResponse res) {
            super(res);
        }

        public void addHeader(String name, String value) {
            if (!"enabled".equals(name)) {
                super.addHeader(name, value);
            }
        }

        public void setHeader(String name, String value) {
            if (!"enabled".equals(name)) {
                super.setHeader(name, value);
            }
        }

        public String getHeader(String name) {
            String value = (String)SecurityHeaderFilter.this.securityHeaders.get(name);
            if (value == null) {
                value = super.getHeader(name);
            }
            return value;
        }

        public Collection<String> getHeaderNames() {
            HashSet<String> names = new HashSet<String>(SecurityHeaderFilter.this.securityHeaders.keySet());
            if (super.getHeaderNames() != null) {
                names.addAll(super.getHeaderNames());
            }
            return names;
        }

        public Collection<String> getHeaders(String name) {
            HashSet<String> values = new HashSet<String>(SecurityHeaderFilter.this.securityHeaders.values());
            if (super.getHeaders(name) != null) {
                values.addAll(super.getHeaders(name));
            }
            return values;
        }
    }
}

