/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.AbstractSAMLObjectUnmarshaller;
import org.opensaml.saml.saml2.metadata.EncryptionMethod;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.security.credential.UsageType;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.w3c.dom.Attr;

public class KeyDescriptorUnmarshaller
extends AbstractSAMLObjectUnmarshaller {
    protected void processChildElement(XMLObject parentSAMLObject, XMLObject childSAMLObject) throws UnmarshallingException {
        KeyDescriptor keyDescriptor = (KeyDescriptor)parentSAMLObject;
        if (childSAMLObject instanceof KeyInfo) {
            keyDescriptor.setKeyInfo((KeyInfo)childSAMLObject);
        } else if (childSAMLObject instanceof EncryptionMethod) {
            keyDescriptor.getEncryptionMethods().add((EncryptionMethod)childSAMLObject);
        } else {
            super.processChildElement(parentSAMLObject, childSAMLObject);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void processAttribute(XMLObject samlObject, Attr attribute) throws UnmarshallingException {
        KeyDescriptor keyDescriptor = (KeyDescriptor)samlObject;
        if (attribute.getName().equals("use") && attribute.getNamespaceURI() == null) {
            if (UsageType.SIGNING.getValue().equals(attribute.getValue())) {
                keyDescriptor.setUse(UsageType.SIGNING);
                return;
            } else {
                if (!UsageType.ENCRYPTION.getValue().equals(attribute.getValue())) throw new UnmarshallingException("Invalid key usage type: " + attribute.getValue());
                keyDescriptor.setUse(UsageType.ENCRYPTION);
            }
            return;
        } else {
            super.processAttribute(samlObject, attribute);
        }
    }
}

