/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.integrations.shiro;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import org.apache.shiro.cache.CacheException;
import org.ehcache.Cache;
import org.ehcache.integrations.shiro.EhcacheCollectionWrapper;
import org.ehcache.integrations.shiro.EhcacheIterator;
import org.ehcache.integrations.shiro.EhcacheSetWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EhcacheShiro<K, V>
implements org.apache.shiro.cache.Cache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(EhcacheShiro.class);
    private final Cache<K, V> cache;

    public EhcacheShiro(Cache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("Cache argument cannot be null.");
        }
        this.cache = cache;
    }

    public V get(K k) throws CacheException {
        this.trace("Getting object", k);
        if (k == null) {
            return null;
        }
        Object value = this.cache.get(k);
        if (value == null) {
            log.trace("Element for [{}] is null.", k);
        }
        return (V)value;
    }

    public V put(K k, V v) throws CacheException {
        this.trace("Putting object", k);
        Object previousValue = null;
        while (!((previousValue = this.cache.get(k)) == null ? this.cache.putIfAbsent(k, v) == null : this.cache.replace(k, v) != null)) {
        }
        return (V)previousValue;
    }

    public V remove(K k) throws CacheException {
        this.trace("Removing object", k);
        Object previousValue = null;
        while ((previousValue = this.cache.get(k)) != null && !this.cache.remove(k, previousValue)) {
        }
        return (V)previousValue;
    }

    public void clear() throws CacheException {
        log.trace("Clearing all objects from cache [" + this.cache + "]");
        this.cache.clear();
    }

    public int size() {
        Iterator iterator = this.cache.iterator();
        int size = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    public Set<K> keys() {
        return new EhcacheSetWrapper<K>(this, this.cache){

            @Override
            public Iterator<K> iterator() {
                return new EhcacheIterator<K, V, K>(EhcacheShiro.this.cache.iterator()){

                    @Override
                    protected K getNext(Iterator<Cache.Entry<K, V>> cacheIterator) {
                        return cacheIterator.next().getKey();
                    }
                };
            }
        };
    }

    public Collection<V> values() {
        return new EhcacheCollectionWrapper<V>(this, this.cache){

            @Override
            public Iterator<V> iterator() {
                return new EhcacheIterator<K, V, V>(EhcacheShiro.this.cache.iterator()){

                    @Override
                    protected V getNext(Iterator<Cache.Entry<K, V>> cacheIterator) {
                        return cacheIterator.next().getValue();
                    }
                };
            }
        };
    }

    private void trace(String operation, K k) {
        log.trace("{} using cache [{}] for key [{}]", new Object[]{operation, this.cache, k});
    }
}

