/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.encrypturi.impl;

import java.util.List;
import org.apache.knox.gateway.deploy.DeploymentContext;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributor;
import org.apache.knox.gateway.deploy.ProviderDeploymentContributorBase;
import org.apache.knox.gateway.descriptor.FilterParamDescriptor;
import org.apache.knox.gateway.descriptor.ResourceDescriptor;
import org.apache.knox.gateway.encrypturi.EncryptUriMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.AliasServiceException;
import org.apache.knox.gateway.topology.Provider;
import org.apache.knox.gateway.topology.Service;

public class EncryptUriDeploymentContributor
extends ProviderDeploymentContributorBase
implements ProviderDeploymentContributor {
    private static EncryptUriMessages log = (EncryptUriMessages)MessagesFactory.get(EncryptUriMessages.class);
    public static final String PROVIDER_ROLE_NAME = "encrypt";
    public static final String PROVIDER_IMPL_NAME = "default";
    private AliasService as;

    public String getRole() {
        return PROVIDER_ROLE_NAME;
    }

    public String getName() {
        return PROVIDER_IMPL_NAME;
    }

    public void setAliasService(AliasService as) {
        this.as = as;
    }

    public void initializeContribution(DeploymentContext context) {
        super.initializeContribution(context);
        String clusterName = context.getTopology().getName();
        try {
            this.as.getPasswordFromAliasForCluster(clusterName, "encryptQueryString", true);
        }
        catch (AliasServiceException e) {
            log.unableCreatePasswordForEncryption((Exception)((Object)e));
        }
    }

    public void contributeProvider(DeploymentContext context, Provider provider) {
    }

    public void contributeFilter(DeploymentContext context, Provider provider, Service service, ResourceDescriptor resource, List<FilterParamDescriptor> params) {
    }
}

