/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.discovery.cm.model.nifi;

import com.cloudera.api.swagger.client.ApiException;
import com.cloudera.api.swagger.model.ApiConfigList;
import com.cloudera.api.swagger.model.ApiRole;
import com.cloudera.api.swagger.model.ApiService;
import com.cloudera.api.swagger.model.ApiServiceConfig;
import java.util.Locale;
import org.apache.knox.gateway.topology.discovery.cm.ServiceModel;
import org.apache.knox.gateway.topology.discovery.cm.model.AbstractServiceModelGenerator;

public class NifiServiceModelGenerator
extends AbstractServiceModelGenerator {
    public static final String SERVICE = "NIFI";
    public static final String SERVICE_TYPE = "NIFI";
    public static final String ROLE_TYPE = "NIFI_NODE";
    static final String SSL_ENABLED = "ssl_enabled";
    static final String HTTP_PORT = "nifi.web.http.port";
    static final String HTTPS_PORT = "nifi.web.https.port";

    @Override
    public String getService() {
        return "NIFI";
    }

    @Override
    public String getServiceType() {
        return "NIFI";
    }

    @Override
    public String getRoleType() {
        return ROLE_TYPE;
    }

    @Override
    public ServiceModel.Type getModelType() {
        return ServiceModel.Type.UI;
    }

    @Override
    public ServiceModel generateService(ApiService service, ApiServiceConfig serviceConfig, ApiRole role, ApiConfigList roleConfig, ApiServiceConfig coreSettingsConfig) throws ApiException {
        String port;
        String scheme;
        String hostname = role.getHostRef().getHostname();
        boolean sslEnabled = Boolean.parseBoolean(this.getRoleConfigValue(roleConfig, SSL_ENABLED));
        if (sslEnabled) {
            scheme = "https";
            port = this.getRoleConfigValue(roleConfig, HTTPS_PORT);
        } else {
            scheme = "http";
            port = this.getRoleConfigValue(roleConfig, HTTP_PORT);
        }
        ServiceModel model = new ServiceModel(this.getModelType(), this.getService(), this.getServiceType(), this.getRoleType(), String.format(Locale.getDefault(), "%s://%s:%s", scheme, hostname, port));
        model.addRoleProperty(this.getRoleType(), SSL_ENABLED, this.getRoleConfigValue(roleConfig, SSL_ENABLED));
        model.addRoleProperty(this.getRoleType(), HTTP_PORT, this.getRoleConfigValue(roleConfig, HTTP_PORT));
        model.addRoleProperty(this.getRoleType(), HTTPS_PORT, this.getRoleConfigValue(roleConfig, HTTPS_PORT));
        return model;
    }
}

