/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.factory;

import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.util.Asn1Buffer;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.factory.ResponseFactory;
import org.apache.directory.api.ldap.model.message.ExtendedResponse;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.OpaqueExtendedResponse;
import org.apache.directory.api.util.Strings;

public final class ExtendedResponseFactory
extends ResponseFactory {
    public static final ExtendedResponseFactory INSTANCE = new ExtendedResponseFactory();

    private ExtendedResponseFactory() {
    }

    @Override
    public void encodeReverse(LdapApiService codec, Asn1Buffer buffer, Message message) {
        int start = buffer.getPos();
        ExtendedResponse extendedResponse = (ExtendedResponse)message;
        ExtendedOperationFactory factory = codec.getExtendedResponseFactories().get(extendedResponse.getResponseName());
        if (factory != null) {
            factory.encodeValue(buffer, extendedResponse);
            if (buffer.getPos() > start) {
                BerValue.encodeSequence((Asn1Buffer)buffer, (byte)-117, (int)start);
            }
        } else {
            byte[] responseValue = ((OpaqueExtendedResponse)extendedResponse).getResponseValue();
            if (!Strings.isEmpty((byte[])responseValue)) {
                BerValue.encodeOctetString((Asn1Buffer)buffer, (byte)-117, (byte[])responseValue);
            }
        }
        if (!Strings.isEmpty((String)extendedResponse.getResponseName())) {
            BerValue.encodeOctetString((Asn1Buffer)buffer, (byte)-118, (String)extendedResponse.getResponseName());
        }
        this.encodeLdapResultReverse(buffer, extendedResponse.getLdapResult());
        BerValue.encodeSequence((Asn1Buffer)buffer, (byte)120, (int)start);
    }
}

