/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.services.token.impl;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.config.GatewayConfig;
import org.apache.knox.gateway.services.ServiceLifecycleException;
import org.apache.knox.gateway.services.security.AliasService;
import org.apache.knox.gateway.services.security.token.KnoxToken;
import org.apache.knox.gateway.services.security.token.TokenMetadata;
import org.apache.knox.gateway.services.security.token.TokenMigrationTarget;
import org.apache.knox.gateway.services.security.token.TokenStateServiceException;
import org.apache.knox.gateway.services.security.token.UnknownTokenException;
import org.apache.knox.gateway.services.token.impl.AbstractPersistentTokenStateService;
import org.apache.knox.gateway.services.token.impl.TokenStateDatabase;
import org.apache.knox.gateway.util.JDBCUtils;
import org.apache.knox.gateway.util.TokenMigrationTool;
import org.apache.knox.gateway.util.Tokens;

public class JDBCTokenStateService
extends AbstractPersistentTokenStateService
implements TokenMigrationTarget {
    private AliasService aliasService;
    private TokenStateDatabase tokenDatabase;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private Lock initLock = new ReentrantLock(true);
    private Lock addMetadataLock = new ReentrantLock(true);
    private boolean skipTokenMigration;
    private boolean archiveMigratedTokens;
    private boolean migrateExpiredTokens;
    private boolean verboseTokenMigration;
    private int tokenMigrationProgressCount;

    public void setAliasService(AliasService aliasService) {
        this.aliasService = aliasService;
    }

    protected AliasService getAliasService() {
        return this.aliasService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(GatewayConfig config, Map<String, String> options) throws ServiceLifecycleException {
        if (!this.initialized.get()) {
            this.initLock.lock();
            try {
                super.init(config, options);
                if (this.aliasService == null) {
                    throw new ServiceLifecycleException("The required AliasService reference has not been set.");
                }
                try {
                    this.tokenDatabase = new TokenStateDatabase(JDBCUtils.getDataSource(config, this.aliasService));
                    this.initialized.set(true);
                }
                catch (Exception e) {
                    throw new ServiceLifecycleException("Error while initiating JDBCTokenStateService: " + e, e);
                }
                this.skipTokenMigration = config.skipTokenMigration();
                this.archiveMigratedTokens = config.archiveMigratedTokens();
                this.migrateExpiredTokens = config.migrateExpiredTokens();
                this.verboseTokenMigration = config.printVerboseTokenMigrationMessages();
                this.tokenMigrationProgressCount = config.getTokenMigrationProgressCount();
            }
            finally {
                this.initLock.unlock();
            }
        }
    }

    @Override
    public void start() throws ServiceLifecycleException {
        super.start();
        if (this.skipTokenMigration) {
            log.skipTokenMigration();
        } else {
            TokenMigrationTool tokenMigrationTool = new TokenMigrationTool(this.aliasService, this, null);
            tokenMigrationTool.setArchiveMigratedTokens(this.archiveMigratedTokens);
            tokenMigrationTool.setProgressCount(this.tokenMigrationProgressCount);
            tokenMigrationTool.setVerbose(this.verboseTokenMigration);
            tokenMigrationTool.setMigrateExpiredTokens(this.migrateExpiredTokens);
            tokenMigrationTool.migrateTokensFromGatewayCredentialStore();
        }
    }

    @Override
    public void addToken(String tokenId, long issueTime, long expiration, long maxLifetimeDuration) {
        try {
            boolean added = this.tokenDatabase.addToken(tokenId, issueTime, expiration, maxLifetimeDuration);
            if (!added) {
                log.failedToSaveTokenInDatabase(Tokens.getTokenIDDisplayText((String)tokenId));
                throw new TokenStateServiceException("Failed to save token " + Tokens.getTokenIDDisplayText((String)tokenId) + " in the database");
            }
            log.savedTokenInDatabase(Tokens.getTokenIDDisplayText((String)tokenId));
            super.addToken(tokenId, issueTime, expiration, maxLifetimeDuration);
        }
        catch (SQLException e) {
            log.errorSavingTokenInDatabase(Tokens.getTokenIDDisplayText((String)tokenId), e.getMessage(), e);
            throw new TokenStateServiceException("An error occurred while saving token " + Tokens.getTokenIDDisplayText((String)tokenId) + " in the database", (Throwable)e);
        }
    }

    @Override
    public long getTokenIssueTime(String tokenId) throws UnknownTokenException {
        try {
            return super.getTokenIssueTime(tokenId);
        }
        catch (UnknownTokenException unknownTokenException) {
            long issueTime = 0L;
            try {
                issueTime = this.tokenDatabase.getTokenIssueTime(tokenId);
                if (issueTime <= 0L) {
                    throw new UnknownTokenException(tokenId);
                }
                log.fetchedIssueTimeFromDatabase(Tokens.getTokenIDDisplayText((String)tokenId), issueTime);
                super.setIssueTime(tokenId, issueTime);
            }
            catch (SQLException e) {
                log.errorFetchingIssueTimeFromDatabase(Tokens.getTokenIDDisplayText((String)tokenId), e.getMessage(), e);
            }
            return issueTime;
        }
    }

    @Override
    public long getTokenExpiration(String tokenId, boolean validate) throws UnknownTokenException {
        if (validate) {
            this.validateToken(tokenId);
        }
        try {
            Long expiration = this.tokenDatabase.getTokenExpiration(tokenId);
            if (expiration != null) {
                log.fetchedExpirationFromDatabase(Tokens.getTokenIDDisplayText((String)tokenId), expiration);
                super.updateExpiration(tokenId, expiration);
                return expiration;
            }
            throw new UnknownTokenException(tokenId);
        }
        catch (SQLException e) {
            log.errorFetchingExpirationFromDatabase(Tokens.getTokenIDDisplayText((String)tokenId), e.getMessage(), e);
            throw new TokenStateServiceException("An error occurred while fetching expiration for " + Tokens.getTokenIDDisplayText((String)tokenId) + " from the database", (Throwable)e);
        }
    }

    @Override
    protected void updateExpiration(String tokenId, long expiration) {
        try {
            boolean updated = this.tokenDatabase.updateExpiration(tokenId, expiration);
            if (!updated) {
                log.failedToUpdateExpirationInDatabase(Tokens.getTokenIDDisplayText((String)tokenId), expiration);
                throw new TokenStateServiceException("Failed to updated expiration for " + Tokens.getTokenIDDisplayText((String)tokenId) + " in the database");
            }
            log.updatedExpirationInDatabase(Tokens.getTokenIDDisplayText((String)tokenId), expiration);
            super.updateExpiration(tokenId, expiration);
        }
        catch (SQLException e) {
            log.errorUpdatingExpirationInDatabase(Tokens.getTokenIDDisplayText((String)tokenId), e.getMessage(), e);
            throw new TokenStateServiceException("An error occurred while updating expiration for " + Tokens.getTokenIDDisplayText((String)tokenId) + " in the database", (Throwable)e);
        }
    }

    @Override
    protected long getMaxLifetime(String tokenId) {
        long maxLifetime = super.getMaxLifetime(tokenId);
        if (maxLifetime == 0L) {
            try {
                maxLifetime = this.tokenDatabase.getMaxLifetime(tokenId);
                log.fetchedMaxLifetimeFromDatabase(Tokens.getTokenIDDisplayText((String)tokenId), maxLifetime);
            }
            catch (SQLException e) {
                log.errorFetchingMaxLifetimeFromDatabase(Tokens.getTokenIDDisplayText((String)tokenId), e.getMessage(), e);
            }
        }
        return maxLifetime;
    }

    @Override
    protected boolean isUnknown(String tokenId) {
        boolean isUnknown = super.isUnknown(tokenId);
        if (isUnknown) {
            try {
                isUnknown = this.tokenDatabase.getMaxLifetime(tokenId) < 0L;
            }
            catch (SQLException e) {
                log.errorFetchingMaxLifetimeFromDatabase(Tokens.getTokenIDDisplayText((String)tokenId), e.getMessage(), e);
            }
        }
        return isUnknown;
    }

    @Override
    protected void removeToken(String tokenId) throws UnknownTokenException {
        try {
            boolean removed = this.tokenDatabase.removeToken(tokenId);
            if (!removed) {
                throw new UnknownTokenException(tokenId);
            }
            super.removeTokens(Collections.singleton(tokenId));
            log.removedTokenFromDatabase(Tokens.getTokenIDDisplayText((String)tokenId));
        }
        catch (SQLException e) {
            log.errorRemovingTokenFromDatabase(Tokens.getTokenIDDisplayText((String)tokenId), e.getMessage(), e);
        }
    }

    @Override
    protected void evictExpiredTokens() {
        try {
            long expirationLimit = System.currentTimeMillis() - TimeUnit.SECONDS.toMillis(this.tokenEvictionGracePeriod);
            Set<String> expiredTokenIds = this.tokenDatabase.getExpiredTokenIds(expirationLimit);
            if (!expiredTokenIds.isEmpty()) {
                log.removingExpiredTokensFromDatabase(expiredTokenIds.size(), String.join((CharSequence)", ", expiredTokenIds.stream().map(tokenId -> Tokens.getTokenIDDisplayText((String)tokenId)).collect(Collectors.toSet())));
                int numOfExpiredTokens = this.tokenDatabase.deleteExpiredTokens(expirationLimit);
                log.removedTokensFromDatabase(numOfExpiredTokens);
                super.removeTokens(expiredTokenIds);
            }
        }
        catch (SQLException e) {
            log.errorRemovingTokensFromDatabase(e.getMessage(), e);
        }
    }

    @Override
    public void addMetadata(String tokenId, TokenMetadata metadata) {
        try {
            boolean added = this.saveMetadataMapInDatabase(tokenId, metadata.getMetadataMap());
            if (!added) {
                log.failedToUpdateMetadataInDatabase(Tokens.getTokenIDDisplayText((String)tokenId));
                throw new TokenStateServiceException("Failed to update metadata for " + Tokens.getTokenIDDisplayText((String)tokenId) + " in the database");
            }
            log.updatedMetadataInDatabase(Tokens.getTokenIDDisplayText((String)tokenId));
            super.addMetadata(tokenId, metadata);
        }
        catch (SQLException e) {
            log.errorUpdatingMetadataInDatabase(Tokens.getTokenIDDisplayText((String)tokenId), e.getMessage(), e);
            throw new TokenStateServiceException("An error occurred while updating metadata for " + Tokens.getTokenIDDisplayText((String)tokenId) + " in the database", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean saveMetadataMapInDatabase(String tokenId, Map<String, String> metadataMap) throws SQLException {
        this.addMetadataLock.lock();
        try {
            boolean saved = false;
            for (Map.Entry<String, String> metadataMapEntry : metadataMap.entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)metadataMapEntry.getValue()) || !this.upsertTokenMetadata(tokenId, metadataMapEntry.getKey(), metadataMapEntry.getValue())) continue;
                saved = true;
            }
            boolean bl = saved;
            return bl;
        }
        finally {
            this.addMetadataLock.unlock();
        }
    }

    private boolean upsertTokenMetadata(String tokenId, String metadataName, String metadataValue) throws SQLException {
        if (!this.tokenDatabase.updateMetadata(tokenId, metadataName, metadataValue)) {
            return this.tokenDatabase.addMetadata(tokenId, metadataName, metadataValue);
        }
        return true;
    }

    @Override
    public TokenMetadata getTokenMetadata(String tokenId) throws UnknownTokenException {
        TokenMetadata tokenMetadata = null;
        try {
            tokenMetadata = this.tokenDatabase.getTokenMetadata(tokenId);
            if (tokenMetadata == null) {
                throw new UnknownTokenException(tokenId);
            }
            log.fetchedMetadataFromDatabase(Tokens.getTokenIDDisplayText((String)tokenId));
            super.addMetadata(tokenId, tokenMetadata);
        }
        catch (SQLException e) {
            log.errorFetchingMetadataFromDatabase(Tokens.getTokenIDDisplayText((String)tokenId), e.getMessage(), e);
        }
        return tokenMetadata;
    }

    @Override
    public Collection<KnoxToken> getAllTokens() {
        try {
            return this.tokenDatabase.getAllTokens();
        }
        catch (SQLException e) {
            log.errorFetchingAllTokensFromDatabase(e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    @Override
    public Collection<KnoxToken> getTokens(String userName) {
        try {
            return this.tokenDatabase.getTokens(userName);
        }
        catch (SQLException e) {
            log.errorFetchingTokensForUserFromDatabase(userName, e.getMessage(), e);
            return Collections.emptyList();
        }
    }

    @Override
    public Collection<KnoxToken> getDoAsTokens(String createdBy) {
        try {
            return this.tokenDatabase.getDoAsTokens(createdBy);
        }
        catch (SQLException e) {
            log.errorFetchingDoAsTokensForUserFromDatabase(createdBy, e.getMessage(), e);
            return Collections.emptyList();
        }
    }
}

