/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.svcregfunc.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.knox.gateway.filter.rewrite.api.UrlRewriteEnvironment;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteFunctionProcessor;
import org.apache.knox.gateway.services.ServiceType;
import org.apache.knox.gateway.services.hostmap.HostMapper;
import org.apache.knox.gateway.services.hostmap.HostMapperService;
import org.apache.knox.gateway.svcregfunc.api.ServiceMappedHostFunctionDescriptor;
import org.apache.knox.gateway.svcregfunc.impl.ServiceRegistryFunctionProcessorBase;
import org.apache.knox.gateway.util.urltemplate.Host;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Template;

public class ServiceMappedHostFunctionProcessor
extends ServiceRegistryFunctionProcessorBase<ServiceMappedHostFunctionDescriptor>
implements UrlRewriteFunctionProcessor<ServiceMappedHostFunctionDescriptor> {
    private HostMapper hostmap;

    public String name() {
        return "serviceMappedHost";
    }

    @Override
    public void initialize(UrlRewriteEnvironment environment, ServiceMappedHostFunctionDescriptor descriptor) throws Exception {
        super.initialize(environment, descriptor);
        HostMapperService hostmapService = (HostMapperService)this.services().getService(ServiceType.HOST_MAPPING_SERVICE);
        if (hostmapService != null) {
            this.hostmap = hostmapService.getHostMapper(this.cluster());
        }
    }

    public List<String> resolve(UrlRewriteContext context, List<String> parameters) throws Exception {
        ArrayList<String> results = null;
        if (parameters != null) {
            results = new ArrayList<String>(parameters.size());
            for (String parameter : parameters) {
                Template template;
                Host host;
                String url = this.lookupServiceUrl(parameter);
                if (url != null && (host = (template = Parser.parseLiteral((String)url)).getHost()) != null) {
                    String hostStr = host.getFirstValue().getPattern();
                    if (this.hostmap != null) {
                        switch (context.getDirection()) {
                            case IN: {
                                parameter = this.hostmap.resolveInboundHostName(hostStr);
                                break;
                            }
                            case OUT: {
                                parameter = this.hostmap.resolveOutboundHostName(hostStr);
                            }
                        }
                    } else {
                        parameter = hostStr;
                    }
                }
                results.add(parameter);
            }
        }
        return results;
    }
}

