/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.types.DataValueDescriptor;

class ValueRow
implements ExecRow {
    private DataValueDescriptor[] column;
    private int ncols;

    public ValueRow(int n) {
        this.column = new DataValueDescriptor[n];
        this.ncols = n;
    }

    @Override
    public int nColumns() {
        return this.ncols;
    }

    @Override
    public void getNewObjectArray() {
        this.column = new DataValueDescriptor[this.ncols];
    }

    @Override
    public DataValueDescriptor getColumn(int n) {
        if (n <= this.column.length) {
            return this.column[n - 1];
        }
        return null;
    }

    @Override
    public void setColumn(int n, DataValueDescriptor dataValueDescriptor) {
        if (n > this.column.length) {
            this.realloc(n);
        }
        this.column[n - 1] = dataValueDescriptor;
    }

    @Override
    public ExecRow getClone() {
        return this.getClone(null);
    }

    @Override
    public ExecRow getClone(FormatableBitSet formatableBitSet) {
        int n = this.column.length;
        ExecRow execRow = this.cloneMe();
        for (int i = 0; i < n; ++i) {
            if (formatableBitSet != null && !formatableBitSet.get(i + 1)) {
                execRow.setColumn(i + 1, this.column[i]);
                continue;
            }
            if (this.column[i] == null) continue;
            execRow.setColumn(i + 1, this.column[i].cloneValue(false));
        }
        return execRow;
    }

    @Override
    public ExecRow getNewNullRow() {
        int n = this.column.length;
        ExecRow execRow = this.cloneMe();
        for (int i = 0; i < n; ++i) {
            if (this.column[i] == null) continue;
            execRow.setColumn(i + 1, this.column[i].getNewNull());
        }
        return execRow;
    }

    ExecRow cloneMe() {
        return new ValueRow(this.ncols);
    }

    @Override
    public void resetRowArray() {
        for (int i = 0; i < this.column.length; ++i) {
            if (this.column[i] == null) continue;
            this.column[i] = this.column[i].recycle();
        }
    }

    @Override
    public final DataValueDescriptor cloneColumn(int n) {
        return this.column[n - 1].cloneValue(false);
    }

    public String toString() {
        String string = "{ ";
        for (int i = 0; i < this.column.length; ++i) {
            string = this.column[i] == null ? string + "null" : string + this.column[i].toString();
            if (i >= this.column.length - 1) continue;
            string = string + ", ";
        }
        string = string + " }";
        return string;
    }

    @Override
    public DataValueDescriptor[] getRowArray() {
        return this.column;
    }

    @Override
    public DataValueDescriptor[] getRowArrayClone() {
        int n = this.column.length;
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[n];
        for (int i = 0; i < n; ++i) {
            if (this.column[i] == null) continue;
            dataValueDescriptorArray[i] = this.column[i].cloneValue(false);
        }
        return dataValueDescriptorArray;
    }

    @Override
    public void setRowArray(DataValueDescriptor[] dataValueDescriptorArray) {
        this.column = dataValueDescriptorArray;
    }

    protected void realloc(int n) {
        DataValueDescriptor[] dataValueDescriptorArray = new DataValueDescriptor[n];
        System.arraycopy(this.column, 0, dataValueDescriptorArray, 0, this.column.length);
        this.column = dataValueDescriptorArray;
    }
}

