/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.filter;

import java.io.IOException;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.security.auth.Subject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.knox.gateway.audit.api.AuditServiceFactory;
import org.apache.knox.gateway.audit.api.Auditor;
import org.apache.knox.gateway.filter.AclParser;
import org.apache.knox.gateway.filter.PathAclParser;
import org.apache.knox.gateway.filter.PathAclsAuthorizationMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.security.GroupPrincipal;
import org.apache.knox.gateway.security.SubjectUtils;
import org.apache.knox.gateway.util.urltemplate.Matcher;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Template;

public class PathAclsAuthorizationFilter
implements Filter {
    private static PathAclsAuthorizationMessages log = (PathAclsAuthorizationMessages)MessagesFactory.get(PathAclsAuthorizationMessages.class);
    private static Auditor auditor = AuditServiceFactory.getAuditService().getAuditor("audit", "knox", "knox");
    private static String PATH_ACL_POSTFIX = ".path.acl";
    private String resourceRole;
    private String aclProcessingMode;
    private PathAclParser pathAclParser = new PathAclParser();
    private List<String> adminGroups = new ArrayList<String>();
    private List<String> adminUsers = new ArrayList<String>();
    private Map<String, String> rawRules = new HashMap<String, String>();

    public void init(FilterConfig filterConfig) {
        String pathResourceAcls;
        String adminUsers;
        this.resourceRole = this.getInitParameter(filterConfig, "resource.role");
        log.initializingForResourceRole(this.resourceRole);
        String adminGroups = filterConfig.getInitParameter("knox.admin.groups");
        if (adminGroups != null) {
            this.parseAdminGroupConfig(adminGroups);
        }
        if ((adminUsers = filterConfig.getInitParameter("knox.admin.users")) != null) {
            this.parseAdminUserConfig(adminUsers);
        }
        Enumeration rules = filterConfig.getInitParameterNames();
        while (rules.hasMoreElements()) {
            String rule = (String)rules.nextElement();
            if (!StringUtils.endsWithIgnoreCase((CharSequence)rule, (CharSequence)PATH_ACL_POSTFIX) || !StringUtils.containsIgnoreCase((CharSequence)rule, (CharSequence)this.resourceRole)) continue;
            this.rawRules.put(rule, filterConfig.getInitParameter(rule));
        }
        String pathAcls = this.getInitParameter(filterConfig, "path.acl");
        if (pathAcls != null) {
            this.rawRules.put("path.acl", pathAcls);
        }
        if ((pathResourceAcls = this.getInitParameter(filterConfig, this.resourceRole + ".path.acl")) != null) {
            this.rawRules.put(this.resourceRole + ".path.acl", pathResourceAcls);
        }
        this.aclProcessingMode = this.getInitParameter(filterConfig, this.resourceRole + ".path.acl.mode");
        if (this.aclProcessingMode == null) {
            this.aclProcessingMode = this.getInitParameter(filterConfig, "path.acl.mode");
            if (this.aclProcessingMode == null) {
                this.aclProcessingMode = "AND";
            }
        }
        log.aclProcessingMode(this.aclProcessingMode);
        this.pathAclParser.parsePathAcls(this.resourceRole, this.rawRules);
    }

    private String getInitParameter(FilterConfig filterConfig, String paramName) {
        return filterConfig.getInitParameter(paramName.toLowerCase(Locale.ROOT));
    }

    private void parseAdminGroupConfig(String groups) {
        Collections.addAll(this.adminGroups, groups.split(","));
    }

    private void parseAdminUserConfig(String users) {
        Collections.addAll(this.adminUsers, users.split(","));
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean accessGranted = this.enforceAclAuthorizationPolicy(request);
        log.accessGranted(accessGranted);
        String sourceUrl = (String)request.getAttribute("sourceRequestContextUrl");
        if (accessGranted) {
            auditor.audit("authorization", sourceUrl, "uri", "success");
            chain.doFilter(request, response);
        } else {
            auditor.audit("authorization", sourceUrl, "uri", "failure");
            this.sendForbidden((HttpServletResponse)response);
        }
    }

    protected boolean enforceAclAuthorizationPolicy(ServletRequest request) throws IOException {
        if (this.rawRules.isEmpty()) {
            return true;
        }
        try {
            String requestURL = ((HttpServletRequest)request).getRequestURL().toString();
            if (((HttpServletRequest)request).getQueryString() != null && StringUtils.isNotBlank((CharSequence)((HttpServletRequest)request).getQueryString())) {
                requestURL = requestURL + "?" + ((HttpServletRequest)request).getQueryString();
            }
            Template requestUrlTemplate = Parser.parseLiteral((String)requestURL);
            Map rulesMap = this.pathAclParser.getRulesMap();
            for (Map.Entry e : rulesMap.entrySet()) {
                Matcher.Match match = ((Matcher)e.getKey()).match(requestUrlTemplate);
                if (match == null) continue;
                return this.checkACLs((AclParser)e.getValue(), request);
            }
        }
        catch (URISyntaxException e) {
            log.errorParsingUrl(e.toString());
            throw new IOException(e);
        }
        return false;
    }

    private boolean checkACLs(AclParser aclParser, ServletRequest request) {
        if (aclParser.users.isEmpty() && aclParser.groups.isEmpty() && aclParser.ipv.getIPAddresses().isEmpty()) {
            return true;
        }
        boolean groupAccess = false;
        Subject subject = SubjectUtils.getCurrentSubject();
        String effectivePrincipalName = SubjectUtils.getEffectivePrincipalName((Subject)subject);
        log.effectivePrincipal(effectivePrincipalName);
        boolean userAccess = this.checkUserAcls(effectivePrincipalName, aclParser);
        log.effectivePrincipalHasAccess(userAccess);
        Object[] groups = subject.getPrincipals(GroupPrincipal.class).toArray();
        if (groups.length > 0) {
            groupAccess = this.checkGroupAcls(groups, aclParser);
            log.groupPrincipalHasAccess(groupAccess);
        } else if (aclParser.anyGroup && "AND".equals(this.aclProcessingMode)) {
            groupAccess = true;
        }
        log.remoteIPAddress(((HttpServletRequest)request).getRemoteAddr());
        boolean ipAddrAccess = this.checkRemoteIpAcls(((HttpServletRequest)request).getRemoteAddr(), aclParser);
        log.remoteIPAddressHasAccess(ipAddrAccess);
        if ("OR".equals(this.aclProcessingMode)) {
            if (aclParser.anyUser) {
                userAccess = false;
            }
            if (aclParser.anyGroup) {
                groupAccess = false;
            }
            if (aclParser.ipv.allowsAnyIP()) {
                ipAddrAccess = false;
            }
            return userAccess || groupAccess || ipAddrAccess;
        }
        if ("AND".equals(this.aclProcessingMode)) {
            return userAccess && groupAccess && ipAddrAccess;
        }
        return false;
    }

    private boolean checkRemoteIpAcls(String remoteAddr, AclParser aclParser) {
        if (remoteAddr == null) {
            return false;
        }
        boolean allowed = aclParser.ipv.validateIpAddress(remoteAddr);
        return allowed;
    }

    boolean checkUserAcls(String userName, AclParser aclParser) {
        boolean allowed = false;
        if (userName == null) {
            return false;
        }
        if (aclParser.anyUser) {
            allowed = true;
        } else if (aclParser.users.contains(userName)) {
            allowed = true;
        } else if (aclParser.users.contains("KNOX_ADMIN_USERS") && this.adminUsers.contains(userName)) {
            allowed = true;
        }
        return allowed;
    }

    boolean checkGroupAcls(Object[] userGroups, AclParser aclParser) {
        boolean allowed;
        if (userGroups == null) {
            return false;
        }
        if (aclParser.anyGroup) {
            allowed = true;
        } else {
            allowed = this.hasAllowedPrincipal(aclParser.groups, userGroups);
            if (!allowed && aclParser.groups.contains("KNOX_ADMIN_GROUPS")) {
                allowed = this.hasAllowedPrincipal(this.adminGroups, userGroups);
            }
        }
        return allowed;
    }

    private boolean hasAllowedPrincipal(List<String> allowed, Object[] userGroups) {
        boolean rc = false;
        for (Object userGroup : userGroups) {
            if (!allowed.contains(((Principal)userGroup).getName())) continue;
            rc = true;
            break;
        }
        return rc;
    }

    private void sendForbidden(HttpServletResponse res) {
        this.sendErrorCode(res, 403);
    }

    private void sendErrorCode(HttpServletResponse res, int code) {
        try {
            res.sendError(code);
        }
        catch (IOException e) {
            log.errorSendCode(e.toString());
        }
    }
}

