/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.sse;

import java.io.IOException;
import javax.servlet.AsyncContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.knox.gateway.SpiGatewayMessages;
import org.apache.knox.gateway.i18n.messages.MessagesFactory;
import org.apache.knox.gateway.sse.SSEResponse;

public class SSECallback
implements FutureCallback<SSEResponse> {
    protected static final SpiGatewayMessages LOG = (SpiGatewayMessages)MessagesFactory.get(SpiGatewayMessages.class);
    protected final AsyncContext asyncContext;
    private final HttpAsyncRequestProducer producer;
    protected final HttpServletResponse outboundResponse;

    public SSECallback(HttpServletResponse outboundResponse, AsyncContext asyncContext, HttpAsyncRequestProducer producer) {
        this.outboundResponse = outboundResponse;
        this.asyncContext = asyncContext;
        this.producer = producer;
    }

    public void completed(SSEResponse response) {
        this.releaseResources(true);
        LOG.sseConnectionDone();
    }

    public void failed(Exception ex) {
        try {
            if (!this.outboundResponse.isCommitted()) {
                this.outboundResponse.sendError(502, "Service connection error");
            }
        }
        catch (Exception e) {
            LOG.failedToSendErrorToClient(e);
        }
        finally {
            this.releaseResources(true);
            LOG.sseConnectionError(ex.getMessage());
        }
    }

    public void cancelled() {
        this.releaseResources(true);
        LOG.sseConnectionCancelled();
    }

    protected void releaseResources(boolean releaseContext) {
        try {
            this.producer.close();
        }
        catch (IOException e) {
            LOG.sseProducerCloseError(e);
        }
        finally {
            if (releaseContext) {
                this.asyncContext.complete();
            }
        }
    }
}

