/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.sse;

import java.util.Arrays;

public class SSEvent {
    private static final String SSE_DELIMITER = ":";
    private final String data;
    private final String event;
    private final String id;
    private final String comment;
    private final Long retry;

    public SSEvent(String data, String event, String id, String comment, Long retry) {
        this.data = data;
        this.event = event;
        this.id = id;
        this.comment = comment;
        this.retry = retry;
    }

    public String getData() {
        return this.data;
    }

    public String getEvent() {
        return this.event;
    }

    public String getId() {
        return this.id;
    }

    public String getComment() {
        return this.comment;
    }

    public Long getRetry() {
        return this.retry;
    }

    public static SSEvent fromString(String unprocessedEvent) {
        String id = null;
        String event = null;
        String data = null;
        String comment = null;
        Long retry = null;
        block14: for (String line : unprocessedEvent.split("\\R")) {
            String[] lineTokens = SSEvent.parseLine(line);
            switch (lineTokens[0]) {
                case "id": {
                    id = lineTokens[1];
                    continue block14;
                }
                case "event": {
                    event = lineTokens[1];
                    continue block14;
                }
                case "data": {
                    data = lineTokens[1];
                    continue block14;
                }
                case "comment": {
                    comment = lineTokens[1];
                    continue block14;
                }
                case "retry": {
                    retry = Long.parseLong(lineTokens[1]);
                    continue block14;
                }
            }
        }
        return new SSEvent(data, event, id, comment, retry);
    }

    private static String[] parseLine(String line) {
        String[] lineTokens = (String[])Arrays.stream(line.split(SSE_DELIMITER, 2)).map(String::trim).toArray(String[]::new);
        if (lineTokens[0].isEmpty()) {
            lineTokens[0] = "comment";
        }
        return lineTokens;
    }

    public String toString() {
        StringBuilder eventString = new StringBuilder();
        this.appendField(eventString, this.id, "id");
        this.appendField(eventString, this.event, "event");
        this.appendField(eventString, this.data, "data");
        this.appendField(eventString, this.retry, "retry");
        this.appendField(eventString, this.comment, "");
        return eventString.toString();
    }

    private void appendField(StringBuilder eventString, Object field, String prefix) {
        if (field != null) {
            if (eventString.length() != 0) {
                eventString.append('\n');
            }
            eventString.append(prefix);
            eventString.append(SSE_DELIMITER);
            eventString.append(field);
        }
    }
}

