/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.knox.gateway.service.definition.CustomDispatch;
import org.apache.knox.gateway.topology.Param;
import org.apache.knox.gateway.topology.Version;

public class Service {
    public static final String HA_ENABLED_PARAM = "haEnabled";
    private String role;
    private String name;
    private Version version;
    private Map<String, String> params = new LinkedHashMap<String, String>();
    private List<String> urls;
    private CustomDispatch dispatch;

    public String getRole() {
        return this.role;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public List<String> getUrls() {
        if (this.urls == null) {
            this.urls = new ArrayList<String>();
        }
        return this.urls;
    }

    public void setUrls(List<String> urls) {
        this.urls = urls;
    }

    public String getUrl() {
        if (!this.getUrls().isEmpty()) {
            return this.getUrls().get(0);
        }
        return null;
    }

    public void addUrl(String url) {
        this.getUrls().add(url);
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Collection<Param> getParamsList() {
        ArrayList<Param> paramList = new ArrayList<Param>();
        for (Map.Entry<String, String> entry : this.params.entrySet()) {
            Param p = new Param();
            p.setName(entry.getKey());
            p.setValue(entry.getValue());
            paramList.add(p);
        }
        return paramList;
    }

    public void setParamsList(Collection<Param> params) {
        if (params != null) {
            for (Param param : params) {
                this.addParam(param);
            }
        }
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public void addParam(Param param) {
        this.params.put(param.getName(), param.getValue());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Service)) {
            return false;
        }
        Service that = (Service)object;
        return new EqualsBuilder().append((Object)this.name, (Object)that.name).append((Object)this.role, (Object)that.role).append((Object)this.version, (Object)that.version).append(this.getUrls().stream().sorted().collect(Collectors.toList()), that.getUrls().stream().sorted().collect(Collectors.toList())).append(this.params, that.params).build();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append((Object)this.name).append((Object)this.role).append((Object)this.version).append(this.urls).append(this.params).build();
    }

    public CustomDispatch getDispatch() {
        return this.dispatch;
    }

    public void addDispatch(CustomDispatch dispatch) {
        this.dispatch = dispatch;
    }
}

