/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cluster;

import io.netty.util.internal.ThrowableUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.engine.spark.utils.BuildUtils$;
import org.apache.kylin.job.exception.ShellException;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class SchedulerInfoCmdHelper$
implements Logging {
    public static SchedulerInfoCmdHelper$ MODULE$;
    private final boolean useHttps;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SchedulerInfoCmdHelper$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private boolean useHttps() {
        return this.useHttps;
    }

    public String schedulerInfo() {
        Iterable cmds = (Iterable)this.getSocketAddress().map((Function1 & Serializable & scala.Serializable)address -> MODULE$.genCmd((String)address._1(), address._2$mcI$sp()), Iterable$.MODULE$.canBuildFrom());
        Iterable results = (Iterable)cmds.map((Function1 & Serializable & scala.Serializable)cmd -> {
            Tuple2 tuple2;
            try {
                tuple2 = MODULE$.execute((String)cmd);
            }
            catch (Throwable throwable) {
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)ThrowableUtil.stackTraceToString((Throwable)throwable));
            }
            return tuple2;
        }, Iterable$.MODULE$.canBuildFrom());
        Iterable tuples = (Iterable)results.filter((Function1 & Serializable & scala.Serializable)result -> BoxesRunTime.boxToBoolean((boolean)SchedulerInfoCmdHelper$.$anonfun$schedulerInfo$3(result)));
        if (tuples.isEmpty()) {
            String errors = ((TraversableOnce)tuples.map((Function1 & Serializable & scala.Serializable)x$1 -> (String)x$1._2(), Iterable$.MODULE$.canBuildFrom())).mkString("\n");
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Error occurred when get scheduler info from cmd ").append(cmds).toString());
            throw new RuntimeException(errors);
        }
        Predef$.MODULE$.require(tuples.size() == 1);
        return (String)((Tuple2)tuples.head())._2();
    }

    public Map<String, Object> getSocketAddress() {
        InetSocketAddress[] inetSocketAddressArray;
        YarnConfiguration conf = BuildUtils$.MODULE$.getCurrentYarnConfiguration();
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            Object[] haIds = HAUtil.getRMHAIds((Configuration)conf).toArray();
            Predef$.MODULE$.require(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(haIds)).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Ha ids is empty, please check your yarn-site.xml.");
            inetSocketAddressArray = this.useHttps() ? (InetSocketAddress[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(haIds)).map((Function1 & Serializable & scala.Serializable)id -> conf.getSocketAddr(new StringBuilder(42).append("yarn.resourcemanager.webapp.https.address").append(".").append(id).toString(), "0.0.0.0:8090", 8044), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InetSocketAddress.class))) : (InetSocketAddress[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(haIds)).map((Function1 & Serializable & scala.Serializable)id -> conf.getSocketAddr(new StringBuilder(36).append("yarn.resourcemanager.webapp.address").append(".").append(id).toString(), "0.0.0.0:8088", 8042), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(InetSocketAddress.class)));
        } else {
            inetSocketAddressArray = this.useHttps() ? (InetSocketAddress[])((Object[])new InetSocketAddress[]{conf.getSocketAddr("yarn.resourcemanager.webapp.https.address", "0.0.0.0:8090", 8044)}) : (InetSocketAddress[])((Object[])new InetSocketAddress[]{conf.getSocketAddr("yarn.resourcemanager.webapp.address", "0.0.0.0:8088", 8042)});
        }
        InetSocketAddress[] addresses = inetSocketAddressArray;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])addresses)).map((Function1 & Serializable & scala.Serializable)address -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)address.getHostName()), (Object)BoxesRunTime.boxToInteger((int)address.getPort())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
    }

    public String genCmd(String hostName, int port) {
        String uri = this.useHttps() ? new StringBuilder(33).append("https://").append(hostName).append(":").append(port).append("/ws/v1/cluster/scheduler").toString() : new StringBuilder(32).append("http://").append(hostName).append(":").append(port).append("/ws/v1/cluster/scheduler").toString();
        return new StringBuilder(27).append("curl -k --negotiate -u : \"").append(uri).append("\"").toString();
    }

    public Tuple2<Object, String> execute(String command) {
        Tuple2 tuple2;
        try {
            String[] cmd = new String[3];
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                cmd[0] = "cmd.exe";
                cmd[1] = "/C";
            } else {
                cmd[0] = "/bin/bash";
                cmd[1] = "-c";
            }
            cmd[2] = command;
            ProcessBuilder builder = new ProcessBuilder(cmd);
            builder.environment().putAll(System.getenv());
            Process proc = builder.start();
            scala.collection.mutable.StringBuilder result = new scala.collection.mutable.StringBuilder();
            BufferedReader inReader = new BufferedReader(new InputStreamReader(proc.getInputStream(), Charset.defaultCharset()));
            ObjectRef line = ObjectRef.create((Object)inReader.readLine());
            while ((String)line.elem != null) {
                result.append((String)line.elem).append('\n');
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append("stdout\t").append((String)line$1.elem).toString());
                line.elem = inReader.readLine();
            }
            BufferedReader errorReader = new BufferedReader(new InputStreamReader(proc.getErrorStream(), Charset.defaultCharset()));
            line.elem = errorReader.readLine();
            while ((String)line.elem != null) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append("stderr\t").append((String)line$1.elem).toString());
                line.elem = errorReader.readLine();
            }
            try {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Thread wait for executing command ").append(command).toString());
                int exitCode = proc.waitFor();
                tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)exitCode), (Object)result.toString());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
        }
        catch (Exception e) {
            throw new ShellException(e);
        }
        return tuple2;
    }

    public static final /* synthetic */ boolean $anonfun$schedulerInfo$3(Tuple2 result) {
        return result._1$mcI$sp() == 0 && JsonUtil.isJson((String)result._2());
    }

    private SchedulerInfoCmdHelper$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.useHttps = YarnConfiguration.useHttps((Configuration)BuildUtils$.MODULE$.getCurrentYarnConfiguration());
    }
}

