/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class QueryTrace {
    public static final String SQL_TRANSFORMATION = "SQL_TRANSFORMATION";
    public static final String SQL_PARSE_AND_OPTIMIZE = "SQL_PARSE_AND_OPTIMIZE";
    public static final String CUBE_MATCHING = "CUBE_MATCHING";
    public static final String PREPARE_AND_SUBMIT_JOB = "PREPARE_AND_SUBMIT_JOB";
    public static final String WAIT_FOR_EXECUTION = "WAIT_FOR_EXECUTION";
    public static final String EXECUTION = "EXECUTION";
    public static final String FETCH_RESULT = "FETCH_RESULT";
    public static final String CALCULATE_STAT = "CALCULATE_STAT";
    static final String PREPARATION = "PREPARATION";
    static final Map<String, String> SPAN_GROUPS = new HashMap<String, String>();
    private List<Span> spans = new LinkedList<Span>();

    public Optional<Span> getLastSpan() {
        return this.spans.isEmpty() ? Optional.empty() : Optional.of(this.spans.get(this.spans.size() - 1));
    }

    public void endLastSpan() {
        this.getLastSpan().ifPresent(span -> {
            if (span.duration == -1L) {
                span.duration = System.currentTimeMillis() - span.start;
            }
        });
    }

    public void startSpan(String name) {
        this.endLastSpan();
        this.spans.add(new Span(name, System.currentTimeMillis()));
    }

    public void appendSpan(String name, long duration) {
        this.spans.add(new Span(name, this.getLastSpan().map(span -> span.getStart() + span.getDuration()).orElse(System.currentTimeMillis()), duration));
    }

    public void amendLast(String name, long endAt) {
        for (int i = this.spans.size() - 1; i >= 0; --i) {
            if (!this.spans.get((int)i).name.equals(name)) continue;
            this.spans.get((int)i).duration = endAt - this.spans.get((int)i).start;
            return;
        }
    }

    public List<Span> spans() {
        return this.spans;
    }

    static {
        SPAN_GROUPS.put(SQL_TRANSFORMATION, PREPARATION);
        SPAN_GROUPS.put(SQL_PARSE_AND_OPTIMIZE, PREPARATION);
        SPAN_GROUPS.put(CUBE_MATCHING, PREPARATION);
    }

    public static class Span {
        String name;
        String group;
        long start;
        long duration = -1L;

        public long getDuration() {
            return this.duration;
        }

        public long getStart() {
            return this.start;
        }

        public String getGroup() {
            return this.group;
        }

        public String getName() {
            return this.name;
        }

        public void setDuration(long duration) {
            this.duration = duration;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setStart(long start) {
            this.start = start;
        }

        public Span(String name, long start, long duration) {
            this.name = name;
            this.start = start;
            this.duration = duration;
            this.group = SPAN_GROUPS.get(name);
        }

        public Span(String name, long start) {
            this.name = name;
            this.start = start;
            this.group = SPAN_GROUPS.get(name);
        }
    }
}

