/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.livy;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.tool.shaded.org.apache.commons.io.IOUtils;
import org.apache.kylin.tool.shaded.org.apache.http.HttpResponse;
import org.apache.kylin.tool.shaded.org.apache.http.client.methods.HttpDelete;
import org.apache.kylin.tool.shaded.org.apache.http.client.methods.HttpGet;
import org.apache.kylin.tool.shaded.org.apache.http.client.methods.HttpPost;
import org.apache.kylin.tool.shaded.org.apache.http.client.methods.HttpRequestBase;
import org.apache.kylin.tool.shaded.org.apache.http.entity.StringEntity;
import org.apache.kylin.tool.shaded.org.apache.http.impl.client.DefaultHttpClient;
import org.apache.kylin.tool.shaded.org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.kylin.tool.shaded.org.apache.http.params.BasicHttpParams;
import org.apache.kylin.tool.shaded.org.apache.http.params.HttpConnectionParams;

public class LivyRestClient {
    private int httpConnectionTimeoutMs = 30000;
    private int httpSocketTimeoutMs = 120000;
    protected String baseUrl;
    protected DefaultHttpClient client;
    private final KylinConfig config = KylinConfig.getInstanceFromEnv();

    public LivyRestClient() {
        this.init();
    }

    private void init() {
        BasicHttpParams httpParams = new BasicHttpParams();
        HttpConnectionParams.setSoTimeout(httpParams, this.httpSocketTimeoutMs);
        HttpConnectionParams.setConnectionTimeout(httpParams, this.httpConnectionTimeoutMs);
        PoolingClientConnectionManager cm = new PoolingClientConnectionManager();
        cm.setDefaultMaxPerRoute(this.config.getRestClientDefaultMaxPerRoute());
        cm.setMaxTotal(this.config.getRestClientMaxTotal());
        this.baseUrl = this.config.getLivyUrl();
        this.client = new DefaultHttpClient(cm, httpParams);
    }

    public String livySubmitJobBatches(String jobJson) throws IOException {
        String url = this.baseUrl + "/batches";
        HttpPost post = this.newPost(url);
        String json = jobJson.replace("`", this.config.getLivyRestApiBacktick());
        post.setEntity(new StringEntity(json, "UTF-8"));
        HttpResponse response = this.client.execute(post);
        String content = this.getContent(response);
        if (response.getStatusLine().getStatusCode() != 201) {
            throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + " with url " + url + "\n");
        }
        return content;
    }

    public String livyGetJobStatusBatches(String jobId) throws IOException {
        String url = this.baseUrl + "/batches/" + jobId;
        HttpGet get = new HttpGet(url);
        HttpResponse response = this.client.execute(get);
        String content = this.getContent(response);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + " with url " + url + "\n");
        }
        return content;
    }

    public String livyDeleteBatches(String jobId) throws IOException {
        String url = this.baseUrl + "/batches/" + jobId;
        HttpDelete delete = new HttpDelete(url);
        HttpResponse response = this.client.execute(delete);
        String content = this.getContent(response);
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new IOException("Invalid response " + response.getStatusLine().getStatusCode() + " with url " + url + "\n");
        }
        return content;
    }

    private HttpPost newPost(String url) {
        HttpPost post = new HttpPost(url);
        this.addHttpHeaders(post);
        return post;
    }

    private void addHttpHeaders(HttpRequestBase method) {
        method.addHeader("Accept", "application/json, text/plain, */*");
        method.addHeader("Content-Type", "application/json");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContent(HttpResponse response) throws IOException {
        InputStreamReader reader = null;
        BufferedReader rd = null;
        StringBuffer result = new StringBuffer();
        try {
            String line;
            reader = new InputStreamReader(response.getEntity().getContent(), "UTF-8");
            rd = new BufferedReader(reader);
            while ((line = rd.readLine()) != null) {
                result.append(line);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(rd);
            throw throwable;
        }
        IOUtils.closeQuietly(reader);
        IOUtils.closeQuietly(rd);
        return result.toString();
    }
}

