/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.metrics.metrics2;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.json.MetricsModule;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.metrics.metrics2.CodahaleReporter;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.Module;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.databind.ObjectWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonFileMetricsReporter
implements CodahaleReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonFileMetricsReporter.class);
    private final MetricRegistry metricRegistry;
    private final ObjectWriter jsonWriter;
    private final ScheduledExecutorService executorService;
    private final KylinConfig conf;
    private final long frequency;
    private final String pathString;
    private final Path path;

    public JsonFileMetricsReporter(MetricRegistry registry, KylinConfig conf) {
        this.metricRegistry = registry;
        this.jsonWriter = new ObjectMapper().registerModule((Module)new MetricsModule(TimeUnit.MILLISECONDS, TimeUnit.MILLISECONDS, false)).writerWithDefaultPrettyPrinter();
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.conf = conf;
        this.frequency = KylinConfig.getInstanceFromEnv().getMetricsReporterFrequency();
        this.pathString = KylinConfig.getInstanceFromEnv().getMetricsFileLocation();
        this.path = new Path(this.pathString);
    }

    @Override
    public void start() {
        Object fs;
        Path tmpPath = new Path(this.pathString + ".tmp");
        URI tmpPathURI = tmpPath.toUri();
        try {
            fs = tmpPathURI.getScheme() == null && tmpPathURI.getAuthority() == null ? FileSystem.getLocal((Configuration)new Configuration()) : FileSystem.get((URI)tmpPathURI, (Configuration)new Configuration());
        }
        catch (IOException e) {
            LOGGER.error("Unable to access filesystem for path " + tmpPath + ". Aborting reporting", e);
            return;
        }
        Runnable task = new Runnable((FileSystem)fs, tmpPath){
            final /* synthetic */ FileSystem val$fs;
            final /* synthetic */ Path val$tmpPath;
            {
                this.val$fs = fileSystem;
                this.val$tmpPath = path;
            }

            @Override
            public void run() {
                try {
                    String json = null;
                    try {
                        json = JsonFileMetricsReporter.this.jsonWriter.writeValueAsString(JsonFileMetricsReporter.this.metricRegistry);
                    }
                    catch (JsonProcessingException e) {
                        LOGGER.error("Unable to convert json to string ", e);
                        return;
                    }
                    this.val$fs.delete(this.val$tmpPath, true);
                    try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)this.val$fs.create(this.val$tmpPath, true), StandardCharsets.UTF_8));){
                        bw.write(json);
                        this.val$fs.setPermission(this.val$tmpPath, FsPermission.createImmutable((short)420));
                    }
                    catch (IOException e) {
                        LOGGER.error("Unable to write to temp file " + this.val$tmpPath, e);
                        return;
                    }
                    try {
                        this.val$fs.rename(this.val$tmpPath, JsonFileMetricsReporter.this.path);
                        this.val$fs.setPermission(JsonFileMetricsReporter.this.path, FsPermission.createImmutable((short)420));
                    }
                    catch (IOException e) {
                        LOGGER.error("Unable to rename temp file " + this.val$tmpPath + " to " + JsonFileMetricsReporter.this.pathString, e);
                        return;
                    }
                }
                catch (Throwable t) {
                    LOGGER.error("Error executing scheduled task ", t);
                }
            }
        };
        this.executorService.scheduleWithFixedDelay(task, 0L, this.frequency, TimeUnit.MILLISECONDS);
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }
}

