/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cube.inmemcubing2;

import java.util.NavigableMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.kylin.cube.inmemcubing.CuboidResult;
import org.apache.kylin.cube.inmemcubing2.ICuboidCollectorWithCallBack;
import org.apache.kylin.cube.inmemcubing2.ICuboidResultListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCuboidCollectorWithCallBack
implements ICuboidCollectorWithCallBack {
    private static Logger logger = LoggerFactory.getLogger(DefaultCuboidCollectorWithCallBack.class);
    final ConcurrentNavigableMap<Long, CuboidResult> result = new ConcurrentSkipListMap<Long, CuboidResult>();
    final ICuboidResultListener listener;

    public DefaultCuboidCollectorWithCallBack(ICuboidResultListener listener) {
        this.listener = listener;
    }

    @Override
    public void collectAndNotify(CuboidResult cuboidResult) {
        logger.info("collecting CuboidResult cuboid id:" + cuboidResult.cuboidId);
        this.result.put(cuboidResult.cuboidId, cuboidResult);
        if (this.listener != null) {
            this.listener.finish(cuboidResult);
        }
    }

    @Override
    public NavigableMap<Long, CuboidResult> getAllResult() {
        return this.result;
    }
}

