/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.mr.common;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.cube.CubeSegment;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.cube.cuboid.CuboidModeEnum;
import org.apache.kylin.cube.cuboid.CuboidScheduler;
import org.apache.kylin.cube.cuboid.TreeCuboidScheduler;
import org.apache.kylin.engine.mr.common.CuboidStatsReaderUtil;

public class CuboidSchedulerUtil {
    public static CuboidScheduler getCuboidSchedulerByMode(CubeSegment segment, String cuboidModeName) {
        if (cuboidModeName == null) {
            return segment.getCuboidScheduler();
        }
        return CuboidSchedulerUtil.getCuboidSchedulerByMode(segment, CuboidModeEnum.getByModeName(cuboidModeName));
    }

    public static CuboidScheduler getCuboidSchedulerByMode(CubeSegment segment, CuboidModeEnum cuboidMode) {
        if (cuboidMode == CuboidModeEnum.CURRENT || cuboidMode == null) {
            return segment.getCuboidScheduler();
        }
        return CuboidSchedulerUtil.getCuboidScheduler(segment, segment.getCubeInstance().getCuboidsByMode(cuboidMode));
    }

    public static CuboidScheduler getCuboidScheduler(CubeSegment segment, Set<Long> cuboidSet) {
        try {
            Map<Long, Long> cuboidsWithRowCnt = CuboidStatsReaderUtil.readCuboidStatsFromSegment(cuboidSet, segment);
            TreeCuboidScheduler.CuboidCostComparator comparator = cuboidsWithRowCnt == null ? Cuboid.cuboidSelectComparator : new TreeCuboidScheduler.CuboidCostComparator(cuboidsWithRowCnt);
            return new TreeCuboidScheduler(segment.getCubeDesc(), Lists.newArrayList(cuboidSet), comparator);
        }
        catch (IOException e) {
            throw new RuntimeException("Fail to cube stats for segment" + segment + " due to " + e);
        }
    }
}

