/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.NResourceDetectStep;
import org.apache.kylin.engine.spark.job.NSparkCubingStep;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.job.NSparkMergingStep;
import org.apache.kylin.engine.spark.job.NSparkUpdateMetaAndCleanupAfterMergeStep;
import org.apache.kylin.engine.spark.job.NTableSamplingStep;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;

public enum JobStepType {
    RESOURCE_DETECT{

        @Override
        public AbstractExecutable create(DefaultChainedExecutable parent, KylinConfig config) {
            return new NResourceDetectStep(parent);
        }
    }
    ,
    SAMPLING{

        @Override
        public AbstractExecutable create(DefaultChainedExecutable parent, KylinConfig config) {
            return new NTableSamplingStep(config.getSparkSampleTableClassName());
        }
    }
    ,
    CUBING{

        @Override
        public AbstractExecutable create(DefaultChainedExecutable parent, KylinConfig config) {
            return new NSparkCubingStep(config.getSparkBuildClassName());
        }
    }
    ,
    MERGING{

        @Override
        public AbstractExecutable create(DefaultChainedExecutable parent, KylinConfig config) {
            return new NSparkMergingStep(config.getSparkMergeClassName());
        }
    }
    ,
    CLEAN_UP_AFTER_MERGE{

        @Override
        public AbstractExecutable create(DefaultChainedExecutable parent, KylinConfig config) {
            NSparkUpdateMetaAndCleanupAfterMergeStep step = new NSparkUpdateMetaAndCleanupAfterMergeStep();
            return step;
        }
    }
    ,
    MERGE_STATISTICS{

        @Override
        protected AbstractExecutable create(DefaultChainedExecutable parent, KylinConfig config) {
            return null;
        }
    }
    ,
    OPTIMIZING{

        @Override
        protected AbstractExecutable create(DefaultChainedExecutable parent, KylinConfig config) {
            return null;
        }
    }
    ,
    FILTER_RECOMMEND_CUBOID{

        @Override
        protected AbstractExecutable create(DefaultChainedExecutable parent, KylinConfig config) {
            return null;
        }
    };


    protected abstract AbstractExecutable create(DefaultChainedExecutable var1, KylinConfig var2);

    public AbstractExecutable createStep(DefaultChainedExecutable parent, KylinConfig config) {
        AbstractExecutable step = this.create(parent, config);
        this.addParam(parent, step, config);
        return step;
    }

    protected void addParam(DefaultChainedExecutable parent, AbstractExecutable step, KylinConfig config) {
        step.setParams(parent.getParams());
        step.setProject(parent.getProject());
        step.setTargetSubject(parent.getTargetSubject());
        step.setJobType(parent.getJobTypeEnum());
        parent.addTask(step);
        if (step instanceof NSparkExecutable) {
            ((NSparkExecutable)step).setDistMetaUrl(config.getJobTmpMetaStoreUrl(parent.getProject(), step.getId()));
        }
    }
}

