/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.job.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.sql.SqlDialect;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.SourceDialect;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.IJoinedFlatTableDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;

public class FlatTableSqlQuoteUtils {
    private static KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
    private static final Map<String, SqlDialect> sqlDialectMap = new TreeMap<String, SqlDialect>(String.CASE_INSENSITIVE_ORDER);
    private static SqlDialect defaultDialect = null;
    public static final SqlDialect NON_QUOTE_DIALECT = new SqlDialect(SqlDialect.EMPTY_CONTEXT);
    static final SqlDialect HIVE_DIALECT = new SqlDialect(SqlDialect.EMPTY_CONTEXT.withIdentifierQuoteString("`"));

    private FlatTableSqlQuoteUtils() {
    }

    private static synchronized void setQuote() {
        if (defaultDialect != null) {
            return;
        }
        defaultDialect = sqlDialectMap.getOrDefault(kylinConfig.getFactTableDialect(), NON_QUOTE_DIALECT);
    }

    public static String quoteIdentifier(SourceDialect sourceDialect, String identifier) {
        if (!kylinConfig.enableHiveDdlQuote()) {
            return identifier;
        }
        SqlDialect specificSqlDialect = sqlDialectMap.get(sourceDialect.name());
        if (specificSqlDialect != null) {
            return specificSqlDialect.quoteIdentifier(identifier);
        }
        FlatTableSqlQuoteUtils.setQuote();
        return defaultDialect.quoteIdentifier(identifier);
    }

    public static String quoteIdentifier(String identifier, SqlDialect specificSqlDialect) {
        if (!kylinConfig.enableHiveDdlQuote()) {
            return identifier;
        }
        if (specificSqlDialect != null) {
            return specificSqlDialect.quoteIdentifier(identifier);
        }
        FlatTableSqlQuoteUtils.setQuote();
        return defaultDialect.quoteIdentifier(identifier);
    }

    public static String quoteTableIdentity(TableRef tableRef, SqlDialect specificSqlDialect) {
        return FlatTableSqlQuoteUtils.quoteTableIdentity(tableRef.getTableDesc().getDatabase(), tableRef.getTableName(), specificSqlDialect);
    }

    public static String quoteTableIdentity(String database, String table, SqlDialect specificSqlDialect) {
        String dbName = FlatTableSqlQuoteUtils.quoteIdentifier(database, specificSqlDialect);
        String tableName = FlatTableSqlQuoteUtils.quoteIdentifier(table, specificSqlDialect);
        return String.format(Locale.ROOT, "%s.%s", dbName, tableName).toUpperCase(Locale.ROOT);
    }

    public static String quoteIdentifierInSqlExpr(IJoinedFlatTableDesc flatDesc, String sqlExpr, SqlDialect sqlDialect) {
        FlatTableSqlQuoteUtils.setQuote();
        Map<String, String> tabToAliasMap = FlatTableSqlQuoteUtils.buildTableToTableAliasMap(flatDesc);
        Map<String, Map<String, String>> tabToColsMap = FlatTableSqlQuoteUtils.buildTableToColumnsMap(flatDesc);
        boolean tableMatched = false;
        for (String table : tabToAliasMap.keySet()) {
            List<String> tabAliasPatterns;
            String tabAlias;
            List<String> tabPatterns;
            if (FlatTableSqlQuoteUtils.isIdentifierNeedToQuote(sqlExpr, table, tabPatterns = FlatTableSqlQuoteUtils.getTableNameOrAliasPatterns(table))) {
                sqlExpr = FlatTableSqlQuoteUtils.quoteIdentifier(sqlExpr, table, tabPatterns, sqlDialect);
                tableMatched = true;
            }
            if (FlatTableSqlQuoteUtils.isIdentifierNeedToQuote(sqlExpr, tabAlias = tabToAliasMap.get(table), tabAliasPatterns = FlatTableSqlQuoteUtils.getTableNameOrAliasPatterns(tabAlias))) {
                sqlExpr = FlatTableSqlQuoteUtils.quoteIdentifier(sqlExpr, tabAlias, tabAliasPatterns, sqlDialect);
                tableMatched = true;
            }
            if (tableMatched) {
                Set<String> columns = FlatTableSqlQuoteUtils.listColumnsInTable(table, tabToColsMap);
                for (String column : columns) {
                    List<String> colAliasPattern;
                    String colAlias;
                    List<String> colPatterns;
                    if (FlatTableSqlQuoteUtils.isIdentifierNeedToQuote(sqlExpr, column, colPatterns = FlatTableSqlQuoteUtils.getColumnNameOrAliasPatterns(column))) {
                        sqlExpr = FlatTableSqlQuoteUtils.quoteIdentifier(sqlExpr, column, colPatterns, sqlDialect);
                    }
                    if (!FlatTableSqlQuoteUtils.columnHasAlias(table, column, tabToColsMap) || !FlatTableSqlQuoteUtils.isIdentifierNeedToQuote(sqlExpr, colAlias = FlatTableSqlQuoteUtils.getColumnAlias(table, column, tabToColsMap), colAliasPattern = FlatTableSqlQuoteUtils.getColumnNameOrAliasPatterns(colAlias))) continue;
                    sqlExpr = FlatTableSqlQuoteUtils.quoteIdentifier(sqlExpr, colAlias, colPatterns, sqlDialect);
                }
            }
            tableMatched = false;
        }
        return sqlExpr;
    }

    public static String quoteIdentifierInSqlExpr(TableDesc tableDesc, String sqlExpr, SqlDialect sqlDialect) {
        String table = tableDesc.getName();
        boolean tableMatched = false;
        List<String> tabPatterns = FlatTableSqlQuoteUtils.getTableNameOrAliasPatterns(table);
        if (FlatTableSqlQuoteUtils.isIdentifierNeedToQuote(sqlExpr, table, tabPatterns)) {
            sqlExpr = FlatTableSqlQuoteUtils.quoteIdentifier(sqlExpr, table, tabPatterns, sqlDialect);
            tableMatched = true;
        }
        if (tableMatched) {
            for (ColumnDesc columnDesc : tableDesc.getColumns()) {
                List<String> colPatterns;
                String column = columnDesc.getName();
                if (!FlatTableSqlQuoteUtils.isIdentifierNeedToQuote(sqlExpr, column, colPatterns = FlatTableSqlQuoteUtils.getColumnNameOrAliasPatterns(column))) continue;
                sqlExpr = FlatTableSqlQuoteUtils.quoteIdentifier(sqlExpr, column, colPatterns, sqlDialect);
            }
        }
        return sqlExpr;
    }

    static List<String> getTableNameOrAliasPatterns(String tableName) {
        ArrayList<String> patterns = Lists.newArrayList();
        patterns.add("([+\\-*/%&|^=><\\s,(])(" + tableName.trim() + ")(\\.)");
        patterns.add("([\\.\\s])(" + tableName.trim() + ")([,\\s)])");
        patterns.add("(^)(" + tableName.trim() + ")([\\.])");
        return patterns;
    }

    static List<String> getColumnNameOrAliasPatterns(String colName) {
        ArrayList<String> patterns = Lists.newArrayList();
        patterns.add("([\\.\\s(])(" + colName.trim() + ")([+\\-*/%&|^=><\\s,)])");
        patterns.add("(^)(" + colName.trim() + ")([+\\-*/%&|^=><\\s,)])");
        return patterns;
    }

    static String quoteIdentifier(String sqlExpr, String identifier, List<String> identifierPatterns) {
        return FlatTableSqlQuoteUtils.quoteIdentifier(sqlExpr, identifier, identifierPatterns, null);
    }

    static String quoteIdentifier(String sqlExpr, String identifier, List<String> identifierPatterns, SqlDialect sqlDialect) {
        String quotedIdentifier = FlatTableSqlQuoteUtils.quoteIdentifier(identifier.trim(), sqlDialect);
        for (String pattern : identifierPatterns) {
            Matcher matcher = Pattern.compile(pattern, 34).matcher(sqlExpr);
            if (!matcher.find()) continue;
            sqlExpr = matcher.replaceAll("$1" + quotedIdentifier + "$3");
        }
        return sqlExpr;
    }

    static boolean isIdentifierNeedToQuote(String sqlExpr, String identifier, List<String> identifierPatterns) {
        if (StringUtils.isBlank(sqlExpr) || StringUtils.isBlank(identifier)) {
            return false;
        }
        for (String pattern : identifierPatterns) {
            if (!Pattern.compile(pattern, 34).matcher(sqlExpr).find()) continue;
            return true;
        }
        return false;
    }

    private static Map<String, String> buildTableToTableAliasMap(IJoinedFlatTableDesc flatDesc) {
        HashMap<String, String> map = Maps.newHashMap();
        List<TblColRef> colRefs = flatDesc.getAllColumns();
        for (TblColRef colRef : colRefs) {
            String tableName = colRef.getTableRef().getTableName();
            String alias = colRef.getTableAlias();
            map.put(tableName, alias);
        }
        return map;
    }

    private static Map<String, Map<String, String>> buildTableToColumnsMap(IJoinedFlatTableDesc flatDesc) {
        HashMap<String, Map<String, String>> map = Maps.newHashMap();
        List<TblColRef> colRefs = flatDesc.getAllColumns();
        for (TblColRef colRef : colRefs) {
            String colName = colRef.getName();
            String tableName = colRef.getTableRef().getTableName();
            String colAlias = colRef.getTableAlias() + "_" + colRef.getName();
            if (map.containsKey(tableName)) {
                ((Map)map.get(tableName)).put(colName, colAlias);
                continue;
            }
            HashMap<String, String> colToAliasMap = Maps.newHashMap();
            colToAliasMap.put(colName, colAlias);
            map.put(tableName, colToAliasMap);
        }
        return map;
    }

    private static Map<String, String> getColToColAliasMapInTable(String tableName, Map<String, Map<String, String>> tableToColumnsMap) {
        if (tableToColumnsMap.containsKey(tableName)) {
            return tableToColumnsMap.get(tableName);
        }
        return Maps.newHashMap();
    }

    private static Set<String> listColumnsInTable(String tableName, Map<String, Map<String, String>> tableToColumnsMap) {
        Map<String, String> colToAliasMap = FlatTableSqlQuoteUtils.getColToColAliasMapInTable(tableName, tableToColumnsMap);
        return colToAliasMap.keySet();
    }

    private static boolean columnHasAlias(String tableName, String columnName, Map<String, Map<String, String>> tableToColumnsMap) {
        Map<String, String> colToAliasMap = FlatTableSqlQuoteUtils.getColToColAliasMapInTable(tableName, tableToColumnsMap);
        return colToAliasMap.containsKey(columnName);
    }

    private static String getColumnAlias(String tableName, String columnName, Map<String, Map<String, String>> tableToColumnsMap) {
        Map<String, String> colToAliasMap = FlatTableSqlQuoteUtils.getColToColAliasMapInTable(tableName, tableToColumnsMap);
        if (colToAliasMap.containsKey(columnName)) {
            return colToAliasMap.get(columnName);
        }
        return null;
    }

    static {
        sqlDialectMap.put("default", SqlDialect.CALCITE);
        sqlDialectMap.put("calcite", SqlDialect.CALCITE);
        sqlDialectMap.put("greenplum", SqlDialect.DatabaseProduct.POSTGRESQL.getDialect());
        sqlDialectMap.put("postgresql", SqlDialect.DatabaseProduct.POSTGRESQL.getDialect());
        sqlDialectMap.put("mysql", SqlDialect.DatabaseProduct.MYSQL.getDialect());
        sqlDialectMap.put("mssql", SqlDialect.DatabaseProduct.MSSQL.getDialect());
        sqlDialectMap.put("oracle", SqlDialect.DatabaseProduct.ORACLE.getDialect());
        sqlDialectMap.put("vertica", SqlDialect.DatabaseProduct.VERTICA.getDialect());
        sqlDialectMap.put("redshift", SqlDialect.DatabaseProduct.REDSHIFT.getDialect());
        sqlDialectMap.put("hive", HIVE_DIALECT);
        sqlDialectMap.put("h2", SqlDialect.DatabaseProduct.H2.getDialect());
    }
}

