/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure.percentile;

import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.kylin.tool.shaded.com.tdunning.math.stats.AVLTreeDigest;
import org.apache.kylin.tool.shaded.com.tdunning.math.stats.TDigest;

public class PercentileCounter
implements Serializable {
    private static final double INVALID_QUANTILE_RATIO = -1.0;
    double compression;
    double quantileRatio;
    transient TDigest registers;

    public PercentileCounter(double compression) {
        this(compression, -1.0);
    }

    public PercentileCounter(PercentileCounter another) {
        this(another.compression, another.quantileRatio);
        this.merge(another);
    }

    public PercentileCounter(double compression, double quantileRatio) {
        this.compression = compression;
        this.quantileRatio = quantileRatio;
        this.reInitRegisters();
    }

    private void reInitRegisters() {
        this.registers = TDigest.createAvlTreeDigest(this.compression);
    }

    public void add(double v) {
        this.registers.add(v);
    }

    public void merge(PercentileCounter counter) {
        assert (this.compression == counter.compression);
        this.registers.add(counter.registers);
    }

    public double getResultEstimate() {
        return this.registers.quantile(this.quantileRatio);
    }

    public Double getResultEstimateWithQuantileRatio(double quantileRatio) {
        if (this.registers.size() == 0L) {
            return null;
        }
        return this.registers.quantile(quantileRatio);
    }

    public void writeRegisters(ByteBuffer out) {
        this.registers.compress();
        this.registers.asSmallBytes(out);
    }

    public void readRegisters(ByteBuffer in) {
        this.registers = AVLTreeDigest.fromBytes(in);
        this.compression = this.registers.compression();
    }

    public int getBytesEstimate() {
        return this.maxLength();
    }

    public double getBytesEstimate(double count) {
        if (count <= 2.0 * this.compression) {
            return 16.0 + count * 5.0;
        }
        switch ((int)this.compression) {
            case 100: {
                return 597.9494 * Math.log1p(count) - 2358.987;
            }
            case 1000: {
                return 5784.34 * Math.log1p(count) - 35030.97;
            }
            case 10000: {
                return 54313.96 * Math.log1p(count) - 438988.8;
            }
        }
        return 0.0;
    }

    public int maxLength() {
        switch ((int)this.compression) {
            case 100: {
                return 16384;
            }
            case 1000: {
                return 131072;
            }
            case 10000: {
                return 0x100000;
            }
        }
        return 16384;
    }

    public int peekLength(ByteBuffer in) {
        int mark = in.position();
        AVLTreeDigest.fromBytes(in);
        int total = in.position() - mark;
        in.position(mark);
        return total;
    }

    public void clear() {
        this.reInitRegisters();
    }

    public double getCompression() {
        return this.compression;
    }

    public double getQuantileRatio() {
        return this.quantileRatio;
    }

    public TDigest getRegisters() {
        return this.registers;
    }
}

