/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.datatype;

import java.nio.ByteBuffer;
import org.apache.kylin.common.util.BytesUtil;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;

public class StringSerializer
extends DataTypeSerializer<String> {
    final DataType type;
    final int maxLength;

    public StringSerializer(DataType type) {
        this.type = type;
        this.maxLength = 2 + type.getPrecision();
    }

    @Override
    public void serialize(String value, ByteBuffer out) {
        int start = out.position();
        BytesUtil.writeUTFString(value, out);
        if (out.position() - start > this.maxLength) {
            throw new IllegalArgumentException("'" + value + "' exceeds the expected length for type " + this.type);
        }
    }

    @Override
    public String deserialize(ByteBuffer in) {
        return BytesUtil.readUTFString(in);
    }

    @Override
    public int peekLength(ByteBuffer in) {
        return BytesUtil.peekByteArrayLength(in);
    }

    @Override
    public int maxLength() {
        return this.maxLength;
    }

    @Override
    public int getStorageBytesEstimate() {
        return this.maxLength;
    }

    @Override
    public String valueOf(String str) {
        return str;
    }
}

