/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.tuple;

import java.math.BigDecimal;
import java.util.List;
import net.sf.ehcache.pool.sizeof.annotations.IgnoreSizeOf;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.metadata.datatype.DoubleMutable;
import org.apache.kylin.metadata.datatype.LongMutable;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.tuple.ITuple;
import org.apache.kylin.metadata.tuple.TupleInfo;

public class Tuple
implements ITuple {
    @IgnoreSizeOf
    private final TupleInfo info;
    private final Object[] values;

    public Tuple(TupleInfo info) {
        this.info = info;
        this.values = new Object[info.size()];
    }

    @Override
    public List<String> getAllFields() {
        return this.info.getAllFields();
    }

    @Override
    public List<TblColRef> getAllColumns() {
        return this.info.getAllColumns();
    }

    @Override
    public Object[] getAllValues() {
        return this.values;
    }

    public Object clone() {
        return this.makeCopy();
    }

    @Override
    public ITuple makeCopy() {
        Tuple ret = new Tuple(this.info);
        for (int i = 0; i < this.values.length; ++i) {
            ret.values[i] = this.values[i];
        }
        return ret;
    }

    public TupleInfo getInfo() {
        return this.info;
    }

    public String getFieldName(TblColRef col) {
        return this.info.getFieldName(col);
    }

    public TblColRef getFieldColumn(String fieldName) {
        return this.info.getColumn(fieldName);
    }

    public Object getValue(String fieldName) {
        int index = this.info.getFieldIndex(fieldName);
        return this.values[index];
    }

    @Override
    public Object getValue(TblColRef col) {
        int index = this.info.getColumnIndex(col);
        return this.values[index];
    }

    public String getDataTypeName(int idx) {
        return this.info.getDataTypeName(idx);
    }

    public void setDimensionValue(String fieldName, String fieldValue) {
        this.setDimensionValue(this.info.getFieldIndex(fieldName), fieldValue);
    }

    public void setDimensionValue(int idx, String fieldValue) {
        Object objectValue;
        this.values[idx] = objectValue = Tuple.convertOptiqCellValue(fieldValue, this.getDataTypeName(idx));
    }

    public void setDimensionValueDirectly(int idx, Object objectValue) {
        this.values[idx] = objectValue;
    }

    public void setMeasureValue(String fieldName, Object fieldValue) {
        this.setMeasureValue(this.info.getFieldIndex(fieldName), fieldValue);
    }

    public void setMeasureValue(int idx, Object fieldValue) {
        fieldValue = this.convertWritableToJava(fieldValue);
        String dataType = this.getDataTypeName(idx);
        if ("double".equals(dataType) && fieldValue instanceof BigDecimal) {
            fieldValue = ((BigDecimal)fieldValue).doubleValue();
        } else if ("decimal".equals(dataType)) {
            if (fieldValue instanceof BigDecimal) {
                fieldValue = Tuple.normalizeDecimal((BigDecimal)fieldValue);
            } else if (fieldValue instanceof Number) {
                fieldValue = BigDecimal.valueOf(((Number)fieldValue).doubleValue());
            }
        } else if ("float".equals(dataType) && fieldValue instanceof BigDecimal) {
            fieldValue = Float.valueOf(((BigDecimal)fieldValue).floatValue());
        } else if ("integer".equals(dataType) && fieldValue instanceof Number) {
            fieldValue = ((Number)fieldValue).intValue();
        } else if ("bigint".equals(dataType) && fieldValue instanceof Number) {
            fieldValue = ((Number)fieldValue).longValue();
        } else if ("smallint".equals(dataType) && fieldValue instanceof Number) {
            fieldValue = ((Number)fieldValue).shortValue();
        } else if ("tinyint".equals(dataType) && fieldValue instanceof Number) {
            fieldValue = ((Number)fieldValue).byteValue();
        } else if ("date".equals(dataType) && fieldValue instanceof Long) {
            long millis = (Long)fieldValue;
            fieldValue = (int)(millis / 86400000L);
        } else if (!("varchar".equals(dataType) && "char".equals(dataType) || !(fieldValue instanceof String))) {
            fieldValue = Tuple.convertOptiqCellValue((String)fieldValue, dataType);
        }
        this.values[idx] = fieldValue;
    }

    private Object convertWritableToJava(Object o) {
        if (o instanceof LongMutable) {
            o = ((LongMutable)o).get();
        } else if (o instanceof DoubleMutable) {
            o = ((DoubleMutable)o).get();
        }
        return o;
    }

    private static BigDecimal normalizeDecimal(BigDecimal input) {
        if (input.scale() < 0) {
            return input.setScale(0);
        }
        return input;
    }

    public boolean hasColumn(TblColRef column) {
        return this.info.hasColumn(column);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String field : this.info.getAllFields()) {
            sb.append(field);
            sb.append("=");
            sb.append(this.getValue(field));
            sb.append(",");
        }
        return sb.toString();
    }

    public static long getTs(ITuple row, TblColRef partitionCol) {
        if (partitionCol.getDatatype().equals("date")) {
            return Tuple.epicDaysToMillis(Integer.parseInt(row.getValue(partitionCol).toString()));
        }
        return Long.parseLong(row.getValue(partitionCol).toString());
    }

    public static long epicDaysToMillis(int days) {
        return 1L * (long)days * 86400000L;
    }

    public static int millisToEpicDays(long millis) {
        return (int)(millis / 86400000L);
    }

    public static Object convertOptiqCellValue(String strValue, String dataTypeName) {
        if (strValue == null) {
            return null;
        }
        if ((strValue.equals("") || strValue.equals("\\N")) && !dataTypeName.equals("string") && !dataTypeName.startsWith("varchar")) {
            return null;
        }
        switch (dataTypeName) {
            case "date": {
                return Tuple.millisToEpicDays(DateFormat.stringToMillis(strValue));
            }
            case "datetime": 
            case "timestamp": {
                return DateFormat.stringToMillis(strValue);
            }
            case "tinyint": {
                return Byte.valueOf(strValue);
            }
            case "smallint": {
                return Short.valueOf(strValue);
            }
            case "integer": {
                return Integer.valueOf(strValue);
            }
            case "bigint": {
                return Long.valueOf(strValue);
            }
            case "double": {
                return Double.valueOf(strValue);
            }
            case "decimal": {
                return Tuple.normalizeDecimal(new BigDecimal(strValue));
            }
            case "float": {
                return Float.valueOf(strValue);
            }
            case "boolean": {
                return Boolean.valueOf(strValue) != false || "1".equals(strValue);
            }
        }
        return strValue;
    }
}

