/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics.lib.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.kylin.metrics.lib.ActiveReservoirListener;
import org.apache.kylin.metrics.lib.Record;
import org.apache.kylin.metrics.lib.impl.AbstractActiveReservoir;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstantReservoir
extends AbstractActiveReservoir {
    private static final Logger logger = LoggerFactory.getLogger(InstantReservoir.class);

    @Override
    public void update(Record record) {
        if (!this.isReady) {
            logger.info("Current reservoir is not ready for update record");
            return;
        }
        this.onRecordUpdate(record);
    }

    @Override
    public int size() {
        return 0;
    }

    private void onRecordUpdate(Record record) {
        boolean ifSucceed = true;
        for (ActiveReservoirListener listener : this.listeners) {
            if (this.notifyListenerOfUpdatedRecord(listener, record)) continue;
            ifSucceed = false;
            logger.info("Fails to notify {} of record {}", (Object)listener, (Object)Arrays.toString(record.getKey()));
        }
        if (!ifSucceed) {
            this.notifyListenerHAOfUpdatedRecord(record);
        }
    }

    private boolean notifyListenerOfUpdatedRecord(ActiveReservoirListener listener, Record record) {
        ArrayList<Record> recordsList = Lists.newArrayList();
        recordsList.add(record);
        return listener.onRecordUpdate(recordsList);
    }

    private boolean notifyListenerHAOfUpdatedRecord(Record record) {
        logger.info("Use HA Listener {} to notify record {}", (Object)this.listenerHA, (Object)Arrays.toString(record.getKey()));
        if (!this.notifyListenerOfUpdatedRecord(this.listenerHA, record)) {
            logger.error("The HA listener also fails!!!");
            return false;
        }
        return true;
    }
}

