/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.optrule;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;

public class AggregateMultipleExpandRule
extends RelOptRule {
    public static final AggregateMultipleExpandRule INSTANCE = new AggregateMultipleExpandRule(AggregateMultipleExpandRule.operand(LogicalAggregate.class, null, (Predicate)new Predicate<Aggregate>(){

        public boolean apply(@Nullable Aggregate input) {
            return input.getGroupType() != Aggregate.Group.SIMPLE;
        }
    }, (RelOptRuleOperand)AggregateMultipleExpandRule.operand(RelNode.class, (RelOptRuleOperandChildren)AggregateMultipleExpandRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "AggregateMultipleExpandRule");

    private AggregateMultipleExpandRule(RelOptRuleOperand operand, String description) {
        super(operand, description);
    }

    private static List<ImmutableBitSet> asList(ImmutableBitSet groupSet) {
        ArrayList<ImmutableBitSet> l = new ArrayList<ImmutableBitSet>(1);
        l.add(groupSet);
        return l;
    }

    public void onMatch(RelOptRuleCall call) {
        LogicalAggregate aggr = (LogicalAggregate)call.getRelList().get(0);
        RelNode input = aggr.getInput();
        RelBuilder relBuilder = call.builder();
        RexBuilder rexBuilder = aggr.getCluster().getRexBuilder();
        for (ImmutableBitSet groupSet : aggr.getGroupSets()) {
            relBuilder.push((RelNode)aggr.copy(aggr.getTraitSet(), input, false, groupSet, AggregateMultipleExpandRule.asList(groupSet), aggr.getAggCallList()));
            ImmutableList.Builder rexNodes = new ImmutableList.Builder();
            int index = 0;
            Iterator groupSetIter = aggr.getGroupSet().iterator();
            Iterator typeIterator = aggr.getRowType().getFieldList().iterator();
            Iterator groupKeyIter = groupSet.iterator();
            int groupKey = (Integer)groupKeyIter.next();
            while (groupSetIter.hasNext()) {
                Integer aggrGroupKey = (Integer)groupSetIter.next();
                RelDataType type = ((RelDataTypeField)typeIterator.next()).getType();
                if (groupKey == aggrGroupKey) {
                    rexNodes.add((Object)rexBuilder.makeInputRef(type, index++));
                    groupKey = (Integer)groupKeyIter.next();
                    continue;
                }
                rexNodes.add((Object)rexBuilder.makeNullLiteral(type));
            }
            while (typeIterator.hasNext()) {
                RelDataType type = ((RelDataTypeField)typeIterator.next()).getType();
                rexNodes.add((Object)rexBuilder.makeInputRef(type, index++));
            }
            relBuilder.project((Iterable)rexNodes.build());
        }
        RelNode unionAggr = relBuilder.union(true, aggr.getGroupSets().size()).build();
        call.transformTo(unionAggr);
    }
}

