/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.PostConstruct;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.rest.controller.BasicController;
import org.apache.kylin.rest.exception.BadRequestException;
import org.apache.kylin.rest.exception.ForbiddenException;
import org.apache.kylin.rest.request.PasswdChangeRequest;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.security.ManagedUser;
import org.apache.kylin.rest.service.AccessService;
import org.apache.kylin.rest.service.UserGroupService;
import org.apache.kylin.rest.service.UserService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.rest.util.PagingUtil;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.CacheManager;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/user"})
public class UserController
extends BasicController {
    private static final Logger logger = LoggerFactory.getLogger(UserController.class);
    private static final SimpleGrantedAuthority ALL_USERS_AUTH = new SimpleGrantedAuthority("ALL_USERS");
    @Autowired
    @Qualifier(value="userService")
    UserService userService;
    @Autowired
    private AclEvaluate aclEvaluate;
    @Autowired
    @Qualifier(value="accessService")
    private AccessService accessService;
    @Autowired
    @Qualifier(value="userGroupService")
    private UserGroupService userGroupService;
    @Autowired
    private CacheManager cacheManager;
    private Pattern passwordPattern;
    private Pattern bcryptPattern;
    private BCryptPasswordEncoder pwdEncoder;

    @RequestMapping(value={"/authentication"}, method={RequestMethod.POST}, produces={"application/json"})
    public UserDetails authenticate() {
        UserDetails userDetails = this.authenticatedUser();
        logger.debug("User login: {}", (Object)userDetails);
        return userDetails;
    }

    @RequestMapping(value={"/authentication"}, method={RequestMethod.GET}, produces={"application/json"})
    public UserDetails authenticatedUser() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            logger.debug("authentication is null.");
            return null;
        }
        if (authentication.getPrincipal() instanceof UserDetails) {
            return (UserDetails)authentication.getPrincipal();
        }
        if (authentication.getDetails() instanceof UserDetails) {
            return (UserDetails)authentication.getDetails();
        }
        return null;
    }

    @PostConstruct
    public void init() throws IOException {
        this.passwordPattern = Pattern.compile("^(?=.*\\d)(?=.*[a-zA-Z])(?=.*[~!@#$%^&*(){}|:\"<>?\\[\\];',./`]).{8,}$");
        this.bcryptPattern = Pattern.compile("\\A\\$2a?\\$\\d\\d\\$[./0-9A-Za-z]{53}");
        this.pwdEncoder = new BCryptPasswordEncoder();
    }

    private void checkProfileEditAllowed() {
        String securityProfile = KylinConfig.getInstanceFromEnv().getSecurityProfile();
        if (!"testing".equals(securityProfile) && !"custom".equals(securityProfile)) {
            throw new BadRequestException("Action not allowed!");
        }
    }

    @RequestMapping(value={"/{userName:.+}"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ManagedUser create(@PathVariable(value="userName") String userName, @RequestBody ManagedUser user) {
        this.checkProfileEditAllowed();
        if (StringUtils.equals(this.getPrincipal(), user.getUsername()) && user.isDisabled()) {
            throw new ForbiddenException("Action not allowed!");
        }
        this.checkUserName(userName);
        user.setUsername(userName);
        user.setPassword(this.pwdEncode(user.getPassword()));
        logger.info("Creating {}", (Object)user);
        this.completeAuthorities(user);
        this.userService.createUser(user);
        return this.get(userName);
    }

    @RequestMapping(value={"/{userName:.+}"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    @PreAuthorize(value="hasRole('ROLE_ADMIN')")
    public ManagedUser save(@PathVariable(value="userName") String userName, @RequestBody ManagedUser user) {
        this.checkProfileEditAllowed();
        if (StringUtils.equals(this.getPrincipal(), user.getUsername()) && user.isDisabled()) {
            throw new ForbiddenException("Action not allowed!");
        }
        this.checkUserName(userName);
        user.setUsername(userName);
        try {
            ManagedUser existing = this.get(userName);
            if (existing != null) {
                if (user.getPassword() == null) {
                    user.setPassword(existing.getPassword());
                }
                if (user.getAuthorities() == null || user.getAuthorities().isEmpty()) {
                    user.setGrantedAuthorities(existing.getAuthorities());
                }
            }
        }
        catch (UsernameNotFoundException usernameNotFoundException) {
            // empty catch block
        }
        logger.info("Saving {}", (Object)user);
        user.setPassword(this.pwdEncode(user.getPassword()));
        this.completeAuthorities(user);
        this.userService.updateUser(user);
        this.cacheManager.getCache("UserCache").clear();
        return this.get(userName);
    }

    @RequestMapping(value={"/password"}, method={RequestMethod.PUT}, produces={"application/json"})
    @ResponseBody
    public EnvelopeResponse save(@RequestBody PasswdChangeRequest user) {
        this.checkProfileEditAllowed();
        if (!this.isAdmin() && !StringUtils.equals(this.getPrincipal(), user.getUsername())) {
            throw new ForbiddenException("Permission Denied");
        }
        ManagedUser existing = this.get(user.getUsername());
        this.checkUserName(user.getUsername());
        this.checkNewPwdRule(user.getNewPassword());
        if (existing != null) {
            if (!this.isAdmin() && !this.pwdEncoder.matches((CharSequence)user.getPassword(), existing.getPassword())) {
                throw new BadRequestException("pwd update error");
            }
            existing.setPassword(this.pwdEncode(user.getNewPassword()));
            existing.setDefaultPassword(false);
            logger.info("update password for user {}", (Object)user);
            this.completeAuthorities(existing);
            this.userService.updateUser(existing);
            if (StringUtils.equals(this.getPrincipal(), user.getUsername())) {
                UsernamePasswordAuthenticationToken token = new UsernamePasswordAuthenticationToken(existing, user.getNewPassword(), existing.getAuthorities());
                token.setDetails(SecurityContextHolder.getContext().getAuthentication().getDetails());
                SecurityContextHolder.getContext().setAuthentication(token);
            }
        }
        return new EnvelopeResponse<ManagedUser>("000", this.get(user.getUsername()), "");
    }

    private String pwdEncode(String pwd) {
        if (this.bcryptPattern.matcher(pwd).matches()) {
            return pwd;
        }
        return this.pwdEncoder.encode((CharSequence)pwd);
    }

    private void checkUserName(String userName) {
        if (userName == null || userName.isEmpty()) {
            throw new BadRequestException("empty user name");
        }
    }

    private void checkNewPwdRule(String newPwd) {
        if (!this.checkPasswordLength(newPwd)) {
            throw new BadRequestException("password length need more then 8 chars");
        }
        if (!this.checkPasswordCharacter(newPwd)) {
            throw new BadRequestException("pwd update error");
        }
    }

    private boolean checkPasswordLength(String password) {
        return password != null && password.length() >= 8;
    }

    private boolean checkPasswordCharacter(String password) {
        return this.passwordPattern.matcher(password).matches();
    }

    @RequestMapping(value={"/{userName:.+}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public EnvelopeResponse getUser(@PathVariable(value="userName") String userName) {
        if (!this.isAdmin() && !StringUtils.equals(this.getPrincipal(), userName)) {
            throw new ForbiddenException("...");
        }
        return new EnvelopeResponse<ManagedUser>("000", this.get(userName), "");
    }

    private ManagedUser get(@Nullable String userName) {
        this.checkUserName(userName);
        UserDetails details = this.userService.loadUserByUsername(userName);
        if (details == null) {
            return null;
        }
        return (ManagedUser)details;
    }

    @RequestMapping(value={"/users"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public EnvelopeResponse listAllUsers(@RequestParam(value="project", required=false) String project, @RequestParam(value="name", required=false) String name, @RequestParam(value="groupName", required=false) String groupName, @RequestParam(value="isFuzzMatch", required=false) boolean isFuzzMatch, @RequestParam(value="offset", required=false, defaultValue="0") Integer offset, @RequestParam(value="limit", required=false, defaultValue="10") Integer limit) throws IOException {
        if (project == null) {
            this.aclEvaluate.checkIsGlobalAdmin();
        } else {
            this.aclEvaluate.checkProjectAdminPermission(project);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        List<ManagedUser> usersByFuzzMatching = this.userService.listUsers(name, groupName, isFuzzMatch);
        List<ManagedUser> subList = PagingUtil.cutPage(usersByFuzzMatching, offset, limit);
        for (ManagedUser u : subList) {
            this.userService.completeUserInfo(u);
        }
        data.put("users", subList);
        data.put("size", usersByFuzzMatching.size());
        return new EnvelopeResponse("000", data, "");
    }

    @RequestMapping(value={"/{userName:.+}"}, method={RequestMethod.DELETE}, produces={"application/json"})
    @ResponseBody
    public EnvelopeResponse delete(@PathVariable(value="userName") String userName) throws IOException {
        this.checkProfileEditAllowed();
        if (StringUtils.equals(this.getPrincipal(), userName)) {
            throw new ForbiddenException("...");
        }
        this.accessService.revokeProjectPermission(userName, "user");
        this.checkUserName(userName);
        this.userService.deleteUser(userName);
        this.cacheManager.getCache("UserCache").clear();
        return new EnvelopeResponse<String>("000", userName, "");
    }

    private void completeAuthorities(ManagedUser managedUser) {
        ArrayList<SimpleGrantedAuthority> detailRoles = Lists.newArrayList(managedUser.getAuthorities());
        for (SimpleGrantedAuthority authority : detailRoles) {
            try {
                if (this.userGroupService.exists(authority.getAuthority())) continue;
                throw new BadRequestException(String.format(Locale.ROOT, "user's authority:%s is not found in user group", authority.getAuthority()));
            }
            catch (IOException e) {
                logger.error("Get user group error: {}", (Object)e.getMessage());
            }
        }
        if (!detailRoles.contains(ALL_USERS_AUTH)) {
            detailRoles.add(ALL_USERS_AUTH);
        }
        managedUser.setGrantedAuthorities(detailRoles);
    }

    private String getPrincipal() {
        String userName = null;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return null;
        }
        Object principal = authentication.getPrincipal();
        userName = principal instanceof UserDetails ? ((UserDetails)principal).getUsername() : (authentication.getDetails() instanceof UserDetails ? ((UserDetails)authentication.getDetails()).getUsername() : principal.toString());
        return userName;
    }
}

