/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.List;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.project.RealizationEntry;
import org.apache.kylin.metadata.realization.RealizationType;
import org.apache.kylin.rest.job.HybridCubeCLI;
import org.apache.kylin.rest.service.BasicService;
import org.apache.kylin.rest.util.AclEvaluate;
import org.apache.kylin.storage.hybrid.HybridInstance;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="hybridService")
public class HybridService
extends BasicService {
    private static final Logger logger = LoggerFactory.getLogger(HybridService.class);
    @Autowired
    private AclEvaluate aclEvaluate;

    public HybridInstance createHybridInstance(String hybridName, String projectName, String modelName, String[] cubeNames) {
        this.aclEvaluate.checkProjectWritePermission(projectName);
        ArrayList<String> args = new ArrayList<String>();
        args.add("-name");
        args.add(hybridName);
        args.add("-project");
        args.add(projectName);
        args.add("-model");
        args.add(modelName);
        args.add("-cubes");
        args.add(StringUtils.join((Object[])cubeNames, ","));
        args.add("-action");
        args.add("create");
        try {
            HybridCubeCLI.main(args.toArray(new String[args.size()]));
        }
        catch (Exception e) {
            logger.warn("Create Hybrid Failed", e);
            throw e;
        }
        return this.getHybridInstance(hybridName);
    }

    public HybridInstance updateHybridInstance(String hybridName, String projectName, String modelName, String[] cubeNames) {
        this.aclEvaluate.checkProjectWritePermission(projectName);
        ArrayList<String> args = new ArrayList<String>();
        args.add("-name");
        args.add(hybridName);
        args.add("-project");
        args.add(projectName);
        args.add("-model");
        args.add(modelName);
        args.add("-cubes");
        args.add(StringUtils.join((Object[])cubeNames, ","));
        args.add("-action");
        args.add("update");
        try {
            HybridCubeCLI.main(args.toArray(new String[args.size()]));
        }
        catch (Exception e) {
            logger.warn("Update Hybrid Failed", e);
            throw e;
        }
        return this.getHybridInstance(hybridName);
    }

    public void updateHybridCubeNoCheck(String hybridName, String projectName, String modelName, String[] cubeNames) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-name");
        args.add(hybridName);
        args.add("-project");
        args.add(projectName);
        args.add("-model");
        args.add(modelName);
        args.add("-cubes");
        args.add(StringUtils.join((Object[])cubeNames, ","));
        args.add("-check");
        args.add("false");
        args.add("-action");
        args.add("update");
        try {
            HybridCubeCLI.main(args.toArray(new String[args.size()]));
        }
        catch (Exception e) {
            logger.warn("Update Hybrid Failed", e);
            throw e;
        }
    }

    public void deleteHybridInstance(String hybridName, String projectName) {
        this.aclEvaluate.checkProjectWritePermission(projectName);
        ArrayList<String> args = new ArrayList<String>();
        args.add("-name");
        args.add(hybridName);
        args.add("-action");
        args.add("delete");
        try {
            HybridCubeCLI.main(args.toArray(new String[args.size()]));
        }
        catch (Exception e) {
            logger.warn("Delete Hybrid Failed", e);
            throw e;
        }
    }

    public HybridInstance getHybridInstance(String hybridName) {
        HybridInstance hybridInstance = this.getHybridManager().getHybridInstance(hybridName);
        return hybridInstance;
    }

    public List<HybridInstance> listHybrids(String projectName, String modelName) {
        ArrayList<HybridInstance> allHybrids = new ArrayList<HybridInstance>();
        if (StringUtils.isEmpty(projectName)) {
            List<ProjectInstance> allProjectInstances = this.getProjectManager().listAllProjects();
            ArrayList<ProjectInstance> readableProjects = new ArrayList<ProjectInstance>();
            for (ProjectInstance projectInstance : allProjectInstances) {
                boolean hasProjectReadAccess;
                if (projectInstance == null || !(hasProjectReadAccess = this.aclEvaluate.hasProjectReadPermission(projectInstance))) continue;
                readableProjects.add(projectInstance);
            }
            for (ProjectInstance projectInstance : readableProjects) {
                List<RealizationEntry> realizationEntries = projectInstance.getRealizationEntries(RealizationType.HYBRID);
                if (realizationEntries == null) continue;
                for (RealizationEntry entry : realizationEntries) {
                    HybridInstance instance = this.getHybridManager().getHybridInstance(entry.getRealization());
                    allHybrids.add(instance);
                }
            }
        } else {
            this.aclEvaluate.checkProjectReadPermission(projectName);
            ProjectInstance projectInstance = this.getProjectManager().getProject(projectName);
            List<RealizationEntry> realizationEntries = projectInstance.getRealizationEntries(RealizationType.HYBRID);
            if (realizationEntries != null) {
                for (RealizationEntry entry : realizationEntries) {
                    HybridInstance instance = this.getHybridManager().getHybridInstance(entry.getRealization());
                    allHybrids.add(instance);
                }
            }
        }
        if (StringUtils.isEmpty(modelName)) {
            return allHybrids;
        }
        DataModelDesc model = this.getDataModelManager().getDataModelDesc(modelName);
        ArrayList<HybridInstance> hybridsInModel = new ArrayList<HybridInstance>();
        if (model == null) {
            return hybridsInModel;
        }
        for (HybridInstance hybridInstance : allHybrids) {
            boolean hybridInModel = false;
            for (RealizationEntry entry : hybridInstance.getRealizationEntries()) {
                CubeDesc cubeDesc = this.getCubeDescManager().getCubeDesc(entry.getRealization());
                if (cubeDesc == null || !model.getName().equalsIgnoreCase(cubeDesc.getModel().getName())) continue;
                hybridInModel = true;
                break;
            }
            if (!hybridInModel) continue;
            hybridsInModel.add(hybridInstance);
        }
        return hybridsInModel;
    }
}

