/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.gtrecord;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.kylin.cube.cuboid.Cuboid;
import org.apache.kylin.gridtable.EmptyGTScanner;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.gridtable.GTScanRequest;
import org.apache.kylin.gridtable.IGTScanner;
import org.apache.kylin.gridtable.IGTStorage;
import org.apache.kylin.metadata.model.ISegment;
import org.apache.kylin.storage.StorageContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScannerWorker {
    private static final Logger logger = LoggerFactory.getLogger(ScannerWorker.class);
    private final IGTScanner internal;
    private final Object[] inputArgs;

    public ScannerWorker(ISegment segment, Cuboid cuboid, GTScanRequest scanRequest, String gtStorage, StorageContext context) {
        this.inputArgs = new Object[]{segment, cuboid, scanRequest, gtStorage, context};
        if (scanRequest == null) {
            logger.info("Segment {} will be skipped", (Object)segment);
            this.internal = new EmptyGTScanner();
            return;
        }
        GTInfo info = scanRequest.getInfo();
        try {
            IGTStorage rpc = (IGTStorage)Class.forName(gtStorage).getConstructor(ISegment.class, Cuboid.class, GTInfo.class, StorageContext.class).newInstance(segment, cuboid, info, context);
            this.internal = rpc.getGTScanner(scanRequest);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.checkNPE();
    }

    public boolean isSegmentSkipped() {
        return this.internal instanceof EmptyGTScanner;
    }

    public Iterator<GTRecord> iterator() {
        this.checkNPE();
        return this.internal.iterator();
    }

    private void checkNPE() {
        if (this.internal == null) {
            logger.error("Caught an impossible NPE, args are " + Arrays.toString(this.inputArgs), new Exception());
        }
    }

    public void close() throws IOException {
        this.internal.close();
    }
}

