/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.storage.gtrecord;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import org.apache.kylin.gridtable.GTInfo;
import org.apache.kylin.gridtable.GTRecord;
import org.apache.kylin.shaded.com.google.common.collect.Iterators;
import org.apache.kylin.shaded.com.google.common.collect.PeekingIterator;
import org.apache.kylin.shaded.com.google.common.collect.UnmodifiableIterator;
import org.apache.kylin.storage.gtrecord.PartitionResultIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortMergedPartitionResultIterator
extends UnmodifiableIterator<GTRecord> {
    private static final Logger logger = LoggerFactory.getLogger(SortMergedPartitionResultIterator.class);
    private final Iterator<PartitionResultIterator> iterators;
    private final Comparator<GTRecord> comparator;
    private final GTRecord record;
    private boolean initted = false;
    private PriorityQueue<PeekingIterator<GTRecord>> heap;

    SortMergedPartitionResultIterator(Iterator<PartitionResultIterator> iterators, GTInfo info, Comparator<GTRecord> comparator) {
        this.iterators = iterators;
        this.record = new GTRecord(info);
        this.comparator = comparator;
    }

    @Override
    public boolean hasNext() {
        if (!this.initted) {
            Comparator<PeekingIterator<GTRecord>> heapComparator = new Comparator<PeekingIterator<GTRecord>>(){

                @Override
                public int compare(PeekingIterator<GTRecord> o1, PeekingIterator<GTRecord> o2) {
                    return SortMergedPartitionResultIterator.this.comparator.compare(o1.peek(), o2.peek());
                }
            };
            this.heap = new PriorityQueue<PeekingIterator<GTRecord>>(3, heapComparator);
            int total = 0;
            int actual = 0;
            while (this.iterators.hasNext()) {
                ++total;
                PartitionResultIterator it = this.iterators.next();
                if (!it.hasNext()) continue;
                ++actual;
                this.heap.offer(Iterators.peekingIterator(it));
            }
            logger.debug("Using SortMergedPartitionResultIterator to merge {} partition results out of {} partitions", (Object)actual, (Object)total);
            this.initted = true;
        }
        return !this.heap.isEmpty();
    }

    @Override
    public GTRecord next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        PeekingIterator<GTRecord> it = this.heap.poll();
        this.record.shallowCopyFrom(it.next());
        if (it.hasNext()) {
            this.heap.offer(it);
        }
        return this.record;
    }
}

