/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.extractor;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.util.RMHAUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.apache.kylin.tool.shaded.org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HadoopConfExtractor {
    private static final Logger logger = LoggerFactory.getLogger(HadoopConfExtractor.class);
    public static final String MR_JOB_HISTORY_URL_CONF_KEY = "mapreduce.jobhistory.webapp.address";

    public static String extractYarnMasterUrl(Configuration conf) {
        String rmWebHost;
        String defaultAddr;
        String webappConfKey;
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String yarnStatusCheckUrl = config.getYarnStatusCheckUrl();
        Pattern pattern = Pattern.compile("(http[s]*://)([^:]*):([^/])*.*");
        if (yarnStatusCheckUrl != null) {
            logger.info("Choose user-defined configuration for RM url {}. ", (Object)yarnStatusCheckUrl);
            Matcher m = pattern.matcher(yarnStatusCheckUrl);
            if (m.matches()) {
                return m.group(1) + m.group(2) + ":" + m.group(3);
            }
        } else {
            logger.info("kylin.engine.mr.yarn-check-status-url is not set, read from hadoop configuration");
        }
        if (YarnConfiguration.useHttps((Configuration)conf)) {
            webappConfKey = "yarn.resourcemanager.webapp.https.address";
            defaultAddr = "0.0.0.0:8090";
        } else {
            webappConfKey = "yarn.resourcemanager.webapp.address";
            defaultAddr = "0.0.0.0:8088";
        }
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            YarnConfiguration yarnConf = new YarnConfiguration(conf);
            String active = RMHAUtils.findActiveRMHAId((YarnConfiguration)yarnConf);
            rmWebHost = HAUtil.getConfValueForRMInstance((String)HAUtil.addSuffix((String)webappConfKey, (String)active), (String)defaultAddr, (Configuration)yarnConf);
        } else {
            rmWebHost = HAUtil.getConfValueForRMInstance((String)webappConfKey, (String)defaultAddr, (Configuration)conf);
        }
        if (StringUtils.isEmpty(rmWebHost)) {
            return null;
        }
        if (!rmWebHost.startsWith("http://") && !rmWebHost.startsWith("https://")) {
            rmWebHost = (YarnConfiguration.useHttps((Configuration)conf) ? "https://" : "http://") + rmWebHost;
        }
        Matcher m = pattern.matcher(rmWebHost);
        Preconditions.checkArgument(m.matches(), "Yarn master URL not found.");
        logger.info("yarn master url: {}", (Object)rmWebHost);
        return rmWebHost;
    }

    public static String extractJobHistoryUrl(String yarnWebapp, Configuration conf) {
        Pattern pattern = Pattern.compile("(http[s]*://)([^:]*):([^/])*.*");
        Matcher m = pattern.matcher(yarnWebapp);
        Preconditions.checkArgument(m.matches(), "Yarn master URL" + yarnWebapp + " not right.");
        String defaultHistoryUrl = m.group(2) + ":19888";
        return m.group(1) + HAUtil.getConfValueForRMInstance((String)MR_JOB_HISTORY_URL_CONF_KEY, (String)defaultHistoryUrl, (Configuration)conf);
    }
}

