/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.metrics.systemcube;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metrics.lib.ActiveReservoirReporter;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.tool.metrics.systemcube.HiveTableCreator;
import org.apache.kylin.tool.metrics.systemcube.def.MetricsSinkDesc;

public class KylinTableCreator {
    public static void main(String[] args) throws Exception {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        TableDesc kylinTable = KylinTableCreator.generateKylinTableForMetricsQueryExecution(config, new MetricsSinkDesc());
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(buf);
        TableMetadataManager.TABLE_SERIALIZER.serialize(kylinTable, dout);
        dout.close();
        buf.close();
        System.out.println(buf.toString("UTF-8"));
    }

    public static TableDesc generateKylinTableForMetricsQueryExecution(KylinConfig kylinConfig, MetricsSinkDesc sinkDesc) {
        LinkedList<Pair<String, String>> columns = Lists.newLinkedList();
        columns.addAll(HiveTableCreator.getHiveColumnsForMetricsQueryExecution());
        columns.addAll(HiveTableCreator.getPartitionKVsForHiveTable());
        return KylinTableCreator.generateKylinTable(kylinConfig, sinkDesc, kylinConfig.getKylinMetricsSubjectQueryExecution(), columns);
    }

    public static TableDesc generateKylinTableForMetricsQuerySparkJob(KylinConfig kylinConfig, MetricsSinkDesc sinkDesc) {
        LinkedList<Pair<String, String>> columns = Lists.newLinkedList();
        columns.addAll(HiveTableCreator.getHiveColumnsForMetricsQuerySparkJob());
        columns.addAll(HiveTableCreator.getPartitionKVsForHiveTable());
        return KylinTableCreator.generateKylinTable(kylinConfig, sinkDesc, kylinConfig.getKylinMetricsSubjectQuerySparkJob(), columns);
    }

    public static TableDesc generateKylinTableForMetricsQuerySparkStage(KylinConfig kylinConfig, MetricsSinkDesc sinkDesc) {
        LinkedList<Pair<String, String>> columns = Lists.newLinkedList();
        columns.addAll(HiveTableCreator.getHiveColumnsForMetricsQuerySparkStage());
        columns.addAll(HiveTableCreator.getPartitionKVsForHiveTable());
        return KylinTableCreator.generateKylinTable(kylinConfig, sinkDesc, kylinConfig.getKylinMetricsSubjectQuerySparkStage(), columns);
    }

    public static TableDesc generateKylinTableForMetricsJob(KylinConfig kylinConfig, MetricsSinkDesc sinkDesc) {
        LinkedList<Pair<String, String>> columns = Lists.newLinkedList();
        columns.addAll(HiveTableCreator.getHiveColumnsForMetricsJob());
        columns.addAll(HiveTableCreator.getPartitionKVsForHiveTable());
        return KylinTableCreator.generateKylinTable(kylinConfig, sinkDesc, kylinConfig.getKylinMetricsSubjectJob(), columns);
    }

    public static TableDesc generateKylinTableForMetricsJobException(KylinConfig kylinConfig, MetricsSinkDesc sinkDesc) {
        LinkedList<Pair<String, String>> columns = Lists.newLinkedList();
        columns.addAll(HiveTableCreator.getHiveColumnsForMetricsJobException());
        columns.addAll(HiveTableCreator.getPartitionKVsForHiveTable());
        return KylinTableCreator.generateKylinTable(kylinConfig, sinkDesc, kylinConfig.getKylinMetricsSubjectJobException(), columns);
    }

    public static TableDesc generateKylinTable(KylinConfig kylinConfig, MetricsSinkDesc sinkDesc, String subject, List<Pair<String, String>> columns) {
        TableDesc kylinTable = new TableDesc();
        Pair<String, String> tableNameSplits = ActiveReservoirReporter.getTableNameSplits(sinkDesc.getTableNameForMetrics(subject));
        kylinTable.setUuid(RandomUtil.randomUUID().toString());
        kylinTable.setDatabase(tableNameSplits.getFirst());
        kylinTable.setName(tableNameSplits.getSecond());
        kylinTable.setTableType(null);
        kylinTable.setLastModified(0L);
        kylinTable.setSourceType(sinkDesc.getSourceType());
        ColumnDesc[] columnDescs = new ColumnDesc[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            columnDescs[i] = new ColumnDesc();
            Pair<String, String> entry = columns.get(i);
            columnDescs[i].setId(Integer.toString(i + 1));
            columnDescs[i].setName(entry.getFirst());
            columnDescs[i].setDatatype(entry.getSecond());
        }
        kylinTable.setColumns(columnDescs);
        kylinTable.init(kylinConfig, "KYLIN_SYSTEM");
        return kylinTable;
    }
}

