/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.tool.metrics.systemcube;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.util.AbstractApplication;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.OptionsHelper;
import org.apache.kylin.cube.CubeDescManager;
import org.apache.kylin.cube.CubeInstance;
import org.apache.kylin.cube.CubeManager;
import org.apache.kylin.cube.model.CubeDesc;
import org.apache.kylin.metadata.TableMetadataManager;
import org.apache.kylin.metadata.model.DataModelDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.shaded.com.google.common.base.Strings;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.kylin.tool.metrics.systemcube.CubeDescCreator;
import org.apache.kylin.tool.metrics.systemcube.CubeInstanceCreator;
import org.apache.kylin.tool.metrics.systemcube.HiveTableCreator;
import org.apache.kylin.tool.metrics.systemcube.KylinTableCreator;
import org.apache.kylin.tool.metrics.systemcube.ModelCreator;
import org.apache.kylin.tool.metrics.systemcube.ProjectCreator;
import org.apache.kylin.tool.metrics.systemcube.def.MetricsSinkDesc;
import org.apache.kylin.tool.metrics.systemcube.streamingv2.KafkaTopicCreator;
import org.apache.kylin.tool.shaded.com.fasterxml.jackson.core.type.TypeReference;
import org.apache.kylin.tool.shaded.org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCCreator
extends AbstractApplication {
    private static final Logger logger = LoggerFactory.getLogger(SCCreator.class);
    private static final Option OPTION_OWNER;
    private static final Option OPTION_INPUT_CONFIG;
    private static final Option OPTION_OUTPUT;
    private static final String D_CUBE_INSTANCE = "cube/";
    private static final String D_CUBE_DESC = "cube_desc/";
    private static final String D_PROJECT = "project/";
    private static final String D_TABLE = "table/";
    private static final String D_MODEL_DESC = "model_desc/";
    private static final String D_STREAMING_V2 = "streaming_v2/";
    private static final String F_HIVE_SQL = "create_hive_tables_for_system_cubes";
    private static final String F_KAFKA_TOPIC = "create_kafka_topic_for_system_cubes";
    protected final Options options;
    private final KylinConfig config = KylinConfig.getInstanceFromEnv();

    public SCCreator() {
        this.options = new Options();
        this.options.addOption(OPTION_OWNER);
        this.options.addOption(OPTION_OUTPUT);
        this.options.addOption(OPTION_INPUT_CONFIG);
    }

    public static void main(String[] args) {
        SCCreator cli = new SCCreator();
        cli.execute(args);
    }

    @Override
    protected Options getOptions() {
        return this.options;
    }

    @Override
    protected void execute(OptionsHelper optionsHelper) throws Exception {
        String owner = optionsHelper.getOptionValue(OPTION_OWNER);
        String output = optionsHelper.getOptionValue(OPTION_OUTPUT);
        String inputConfig = optionsHelper.getOptionValue(OPTION_INPUT_CONFIG);
        if (Strings.isNullOrEmpty(inputConfig)) {
            throw new FileNotFoundException("Input configuration file should be specified!!!");
        }
        this.execute(owner, output, inputConfig);
    }

    public void execute(String owner, String output, String inputConfig) throws Exception {
        if (Strings.isNullOrEmpty(owner)) {
            owner = "ADMIN";
        }
        if (!output.endsWith("/")) {
            output = output + "/";
        }
        TypeReference<List<MetricsSinkDesc>> typeRef = new TypeReference<List<MetricsSinkDesc>>(){};
        List<MetricsSinkDesc> metricsSinkDescList = JsonUtil.readValue(FileUtils.readFileToString(new File(inputConfig)), typeRef);
        this.run(owner, output, metricsSinkDescList);
    }

    private void run(String owner, String output, List<MetricsSinkDesc> sinkToolSet) throws IOException {
        ArrayList<TableDesc> kylinTables = Lists.newArrayList();
        ArrayList<DataModelDesc> kylinModels = Lists.newArrayList();
        ArrayList<CubeDesc> cubeDescList = Lists.newArrayList();
        ArrayList<CubeInstance> kylinCubeInstances = Lists.newArrayList();
        boolean hasHive = false;
        boolean hasKafka = false;
        for (MetricsSinkDesc sinkDesc : sinkToolSet) {
            if (sinkDesc.useHive()) {
                hasHive = true;
            } else if (sinkDesc.useKafka()) {
                hasKafka = true;
            }
            kylinTables.addAll(this.generateKylinTableForSystemCube(sinkDesc));
            kylinModels.addAll(this.generateKylinModelForSystemCube(owner, sinkDesc));
            cubeDescList.addAll(this.generateKylinCubeDescForSystemCube(sinkDesc));
            kylinCubeInstances.addAll(this.generateKylinCubeInstanceForSystemCube(owner, sinkDesc));
            if (!sinkDesc.useKafka()) continue;
        }
        if (hasHive) {
            this.generateHiveTableSQLFileForSystemCube(output);
        }
        if (hasKafka) {
            this.generateKafkaTopicFileForSystemCube(output);
        }
        ProjectInstance projectInstance = ProjectCreator.generateKylinProjectInstance(owner, kylinTables, kylinModels, cubeDescList);
        this.generateKylinProjectFileForSystemCube(output, projectInstance);
        for (TableDesc tableDesc : kylinTables) {
            this.generateKylinTableFileForSystemCube(output, tableDesc);
        }
        for (DataModelDesc dataModelDesc : kylinModels) {
            this.generateKylinModelFileForSystemCube(output, dataModelDesc);
        }
        for (CubeDesc cubeDesc : cubeDescList) {
            this.generateKylinCubeDescFileForSystemCube(output, cubeDesc);
        }
        for (CubeInstance cubeInstance : kylinCubeInstances) {
            this.generateKylinCubeInstanceFileForSystemCube(output, cubeInstance);
        }
    }

    private List<TableDesc> generateKylinTableForSystemCube(MetricsSinkDesc sinkDesc) {
        LinkedList<TableDesc> result = Lists.newLinkedList();
        result.add(KylinTableCreator.generateKylinTableForMetricsQueryExecution(this.config, sinkDesc));
        result.add(KylinTableCreator.generateKylinTableForMetricsQuerySparkJob(this.config, sinkDesc));
        result.add(KylinTableCreator.generateKylinTableForMetricsQuerySparkStage(this.config, sinkDesc));
        result.add(KylinTableCreator.generateKylinTableForMetricsJob(this.config, sinkDesc));
        result.add(KylinTableCreator.generateKylinTableForMetricsJobException(this.config, sinkDesc));
        return result;
    }

    private List<DataModelDesc> generateKylinModelForSystemCube(String owner, MetricsSinkDesc sinkDesc) {
        LinkedList<DataModelDesc> result = Lists.newLinkedList();
        result.add(ModelCreator.generateKylinModelForMetricsQuery(owner, this.config, sinkDesc));
        result.add(ModelCreator.generateKylinModelForMetricsQueryCube(owner, this.config, sinkDesc));
        result.add(ModelCreator.generateKylinModelForMetricsQueryRPC(owner, this.config, sinkDesc));
        result.add(ModelCreator.generateKylinModelForMetricsJob(owner, this.config, sinkDesc));
        result.add(ModelCreator.generateKylinModelForMetricsJobException(owner, this.config, sinkDesc));
        return result;
    }

    private List<CubeDesc> generateKylinCubeDescForSystemCube(MetricsSinkDesc sinkDesc) {
        LinkedList<CubeDesc> result = Lists.newLinkedList();
        result.add(CubeDescCreator.generateKylinCubeDescForMetricsQueryExecution(this.config, sinkDesc));
        result.add(CubeDescCreator.generateKylinCubeDescForMetricsQuerySparkJob(this.config, sinkDesc));
        result.add(CubeDescCreator.generateKylinCubeDescForMetricsQuerySparkStage(this.config, sinkDesc));
        result.add(CubeDescCreator.generateKylinCubeDescForMetricsJob(this.config, sinkDesc));
        result.add(CubeDescCreator.generateKylinCubeDescForMetricsJobException(this.config, sinkDesc));
        return result;
    }

    private List<CubeInstance> generateKylinCubeInstanceForSystemCube(String owner, MetricsSinkDesc sinkDesc) {
        LinkedList<CubeInstance> result = Lists.newLinkedList();
        result.add(CubeInstanceCreator.generateKylinCubeInstanceForMetricsQueryExecution(owner, this.config, sinkDesc));
        result.add(CubeInstanceCreator.generateKylinCubeInstanceForMetricsQuerySparkJob(owner, this.config, sinkDesc));
        result.add(CubeInstanceCreator.generateKylinCubeInstanceForMetricsQuerySparkStage(owner, this.config, sinkDesc));
        result.add(CubeInstanceCreator.generateKylinCubeInstanceForMetricsJob(owner, this.config, sinkDesc));
        result.add(CubeInstanceCreator.generateKylinCubeInstanceForMetricsJobException(owner, this.config, sinkDesc));
        return result;
    }

    private void generateHiveTableSQLFileForSystemCube(String output) throws IOException {
        String contents = HiveTableCreator.generateAllSQL(this.config);
        this.saveToFile(output + F_HIVE_SQL + ".sql", contents);
    }

    private void generateKafkaTopicFileForSystemCube(String output) throws IOException {
        String contents = KafkaTopicCreator.generateCreateCommand(this.config);
        this.saveToFile(output + F_KAFKA_TOPIC + ".sh", contents);
    }

    private void generateKylinTableFileForSystemCube(String output, TableDesc kylinTable) throws IOException {
        this.saveSystemCubeMetadataToFile(output + D_TABLE + kylinTable.getIdentity() + ".json", kylinTable, TableMetadataManager.TABLE_SERIALIZER);
    }

    private void generateKylinModelFileForSystemCube(String output, DataModelDesc modelDesc) throws IOException {
        this.saveSystemCubeMetadataToFile(output + D_MODEL_DESC + modelDesc.getName() + ".json", modelDesc, ModelCreator.MODELDESC_SERIALIZER);
    }

    private void generateKylinCubeInstanceFileForSystemCube(String output, CubeInstance cubeInstance) throws IOException {
        this.saveSystemCubeMetadataToFile(output + D_CUBE_INSTANCE + cubeInstance.getName() + ".json", cubeInstance, CubeManager.CUBE_SERIALIZER);
    }

    private void generateKylinCubeDescFileForSystemCube(String output, CubeDesc cubeDesc) throws IOException {
        this.saveSystemCubeMetadataToFile(output + D_CUBE_DESC + cubeDesc.getName() + ".json", cubeDesc, CubeDescManager.CUBE_DESC_SERIALIZER);
    }

    private void generateKylinProjectFileForSystemCube(String output, ProjectInstance projectInstance) throws IOException {
        this.saveSystemCubeMetadataToFile(output + D_PROJECT + projectInstance.getName() + ".json", projectInstance, CubeDescManager.CUBE_DESC_SERIALIZER);
    }

    private <T extends RootPersistentEntity> void saveSystemCubeMetadataToFile(String fileName, T metadata, Serializer serializer) throws IOException {
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        DataOutputStream dout = new DataOutputStream(buf);
        serializer.serialize(metadata, dout);
        dout.close();
        buf.close();
        this.saveToFile(fileName, buf.toString("UTF-8"));
    }

    private void saveToFile(String fileName, String contents) throws IOException {
        File parentDir = new File(fileName).getParentFile();
        if (!parentDir.exists()) {
            parentDir.mkdirs();
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fileName), StandardCharsets.UTF_8));){
            bufferedWriter.append(contents);
        }
    }

    static {
        OptionBuilder.withArgName((String)"owner");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify the owner who creates the metadata");
        OPTION_OWNER = OptionBuilder.create((String)"owner");
        OptionBuilder.withArgName((String)"inputConfig");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)false);
        OptionBuilder.withDescription((String)"Specify the input configuration file");
        OPTION_INPUT_CONFIG = OptionBuilder.create((String)"inputConfig");
        OptionBuilder.withArgName((String)"output");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired((boolean)true);
        OptionBuilder.withDescription((String)"Specify the output where the generated metadata will be saved");
        OPTION_OUTPUT = OptionBuilder.create((String)"output");
    }
}

