/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.memory;

import java.io.Serializable;
import java.lang.management.BufferPoolMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import org.apache.kylin.shaded.com.google.common.collect.Lists;
import org.apache.spark.internal.Logging;
import org.apache.spark.memory.BufferPoolGetter;
import org.apache.spark.memory.GcInfoGetter;
import org.apache.spark.memory.MemoryGetter;
import org.apache.spark.memory.MemoryMonitor$;
import org.apache.spark.memory.MemoryMxBeanGetter;
import org.apache.spark.memory.MemorySnapshot;
import org.apache.spark.memory.MetricsThreadInfo;
import org.apache.spark.memory.MetricsThreadInfo$;
import org.apache.spark.memory.PoolGetter;
import org.apache.spark.memory.SparkMemoryManagerHandle;
import org.apache.spark.memory.SparkMemoryManagerHandle$;
import org.apache.spark.memory.SystemInfoGetter;
import org.apache.spark.memory.ThreadInfoSnapshot;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005g\u0001\u0002\u0014(\u0001ABQ!\u0010\u0001\u0005\u0002yBq!\u0011\u0001C\u0002\u0013\u0005!\t\u0003\u0004J\u0001\u0001\u0006Ia\u0011\u0005\b\u0015\u0002\u0011\r\u0011\"\u0001L\u0011\u00191\u0006\u0001)A\u0005\u0019\"9q\u000b\u0001b\u0001\n\u0003A\u0006B\u00023\u0001A\u0003%\u0011\fC\u0004f\u0001\t\u0007I\u0011\u0001-\t\r\u0019\u0004\u0001\u0015!\u0003Z\u0011\u001d9\u0007A1A\u0005\u0002!Da!\u001c\u0001!\u0002\u0013I\u0007b\u00028\u0001\u0005\u0004%\ta\u001c\u0005\u0007i\u0002\u0001\u000b\u0011\u00029\t\u000fU\u0004!\u0019!C\u0001m\"1!\u0010\u0001Q\u0001\n]Dqa\u001f\u0001C\u0002\u0013\u0005A\u0010C\u0004\u0002\u001a\u0001\u0001\u000b\u0011B?\t\u0013\u0005m\u0001A1A\u0005\u0002\u0005u\u0001\u0002CA\u0019\u0001\u0001\u0006I!a\b\t\u0013\u0005M\u0002A1A\u0005\u0002\u0005U\u0002\u0002CA\u001f\u0001\u0001\u0006I!a\u000e\t\u0013\u0005}\u0002A1A\u0005\n\u0005\u0005\u0003\u0002CA(\u0001\u0001\u0006I!a\u0011\t\u000f\u0005E\u0003\u0001\"\u0001\u0002T!9\u00111\f\u0001\u0005\u0002\u0005u\u0003bBA3\u0001\u0011\u0005\u0011q\r\u0005\b\u0003s\u0002A\u0011AA>\u000f\u001d\t\ti\nE\u0001\u0003\u00073aAJ\u0014\t\u0002\u0005\u0015\u0005BB\u001f\u001e\t\u0003\t9\tC\u0005\u0002\nv\u0011\r\u0011\"\u0001\u0002\f\"A\u0011\u0011T\u000f!\u0002\u0013\ti\tC\u0006\u0002\u001cv\u0001\r\u00111A\u0005\n\u0005u\u0005bCAP;\u0001\u0007\t\u0019!C\u0005\u0003CC!\"!,\u001e\u0001\u0004\u0005\t\u0015)\u0003@\u0011\u0019\ty+\bC\u0001}!9\u0011\u0011W\u000f\u0005\u0002\u0005M&!D'f[>\u0014\u00180T8oSR|'O\u0003\u0002)S\u00051Q.Z7pefT!AK\u0016\u0002\u000bM\u0004\u0018M]6\u000b\u00051j\u0013AB1qC\u000eDWMC\u0001/\u0003\ry'oZ\u0002\u0001'\r\u0001\u0011g\u000e\t\u0003eUj\u0011a\r\u0006\u0002i\u0005)1oY1mC&\u0011ag\r\u0002\u0007\u0003:L(+\u001a4\u0011\u0005aZT\"A\u001d\u000b\u0005iJ\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005qJ$a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003}\u0002\"\u0001\u0011\u0001\u000e\u0003\u001d\nQc\u001d9be.lU-\\'b]\u0006<WM\u001d%b]\u0012dW-F\u0001D!\r\u0011DIR\u0005\u0003\u000bN\u0012aa\u00149uS>t\u0007C\u0001!H\u0013\tAuE\u0001\rTa\u0006\u00148.T3n_JLX*\u00198bO\u0016\u0014\b*\u00198eY\u0016\fac\u001d9be.lU-\\'b]\u0006<WM\u001d%b]\u0012dW\rI\u0001\u000b[\u0016lwN]=CK\u0006tW#\u0001'\u0011\u00055#V\"\u0001(\u000b\u0005=\u0003\u0016AC7b]\u0006<W-\\3oi*\u0011\u0011KU\u0001\u0005Y\u0006twMC\u0001T\u0003\u0011Q\u0017M^1\n\u0005Us%\u0001D'f[>\u0014\u00180\u0014-CK\u0006t\u0017aC7f[>\u0014\u0018PQ3b]\u0002\n\u0011\u0002]8pY\n+\u0017M\\:\u0016\u0003e\u00032AW0b\u001b\u0005Y&B\u0001/^\u0003\u001diW\u000f^1cY\u0016T!AX\u001a\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002a7\n1!)\u001e4gKJ\u0004\"!\u00142\n\u0005\rt%\u0001E'f[>\u0014\u0018\u0010U8pY6C&)Z1o\u0003)\u0001xn\u001c7CK\u0006t7\u000fI\u0001\u0011_\u001a4\u0007*Z1q!>|GNQ3b]N\f\u0011c\u001c4g\u0011\u0016\f\u0007\u000fU8pY\n+\u0017M\\:!\u0003A\u0011WO\u001a4feB{w\u000e\\:CK\u0006t7/F\u0001j!\rQvL\u001b\t\u0003\u001b.L!\u0001\u001c(\u0003!\t+hMZ3s!>|G.\u0014-CK\u0006t\u0017!\u00052vM\u001a,'\u000fU8pYN\u0014U-\u00198tA\u00059qm\u0019\"fC:\u001cX#\u00019\u0011\u0007i{\u0016\u000f\u0005\u0002Ne&\u00111O\u0014\u0002\u0017\u000f\u0006\u0014(-Y4f\u0007>dG.Z2u_Jl\u0005LQ3b]\u0006Aqm\u0019\"fC:\u001c\b%A\btsN$X-\\%oM>\u0014U-\u00198t+\u00059\bCA'y\u0013\tIhJA\u000bPa\u0016\u0014\u0018\r^5oONK8\u000f^3n\u001bb\u0013U-\u00198\u0002!ML8\u000f^3n\u0013:4wNQ3b]N\u0004\u0013aB4fiR,'o]\u000b\u0002{B)a0!\u0004\u0002\u00149\u0019q0!\u0003\u000f\t\u0005\u0005\u0011qA\u0007\u0003\u0003\u0007Q1!!\u00020\u0003\u0019a$o\\8u}%\tA'C\u0002\u0002\fM\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002\u0010\u0005E!aA*fc*\u0019\u00111B\u001a\u0011\u0007\u0001\u000b)\"C\u0002\u0002\u0018\u001d\u0012A\"T3n_JLx)\u001a;uKJ\f\u0001bZ3ui\u0016\u00148\u000fI\u0001\n]\u0006lW-\u00138g_N,\"!a\b\u0011\u000by\fi!!\t\u0011\t\u0005\r\u00121\u0006\b\u0005\u0003K\t9\u0003E\u0002\u0002\u0002MJ1!!\u000b4\u0003\u0019\u0001&/\u001a3fM&!\u0011QFA\u0018\u0005\u0019\u0019FO]5oO*\u0019\u0011\u0011F\u001a\u0002\u00159\fW.Z%oM>\u001c\b%\u0001\bo\u001b\u0016$(/[2t\u0019\u0016tw\r\u001e5\u0016\u0005\u0005]\u0002c\u0001\u001a\u0002:%\u0019\u00111H\u001a\u0003\u0007%sG/A\bo\u001b\u0016$(/[2t\u0019\u0016tw\r\u001e5!\u0003=9W\r\u001e;fe\u0006sGm\u00144gg\u0016$XCAA\"!\u0019\t)%a\u0012\u0002J5\tQ,C\u0002\u0002\u0010u\u0003rAMA&\u0003'\t9$C\u0002\u0002NM\u0012a\u0001V;qY\u0016\u0014\u0014\u0001E4fiR,'/\u00118e\u001f\u001a47/\u001a;!\u0003=\u0019w\u000e\u001c7fGR\u001cf.\u00199tQ>$XCAA+!\r\u0001\u0015qK\u0005\u0004\u00033:#AD'f[>\u0014\u0018p\u00158baNDw\u000e^\u0001\u0012G>dG.Z2u)\"\u0014X-\u00193J]\u001a|WCAA0!\r\u0001\u0015\u0011M\u0005\u0004\u0003G:#A\u0005+ie\u0016\fG-\u00138g_Ns\u0017\r]:i_R\faBZ8s[\u0006$8K\\1qg\"|G\u000f\u0006\u0003\u0002j\u0005U\u0004CBA6\u0003c\n\t#\u0004\u0002\u0002n)\u0019\u0011q\u000e*\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003g\niG\u0001\u0003MSN$\bbBA<5\u0001\u0007\u0011QK\u0001\u0004[\u0016l\u0017\u0001\u00054pe6\fG\u000f\u00165sK\u0006$G)^7q)\u0011\tI'! \t\u000f\u0005}4\u00041\u0001\u0002`\u0005\u0011B\u000f\u001b:fC\u0012LeNZ8T]\u0006\u00048\u000f[8u\u00035iU-\\8ss6{g.\u001b;peB\u0011\u0001)H\n\u0004;E:DCAAB\u0003)!\u0017\r^3G_Jl\u0017\r^\u000b\u0003\u0003\u001b\u0003B!a$\u0002\u00166\u0011\u0011\u0011\u0013\u0006\u0004\u0003'\u0013\u0016\u0001\u0002;fqRLA!a&\u0002\u0012\n\u00012+[7qY\u0016$\u0015\r^3G_Jl\u0017\r^\u0001\fI\u0006$XMR8s[\u0006$\b%A\u0004n_:LGo\u001c:\u0016\u0003}\n1\"\\8oSR|'o\u0018\u0013fcR!\u00111UAU!\r\u0011\u0014QU\u0005\u0004\u0003O\u001b$\u0001B+oSRD\u0001\"a+#\u0003\u0003\u0005\raP\u0001\u0004q\u0012\n\u0014\u0001C7p]&$xN\u001d\u0011\u0002\u000f%t7\u000f^1mY\u0006iq-\u001a;UQJ,\u0017\rZ%oM>,\"!!.\u0011\u000bI\n9,a/\n\u0007\u0005e6GA\u0003BeJ\f\u0017\u0010E\u0002N\u0003{K1!a0O\u0005)!\u0006N]3bI&sgm\u001c")
public class MemoryMonitor
implements Logging {
    private final Option<SparkMemoryManagerHandle> sparkMemManagerHandle;
    private final MemoryMXBean memoryBean;
    private final Buffer<MemoryPoolMXBean> poolBeans;
    private final Buffer<MemoryPoolMXBean> offHeapPoolBeans;
    private final Buffer<BufferPoolMXBean> bufferPoolsBeans;
    private final Buffer<GarbageCollectorMXBean> gcBeans;
    private final OperatingSystemMXBean systemInfoBeans;
    private final Seq<MemoryGetter> getters;
    private final Seq<String> nameInfos;
    private final int nMetricsLength;
    private final Seq<Tuple2<MemoryGetter, Object>> getterAndOffset;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static ThreadInfo[] getThreadInfo() {
        return MemoryMonitor$.MODULE$.getThreadInfo();
    }

    public static MemoryMonitor install() {
        return MemoryMonitor$.MODULE$.install();
    }

    public static SimpleDateFormat dateFormat() {
        return MemoryMonitor$.MODULE$.dateFormat();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Option<SparkMemoryManagerHandle> sparkMemManagerHandle() {
        return this.sparkMemManagerHandle;
    }

    public MemoryMXBean memoryBean() {
        return this.memoryBean;
    }

    public Buffer<MemoryPoolMXBean> poolBeans() {
        return this.poolBeans;
    }

    public Buffer<MemoryPoolMXBean> offHeapPoolBeans() {
        return this.offHeapPoolBeans;
    }

    public Buffer<BufferPoolMXBean> bufferPoolsBeans() {
        return this.bufferPoolsBeans;
    }

    public Buffer<GarbageCollectorMXBean> gcBeans() {
        return this.gcBeans;
    }

    public OperatingSystemMXBean systemInfoBeans() {
        return this.systemInfoBeans;
    }

    public Seq<MemoryGetter> getters() {
        return this.getters;
    }

    public Seq<String> nameInfos() {
        return this.nameInfos;
    }

    public int nMetricsLength() {
        return this.nMetricsLength;
    }

    private Seq<Tuple2<MemoryGetter, Object>> getterAndOffset() {
        return this.getterAndOffset;
    }

    public MemorySnapshot collectSnapshot() {
        long now = System.currentTimeMillis();
        long[] values = new long[this.nMetricsLength()];
        this.getterAndOffset().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            MemoryMonitor.$anonfun$collectSnapshot$1(values, x0$1);
            return BoxedUnit.UNIT;
        });
        return new MemorySnapshot(now, values);
    }

    public ThreadInfoSnapshot collectThreadInfo() {
        long now = System.currentTimeMillis();
        ThreadInfo[] infos = MemoryMonitor$.MODULE$.getThreadInfo();
        ListBuffer metricsThreadInfos = new ListBuffer();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])infos)).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ThreadInfo threadInfo = x0$1;
            ListBuffer listBuffer = metricsThreadInfos.$plus$eq((Object)MetricsThreadInfo$.MODULE$.wrap(threadInfo));
            return listBuffer;
        });
        return new ThreadInfoSnapshot(now, (MetricsThreadInfo[])metricsThreadInfos.toArray(ClassTag$.MODULE$.apply(MetricsThreadInfo.class)));
    }

    /*
     * WARNING - void declaration
     */
    public java.util.List<String> formatSnapshot(MemorySnapshot mem) {
        void var2_2;
        ArrayList memList = Lists.newArrayList();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(13).append("Mem usage at ").append(MemoryMonitor$.MODULE$.dateFormat().format(BoxesRunTime.boxToLong((long)mem.time()))).toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "===============");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.nMetricsLength()).foreach((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)idx -> {
            long v = mem.values()[idx];
            String formattedV = new StringBuilder(3).append((String)this.nameInfos().apply(idx)).append(":").append(Utils$.MODULE$.bytesToString(v)).append("(").append(v).append(")").toString();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> formattedV);
            return memList.add(formattedV);
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public java.util.List<String> formatThreadDump(ThreadInfoSnapshot threadInfoSnapshot) {
        void var2_2;
        ArrayList threadInfoList = Lists.newArrayList();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])threadInfoSnapshot.values())).foreach((Function1 & Serializable & scala.Serializable)t -> {
            MemoryMonitor.$anonfun$formatThreadDump$1(this, threadInfoList, t);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$offHeapPoolBeans$1(MemoryPoolMXBean pool) {
        return !pool.isCollectionUsageThresholdSupported() && pool.isUsageThresholdSupported();
    }

    public static final /* synthetic */ void $anonfun$collectSnapshot$1(long[] values$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        MemoryGetter g = (MemoryGetter)tuple2._1();
        int offset = tuple2._2$mcI$sp();
        g.values(values$1, offset);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$formatThreadDump$4(MemoryMonitor $this, ArrayList threadInfoList$1, StackTraceElement elem) {
        threadInfoList$1.add(new StringBuilder(4).append("    ").append(elem).toString());
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append("\t").append(elem).toString());
    }

    public static final /* synthetic */ void $anonfun$formatThreadDump$1(MemoryMonitor $this, ArrayList threadInfoList$1, MetricsThreadInfo t) {
        if (t == null) {
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "<null thread>");
        } else {
            String headInfo = new StringBuilder(2).append(t.threadId()).append(" ").append(t.threadName()).append(" ").append(t.threadState().name()).toString();
            threadInfoList$1.add(headInfo);
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> headInfo);
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])t.stackTrace())).foreach((Function1 & Serializable & scala.Serializable)elem -> {
                MemoryMonitor.$anonfun$formatThreadDump$4($this, threadInfoList$1, elem);
                return BoxedUnit.UNIT;
            });
        }
    }

    public MemoryMonitor() {
        Logging.$init$((Logging)this);
        this.sparkMemManagerHandle = SparkMemoryManagerHandle$.MODULE$.get();
        this.memoryBean = ManagementFactory.getMemoryMXBean();
        this.poolBeans = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(ManagementFactory.getMemoryPoolMXBeans()).asScala();
        this.offHeapPoolBeans = (Buffer)this.poolBeans().filter((Function1 & Serializable & scala.Serializable)pool -> BoxesRunTime.boxToBoolean((boolean)MemoryMonitor.$anonfun$offHeapPoolBeans$1(pool)));
        this.bufferPoolsBeans = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(ManagementFactory.getPlatformMXBeans(BufferPoolMXBean.class)).asScala();
        this.gcBeans = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(ManagementFactory.getGarbageCollectorMXBeans()).asScala();
        this.systemInfoBeans = ManagementFactory.getOperatingSystemMXBean();
        this.getters = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)new .colon.colon((Object)new MemoryMxBeanGetter(this.memoryBean()), (List)Nil$.MODULE$)).$plus$plus((GenTraversableOnce)this.offHeapPoolBeans().map((Function1 & Serializable & scala.Serializable)x$1 -> new PoolGetter((MemoryPoolMXBean)x$1), Buffer$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.bufferPoolsBeans().map((Function1 & Serializable & scala.Serializable)x$2 -> new BufferPoolGetter((BufferPoolMXBean)x$2), Buffer$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)this.gcBeans().map((Function1 & Serializable & scala.Serializable)x$3 -> new GcInfoGetter((GarbageCollectorMXBean)x$3), Buffer$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)new SystemInfoGetter(this.systemInfoBeans()), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(this.sparkMemManagerHandle()).toSeq(), Seq$.MODULE$.canBuildFrom());
        this.nameInfos = (Seq)this.getters().flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.names(), Seq$.MODULE$.canBuildFrom());
        this.nMetricsLength = this.nameInfos().length();
        IntRef offset = IntRef.create((int)0);
        this.getterAndOffset = (Seq)this.getters().map((Function1 & Serializable & scala.Serializable)g -> {
            int thisOffset = offset$1.elem;
            offset$1.elem += g.names().length();
            return new Tuple2(g, (Object)BoxesRunTime.boxToInteger((int)thisOffset));
        }, Seq$.MODULE$.canBuildFrom());
    }
}

