/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.ColumnName;
import org.apache.spark.sql.FunctionEntity;
import org.apache.spark.sql.FunctionEntity$;
import org.apache.spark.sql.KylinDayOfWeek;
import org.apache.spark.sql.KylinSubtractMonths;
import org.apache.spark.sql.TRUNCATE;
import org.apache.spark.sql.catalyst.expressions.ApproxCountDistinctDecode;
import org.apache.spark.sql.catalyst.expressions.DictEncode;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionUtils$;
import org.apache.spark.sql.catalyst.expressions.In;
import org.apache.spark.sql.catalyst.expressions.KylinAddMonths;
import org.apache.spark.sql.catalyst.expressions.Like;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.PercentileDecode;
import org.apache.spark.sql.catalyst.expressions.PreciseCountDistinctDecode;
import org.apache.spark.sql.catalyst.expressions.ScatterSkewData;
import org.apache.spark.sql.catalyst.expressions.SplitPart;
import org.apache.spark.sql.catalyst.expressions.Sum0;
import org.apache.spark.sql.catalyst.expressions.TimestampAdd;
import org.apache.spark.sql.catalyst.expressions.TimestampDiff;
import org.apache.spark.sql.catalyst.expressions.Truncate;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.udaf.ApproxCountDistinct;
import org.apache.spark.sql.udaf.ApproxCountDistinct$;
import org.apache.spark.sql.udaf.IntersectCount;
import org.apache.spark.sql.udaf.IntersectCount$;
import org.apache.spark.sql.udaf.PreciseCountDistinct;
import org.apache.spark.sql.udaf.PreciseCountDistinct$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Symbol;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class KylinFunctions$ {
    public static KylinFunctions$ MODULE$;
    private final Seq<FunctionEntity> builtin;

    static {
        new KylinFunctions$();
    }

    private Column withAggregateFunction(AggregateFunction func, boolean isDistinct) {
        return Column$.MODULE$.apply((Expression)func.toAggregateExpression(isDistinct, func.toAggregateExpression$default$2()));
    }

    private boolean withAggregateFunction$default$2() {
        return false;
    }

    public Column kylin_add_months(Column startDate, Column numMonths) {
        return Column$.MODULE$.apply((Expression)new KylinAddMonths(startDate.expr(), numMonths.expr()));
    }

    public Column dict_encode(Column column, Column dictParams, Column bucketSize) {
        return Column$.MODULE$.apply((Expression)new DictEncode(column.expr(), dictParams.expr(), bucketSize.expr()));
    }

    public Column scatter_skew_data(Column column, Column skewDataStorage) {
        return Column$.MODULE$.apply((Expression)new ScatterSkewData(column.expr(), skewDataStorage.expr()));
    }

    public Column k_lit(Object literal) {
        Column column;
        Object object = literal;
        if (object instanceof Column) {
            Column column2;
            column = column2 = (Column)object;
        } else if (object instanceof Symbol) {
            Symbol symbol = (Symbol)object;
            column = new ColumnName(symbol.name());
        } else {
            column = Column$.MODULE$.apply((Expression)Literal$.MODULE$.apply(literal));
        }
        return column;
    }

    public Column k_like(Column left, Column right) {
        return Column$.MODULE$.apply((Expression)new Like(left.expr(), right.expr()));
    }

    public Column in(Expression value, Seq<Expression> list) {
        return Column$.MODULE$.apply((Expression)new In(value, list));
    }

    public Column kylin_day_of_week(Column date) {
        return Column$.MODULE$.apply((Expression)new KylinDayOfWeek(date.expr()));
    }

    public Column kylin_truncate(Column column, int scale) {
        return Column$.MODULE$.apply((Expression)new TRUNCATE(column.expr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)scale))));
    }

    public Column kylin_subtract_months(Column date0, Column date1) {
        return Column$.MODULE$.apply((Expression)new KylinSubtractMonths(date0.expr(), date1.expr()));
    }

    public Column precise_count_distinct_decode(Column column) {
        return Column$.MODULE$.apply((Expression)new PreciseCountDistinctDecode(column.expr()));
    }

    public Column approx_count_distinct_decode(Column column, int precision) {
        return Column$.MODULE$.apply((Expression)new ApproxCountDistinctDecode(column.expr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)precision))));
    }

    public Column k_percentile_decode(Column column, Column p, int precision) {
        return Column$.MODULE$.apply((Expression)new PercentileDecode(column.expr(), p.expr(), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)precision))));
    }

    public Column precise_count_distinct(Column column) {
        return Column$.MODULE$.apply((Expression)new PreciseCountDistinct(column.expr(), PreciseCountDistinct$.MODULE$.apply$default$2(), PreciseCountDistinct$.MODULE$.apply$default$3()).toAggregateExpression());
    }

    public Column approx_count_distinct(Column column, int precision) {
        return Column$.MODULE$.apply((Expression)new ApproxCountDistinct(column.expr(), precision, ApproxCountDistinct$.MODULE$.apply$default$3(), ApproxCountDistinct$.MODULE$.apply$default$4()).toAggregateExpression());
    }

    public Column intersect_count(int upperBound, Seq<Column> columns) {
        Predef$.MODULE$.require(columns.size() == 3, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Input columns size ").append(columns.size()).append(" don't equal to 3.").toString());
        Seq expressions = (Seq)columns.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.expr(), Seq$.MODULE$.canBuildFrom());
        return Column$.MODULE$.apply((Expression)new IntersectCount((Expression)expressions.apply(0), (Expression)expressions.apply(1), (Expression)expressions.apply(2), (DataType)LongType$.MODULE$, upperBound, IntersectCount$.MODULE$.apply$default$6(), IntersectCount$.MODULE$.apply$default$7()).toAggregateExpression());
    }

    public Column intersect_value(int upperBound, Seq<Column> columns) {
        Predef$.MODULE$.require(columns.size() == 3, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Input columns size ").append(columns.size()).append(" don't equal to 3.").toString());
        Seq expressions = (Seq)columns.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.expr(), Seq$.MODULE$.canBuildFrom());
        return Column$.MODULE$.apply((Expression)new IntersectCount((Expression)expressions.apply(0), (Expression)expressions.apply(1), (Expression)expressions.apply(2), (DataType)StringType$.MODULE$, upperBound, IntersectCount$.MODULE$.apply$default$6(), IntersectCount$.MODULE$.apply$default$7()).toAggregateExpression());
    }

    public Column sum0(Column e) {
        return this.withAggregateFunction((AggregateFunction)new Sum0(e.expr()), this.withAggregateFunction$default$2());
    }

    public Seq<FunctionEntity> builtin() {
        return this.builtin;
    }

    private KylinFunctions$() {
        MODULE$ = this;
        this.builtin = (Seq)new .colon.colon((Object)FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("TIMESTAMPADD", ClassTag$.MODULE$.apply(TimestampAdd.class))), (List)new .colon.colon((Object)FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("TIMESTAMPDIFF", ClassTag$.MODULE$.apply(TimestampDiff.class))), (List)new .colon.colon((Object)FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("TRUNCATE", ClassTag$.MODULE$.apply(Truncate.class))), (List)new .colon.colon((Object)FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("DICTENCODE", ClassTag$.MODULE$.apply(DictEncode.class))), (List)new .colon.colon((Object)FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("split_part", ClassTag$.MODULE$.apply(SplitPart.class))), (List)new .colon.colon((Object)FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("precise_count_distinct_decode", ClassTag$.MODULE$.apply(PreciseCountDistinctDecode.class))), (List)new .colon.colon((Object)FunctionEntity$.MODULE$.apply(ExpressionUtils$.MODULE$.expression("approx_count_distinct_decode", ClassTag$.MODULE$.apply(ApproxCountDistinctDecode.class))), (List)Nil$.MODULE$)))))));
    }
}

