/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.kylin.engine.spark.common.util.KylinDateTimeUtils$;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.BinaryExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.KylinAddMonths$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.TimestampType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(start_date, num_months) - Returns the date that is `num_months` after `start_date`.", extended="\n    Examples:\n      > SELECT _FUNC_('2016-08-31', 1);\n       2016-09-30\n  ")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dg\u0001B\u000f\u001f\u0001.B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!\u0010\u0005\t\u0003\u0002\u0011\t\u0012)A\u0005}!A!\t\u0001BK\u0002\u0013\u0005Q\b\u0003\u0005D\u0001\tE\t\u0015!\u0003?\u0011\u0015!\u0005\u0001\"\u0001F\u0011\u0015I\u0005\u0001\"\u0011>\u0011\u0015Q\u0005\u0001\"\u0011>\u0011\u0015Y\u0005\u0001\"\u0011M\u0011\u0015y\u0006\u0001\"\u0011a\u0011\u0015!\u0007\u0001\"\u0011f\u0011\u0015i\u0007\u0001\"\u0011o\u0011\u0015a\b\u0001\"\u0011~\u0011%\ti\u0001AA\u0001\n\u0003\ty\u0001C\u0005\u0002\u0016\u0001\t\n\u0011\"\u0001\u0002\u0018!I\u0011Q\u0006\u0001\u0012\u0002\u0013\u0005\u0011q\u0003\u0005\n\u0003_\u0001\u0011\u0011!C!\u0003cA\u0011\"!\u0011\u0001\u0003\u0003%\t!a\u0011\t\u0013\u0005-\u0003!!A\u0005\u0002\u00055\u0003\"CA*\u0001\u0005\u0005I\u0011IA+\u0011%\t\u0019\u0007AA\u0001\n\u0003\t)\u0007C\u0005\u0002p\u0001\t\t\u0011\"\u0011\u0002r\u001dI\u0011\u0011\u0012\u0010\u0002\u0002#\u0005\u00111\u0012\u0004\t;y\t\t\u0011#\u0001\u0002\u000e\"1Ai\u0006C\u0001\u00037C\u0011\"!(\u0018\u0003\u0003%)%a(\t\u0013\u0005\u0005v#!A\u0005\u0002\u0006\r\u0006\"CAU/\u0005\u0005I\u0011QAV\u0011%\tilFA\u0001\n\u0013\tyL\u0001\bLs2Lg.\u00113e\u001b>tG\u000f[:\u000b\u0005}\u0001\u0013aC3yaJ,7o]5p]NT!!\t\u0012\u0002\u0011\r\fG/\u00197zgRT!a\t\u0013\u0002\u0007M\fHN\u0003\u0002&M\u0005)1\u000f]1sW*\u0011q\u0005K\u0001\u0007CB\f7\r[3\u000b\u0003%\n1a\u001c:h\u0007\u0001\u0019R\u0001\u0001\u00171ge\u0002\"!\f\u0018\u000e\u0003yI!a\f\u0010\u0003!\tKg.\u0019:z\u000bb\u0004(/Z:tS>t\u0007CA\u00172\u0013\t\u0011dD\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u001d\u0001&o\u001c3vGR\u0004\"\u0001\u000e\u001e\n\u0005m*$\u0001D*fe&\fG.\u001b>bE2,\u0017!C:uCJ$H)\u0019;f+\u0005q\u0004CA\u0017@\u0013\t\u0001eD\u0001\u0006FqB\u0014Xm]:j_:\f!b\u001d;beR$\u0015\r^3!\u0003%qW/\\'p]RD7/\u0001\u0006ok6luN\u001c;ig\u0002\na\u0001P5oSRtDc\u0001$H\u0011B\u0011Q\u0006\u0001\u0005\u0006y\u0015\u0001\rA\u0010\u0005\u0006\u0005\u0016\u0001\rAP\u0001\u0005Y\u00164G/A\u0003sS\u001eDG/\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0014\t\u0004\u001dZKfBA(U\u001d\t\u00016+D\u0001R\u0015\t\u0011&&\u0001\u0004=e>|GOP\u0005\u0002m%\u0011Q+N\u0001\ba\u0006\u001c7.Y4f\u0013\t9\u0006LA\u0002TKFT!!V\u001b\u0011\u0005ikV\"A.\u000b\u0005q\u0013\u0013!\u0002;za\u0016\u001c\u0018B\u00010\\\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\u0005\t\u0007C\u0001.c\u0013\t\u00197LA\u0007US6,7\u000f^1naRK\b/Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0004M&\\\u0007C\u0001\u001bh\u0013\tAWGA\u0002B]fDQA\u001b\u0006A\u0002\u0019\fQa\u001d;beRDQ\u0001\u001c\u0006A\u0002\u0019\fa!\\8oi\"\u001c\u0018!\u00033p\u000f\u0016t7i\u001c3f)\ryWO\u001f\t\u0003aNl\u0011!\u001d\u0006\u0003ez\tqaY8eK\u001e,g.\u0003\u0002uc\nAQ\t\u001f9s\u0007>$W\rC\u0003w\u0017\u0001\u0007q/A\u0002dib\u0004\"\u0001\u001d=\n\u0005e\f(AD\"pI\u0016<WM\\\"p]R,\u0007\u0010\u001e\u0005\u0006w.\u0001\ra\\\u0001\u0003KZ\f!\u0002\u001d:fiRLh*Y7f+\u0005q\bcA@\u0002\b9!\u0011\u0011AA\u0002!\t\u0001V'C\u0002\u0002\u0006U\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0005\u0003\u0017\u0011aa\u0015;sS:<'bAA\u0003k\u0005!1m\u001c9z)\u00151\u0015\u0011CA\n\u0011\u001daT\u0002%AA\u0002yBqAQ\u0007\u0011\u0002\u0003\u0007a(\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005e!f\u0001 \u0002\u001c-\u0012\u0011Q\u0004\t\u0005\u0003?\tI#\u0004\u0002\u0002\")!\u00111EA\u0013\u0003%)hn\u00195fG.,GMC\u0002\u0002(U\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY#!\t\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t\u0019\u0004\u0005\u0003\u00026\u0005}RBAA\u001c\u0015\u0011\tI$a\u000f\u0002\t1\fgn\u001a\u0006\u0003\u0003{\tAA[1wC&!\u0011\u0011BA\u001c\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\t)\u0005E\u00025\u0003\u000fJ1!!\u00136\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\r1\u0017q\n\u0005\n\u0003#\u0012\u0012\u0011!a\u0001\u0003\u000b\n1\u0001\u001f\u00132\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAA,!\u0015\tI&a\u0018g\u001b\t\tYFC\u0002\u0002^U\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\t'a\u0017\u0003\u0011%#XM]1u_J\f\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003O\ni\u0007E\u00025\u0003SJ1!a\u001b6\u0005\u001d\u0011un\u001c7fC:D\u0001\"!\u0015\u0015\u0003\u0003\u0005\rAZ\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005\u001d\u00141\u000f\u0005\t\u0003#*\u0012\u0011!a\u0001M\"Z\u0001!a\u001e\u0002~\u0005}\u00141QAC!\ri\u0013\u0011P\u0005\u0004\u0003wr\"!F#yaJ,7o]5p]\u0012+7o\u0019:jaRLwN\\\u0001\u0006kN\fw-Z\u0011\u0003\u0003\u0003\u000b!l\u0018$V\u001d\u000e{\u0006f\u001d;beR|F-\u0019;fY\u0001rW/\\0n_:$\bn]\u0015![\u0001\u0012V\r^;s]N\u0004C\u000f[3!I\u0006$X\r\t;iCR\u0004\u0013n\u001d\u0011a]Vlw,\\8oi\"\u001c\b\rI1gi\u0016\u0014\b\u0005Y:uCJ$x\fZ1uK\u0002t\u0013\u0001C3yi\u0016tG-\u001a3\"\u0005\u0005\u001d\u0015a\u0013\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!?\u001a+fjQ0)OI\u0002\u0014GN\u00171q5\u001a\u0014g\n\u0017!c%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u00192m5\u0002\u0014(L\u001a1\u0015\u0001\u0002\u0013AD&zY&t\u0017\t\u001a3N_:$\bn\u001d\t\u0003[]\u0019BaFAHsA9\u0011\u0011SAL}y2UBAAJ\u0015\r\t)*N\u0001\beVtG/[7f\u0013\u0011\tI*a%\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007\u0006\u0002\u0002\f\u0006AAo\\*ue&tw\r\u0006\u0002\u00024\u0005)\u0011\r\u001d9msR)a)!*\u0002(\")AH\u0007a\u0001}!)!I\u0007a\u0001}\u00059QO\\1qa2LH\u0003BAW\u0003s\u0003R\u0001NAX\u0003gK1!!-6\u0005\u0019y\u0005\u000f^5p]B)A'!.?}%\u0019\u0011qW\u001b\u0003\rQ+\b\u000f\\33\u0011!\tYlGA\u0001\u0002\u00041\u0015a\u0001=%a\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\t\t\r\u0005\u0003\u00026\u0005\r\u0017\u0002BAc\u0003o\u0011aa\u00142kK\u000e$\b")
public class KylinAddMonths
extends BinaryExpression
implements ImplicitCastInputTypes,
scala.Serializable {
    private final Expression startDate;
    private final Expression numMonths;

    public static Option<Tuple2<Expression, Expression>> unapply(KylinAddMonths kylinAddMonths) {
        return KylinAddMonths$.MODULE$.unapply(kylinAddMonths);
    }

    public static Function1<Tuple2<Expression, Expression>, KylinAddMonths> tupled() {
        return KylinAddMonths$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, KylinAddMonths>> curried() {
        return KylinAddMonths$.MODULE$.curried();
    }

    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$((ExpectsInputTypes)this);
    }

    public Expression startDate() {
        return this.startDate;
    }

    public Expression numMonths() {
        return this.numMonths;
    }

    public Expression left() {
        return this.startDate();
    }

    public Expression right() {
        return this.numMonths();
    }

    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)IntegerType$.MODULE$, (List)Nil$.MODULE$));
    }

    public TimestampType dataType() {
        return TimestampType$.MODULE$;
    }

    public Object nullSafeEval(Object start, Object months) {
        long time = BoxesRunTime.unboxToLong((Object)start);
        int month = BoxesRunTime.unboxToInt((Object)months);
        return BoxesRunTime.boxToLong((long)KylinDateTimeUtils$.MODULE$.addMonths(time, month));
    }

    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String dtu = new StringOps(Predef$.MODULE$.augmentString(KylinDateTimeUtils$.MODULE$.getClass().getName())).stripSuffix("$");
        return this.defineCodeGen(ctx, ev, (Function2 & Serializable & scala.Serializable)(sd, m) -> new StringBuilder(14).append(dtu).append(".addMonths(").append((String)sd).append(", ").append((String)m).append(")").toString());
    }

    public String prettyName() {
        return "kylin_add_months";
    }

    public KylinAddMonths copy(Expression startDate, Expression numMonths) {
        return new KylinAddMonths(startDate, numMonths);
    }

    public Expression copy$default$1() {
        return this.startDate();
    }

    public Expression copy$default$2() {
        return this.numMonths();
    }

    public String productPrefix() {
        return "KylinAddMonths";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.startDate();
                break;
            }
            case 1: {
                expression = this.numMonths();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof KylinAddMonths;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof KylinAddMonths)) return false;
        boolean bl = true;
        if (!bl) return false;
        KylinAddMonths kylinAddMonths = (KylinAddMonths)((Object)x$1);
        Expression expression = this.startDate();
        Expression expression2 = kylinAddMonths.startDate();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.numMonths();
        Expression expression4 = kylinAddMonths.numMonths();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!kylinAddMonths.canEqual((Object)this)) return false;
        return true;
    }

    public KylinAddMonths(Expression startDate, Expression numMonths) {
        this.startDate = startDate;
        this.numMonths = numMonths;
        ExpectsInputTypes.$init$((ExpectsInputTypes)this);
    }
}

