/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.hive.utils;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.metadata.FunctionDesc;
import org.apache.kylin.engine.spark.metadata.cube.model.LayoutEntity;
import org.apache.kylin.shaded.com.google.common.collect.Maps;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.execution.FileSourceScanExec;
import org.apache.spark.sql.execution.LeafExecNode;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.columnar.InMemoryTableScanExec;
import org.apache.spark.sql.execution.exchange.BroadcastExchangeExec;
import org.apache.spark.sql.execution.exchange.ReusedExchangeExec;
import org.apache.spark.sql.hive.execution.HiveTableScanExec;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class ResourceDetectUtils$
implements Logging {
    public static ResourceDetectUtils$ MODULE$;
    private final Gson json;
    private final String cubingDetectItemFileSuffix;
    private final String samplingDetectItemFileSuffix;
    private final String countDistinctSuffix;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new ResourceDetectUtils$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Gson json() {
        return this.json;
    }

    public Seq<Path> getPaths(SparkPlan plan) {
        ObjectRef paths = ObjectRef.create((Object)((Seq)Nil$.MODULE$));
        plan.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ResourceDetectUtils$.$anonfun$getPaths$1(paths, x0$1);
            return BoxedUnit.UNIT;
        });
        return (Seq)paths.elem;
    }

    public String getPartitions(SparkPlan plan) {
        scala.collection.mutable.Map leafNodePartitionsLengthMap = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        IntRef pNum = IntRef.create((int)0);
        plan.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            ResourceDetectUtils$.$anonfun$getPartitions$1(leafNodePartitionsLengthMap, pNum, x0$1);
            return BoxedUnit.UNIT;
        });
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Partition num ").append(pNum$1.elem).toString());
        return Integer.toString(pNum.elem);
    }

    public java.util.Map<String, java.util.Map<String, List<String>>> listSourcePath(Path shareDir) throws IOException {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        FileStatus[] fileStatuses = fs.listStatus(shareDir, new PathFilter(){

            public boolean accept(Path path) {
                return path.toString().endsWith(ResourceDetectUtils$.MODULE$.fileName());
            }
        });
        HashMap<String, java.util.Map<String, List<String>>> resourcePaths = Maps.newHashMap();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileStatuses)).foreach((Function1 & Serializable & scala.Serializable)file -> {
            String fileName = file.getPath().getName();
            String segmentId = fileName.substring(0, fileName.indexOf(MODULE$.fileName()) - 1);
            java.util.Map map = (java.util.Map)MODULE$.readResourcePathsAs(file.getPath());
            return resourcePaths.put(segmentId, map);
        });
        return resourcePaths;
    }

    public boolean findCountDistinctMeasure(Collection<LayoutEntity> layouts) {
        boolean bl;
        Object object = new Object();
        try {
            ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(layouts).asScala()).foreach((Function1 & Serializable & scala.Serializable)layoutEntity -> {
                ResourceDetectUtils$.$anonfun$findCountDistinctMeasure$1(object, layoutEntity);
                return BoxedUnit.UNIT;
            });
            bl = false;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                bl = ex.value$mcZ$sp();
            }
            throw ex;
        }
        return bl;
    }

    public long getResourceSize(Seq<Path> paths) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)paths.map((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToLong((long)ResourceDetectUtils$.$anonfun$getResourceSize$1(path)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public long getMaxResourceSize(Path shareDir) {
        return BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.listSourcePath(shareDir).values()).asScala()).flatMap((Function1 & Serializable & scala.Serializable)value -> (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(value.values()).asScala()).map((Function1 & Serializable & scala.Serializable)v -> BoxesRunTime.boxToLong((long)ResourceDetectUtils$.MODULE$.getResourceSize((Seq<Path>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(v).asScala()).map((Function1 & Serializable & scala.Serializable)path -> new Path(path), Buffer$.MODULE$.canBuildFrom())))), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Long$.MODULE$));
    }

    public java.util.Map<String, Object> getSegmentSourceSize(Path shareDir) {
        return (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.listSourcePath(shareDir)).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ResourceDetectUtils$.$anonfun$getSegmentSourceSize$1(x$1)))).map((Function1 & Serializable & scala.Serializable)tp -> new Tuple2(tp._1(), (Object)BoxesRunTime.boxToLong((long)MODULE$.getResourceSize((Seq<Path>)((Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)((java.util.Map)tp._2()).get("-1")).asScala()).map((Function1 & Serializable & scala.Serializable)path -> new Path(path), Buffer$.MODULE$.canBuildFrom()))))), Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
    }

    public void write(Path path, Object item) {
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        try (FSDataOutputStream out = null;){
            out = fs.create(path);
            String str = this.json().toJson(item);
            byte[] bytes = str.getBytes(Charset.defaultCharset());
            out.writeInt(bytes.length);
            out.write(bytes);
        }
    }

    public String selectMaxValueInFiles(FileStatus[] files) {
        return new ArrayOps.ofDouble(Predef$.MODULE$.doubleArrayOps((double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToDouble((double)ResourceDetectUtils$.$anonfun$selectMaxValueInFiles$1(f)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())))).max((Ordering)Ordering.Double$.MODULE$).toString();
    }

    public java.util.Map<String, String> readDetectItems(Path path) {
        return (java.util.Map)this.readResourcePathsAs(path);
    }

    public <T> T readResourcePathsAs(Path path) {
        Object object;
        this.log().info(new StringBuilder(25).append("Read resource paths form ").append(path).toString());
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        try (FSDataInputStream in = null;){
            in = fs.open(path);
            int i = in.readInt();
            byte[] bytes = new byte[i];
            in.readFully(bytes);
            object = this.json().fromJson(new String(bytes, Charset.defaultCharset()), new TypeToken<T>(){}.getType());
        }
        return (T)object;
    }

    public String fileName() {
        return "resource_paths.json";
    }

    public String cubingDetectItemFileSuffix() {
        return this.cubingDetectItemFileSuffix;
    }

    public String samplingDetectItemFileSuffix() {
        return this.samplingDetectItemFileSuffix;
    }

    public String countDistinctSuffix() {
        return this.countDistinctSuffix;
    }

    public static final /* synthetic */ void $anonfun$getPaths$1(ObjectRef paths$1, SparkPlan x0$1) {
        SparkPlan sparkPlan = x0$1;
        if (sparkPlan instanceof FileSourceScanExec) {
            FileSourceScanExec fileSourceScanExec = (FileSourceScanExec)sparkPlan;
            paths$1.elem = (Seq)((Seq)paths$1.elem).$plus$plus((GenTraversableOnce)fileSourceScanExec.relation().location().rootPaths(), Seq$.MODULE$.canBuildFrom());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkPlan instanceof InMemoryTableScanExec) {
            InMemoryTableScanExec inMemoryTableScanExec = (InMemoryTableScanExec)sparkPlan;
            SparkPlan _plan = inMemoryTableScanExec.relation().cachedPlan();
            paths$1.elem = (Seq)((Seq)paths$1.elem).$plus$plus(MODULE$.getPaths(_plan), Seq$.MODULE$.canBuildFrom());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (sparkPlan instanceof HiveTableScanExec) {
            BoxedUnit boxedUnit;
            HiveTableScanExec hiveTableScanExec = (HiveTableScanExec)sparkPlan;
            if (hiveTableScanExec.relation().isPartitioned()) {
                hiveTableScanExec.rawPartitions().foreach((Function1 & Serializable & scala.Serializable)partition -> {
                    paths$1.elem = (Seq)((Seq)paths$1.elem).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partition.getPath())), Seq$.MODULE$.canBuildFrom());
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                paths$1.elem = (Seq)((Seq)paths$1.elem).$colon$plus((Object)new Path(hiveTableScanExec.relation().tableMeta().location()), Seq$.MODULE$.canBuildFrom());
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$getPartitions$1(scala.collection.mutable.Map leafNodePartitionsLengthMap$1, IntRef pNum$1, SparkPlan x0$1) {
        SparkPlan sparkPlan = x0$1;
        if (sparkPlan instanceof LeafExecNode) {
            ReusedExchangeExec reusedExchangeExec;
            LeafExecNode leafExecNode = (LeafExecNode)sparkPlan;
            LeafExecNode leafExecNode2 = leafExecNode;
            int n = leafExecNode2 instanceof ReusedExchangeExec && (reusedExchangeExec = (ReusedExchangeExec)leafExecNode2).child() instanceof BroadcastExchangeExec ? 1 : BoxesRunTime.unboxToInt((Object)leafNodePartitionsLengthMap$1.getOrElseUpdate((Object)((TreeNode)leafExecNode).nodeName(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> ((SparkPlan)leafExecNode).execute().partitions().length));
            int pn = n;
            pNum$1.elem += pn;
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(16).append(((TreeNode)leafExecNode).nodeName()).append(" partition size ").append(pn).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public static final /* synthetic */ void $anonfun$findCountDistinctMeasure$2(Object nonLocalReturnKey1$1, FunctionDesc measure) {
        if (measure.expression().equalsIgnoreCase("COUNT_DISTINCT")) {
            throw new NonLocalReturnControl.mcZ.sp(nonLocalReturnKey1$1, true);
        }
    }

    public static final /* synthetic */ void $anonfun$findCountDistinctMeasure$1(Object nonLocalReturnKey1$1, LayoutEntity layoutEntity) {
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(layoutEntity.getOrderedMeasures().values()).asScala()).foreach((Function1 & Serializable & scala.Serializable)measure -> {
            ResourceDetectUtils$.$anonfun$findCountDistinctMeasure$2(nonLocalReturnKey1$1, measure);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ long $anonfun$getResourceSize$1(Path path) {
        FileSystem fs = path.getFileSystem(HadoopUtil.getCurrentConfiguration());
        return fs.exists(path) ? HadoopUtil.getContentSummary(fs, path).getLength() : 0L;
    }

    public static final /* synthetic */ boolean $anonfun$getSegmentSourceSize$1(Tuple2 x$1) {
        return ((java.util.Map)x$1._2()).keySet().contains("-1");
    }

    public static final /* synthetic */ double $anonfun$selectMaxValueInFiles$1(FileStatus f) {
        return BoxesRunTime.unboxToDouble((Object)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(((java.util.Map)MODULE$.readResourcePathsAs(f.getPath())).values()).asScala()).max((Ordering)Ordering.Double$.MODULE$));
    }

    private ResourceDetectUtils$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.json = new Gson();
        this.cubingDetectItemFileSuffix = "cubing_detect_items.json";
        this.samplingDetectItemFileSuffix = "sampling_detect_items.json";
        this.countDistinctSuffix = "count_distinct.json";
    }
}

