/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.kyuubi.client.IRestClient;
import org.apache.kyuubi.client.KyuubiRestClient;
import org.apache.kyuubi.client.api.v1.dto.Engine;
import org.apache.kyuubi.client.api.v1.dto.OperationData;
import org.apache.kyuubi.client.api.v1.dto.ServerData;
import org.apache.kyuubi.client.api.v1.dto.SessionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AdminRestApi {
    private static final Logger LOG = LoggerFactory.getLogger(AdminRestApi.class);
    private KyuubiRestClient client;
    private static final String API_BASE_PATH = "admin";

    private AdminRestApi() {
    }

    public AdminRestApi(KyuubiRestClient client) {
        this.client = client;
    }

    public String refreshHadoopConf() {
        String path = String.format("%s/%s", API_BASE_PATH, "refresh/hadoop_conf");
        return this.getClient().post(path, null, this.client.getAuthHeader());
    }

    public String refreshUserDefaultsConf() {
        String path = String.format("%s/%s", API_BASE_PATH, "refresh/user_defaults_conf");
        return this.getClient().post(path, null, this.client.getAuthHeader());
    }

    public String refreshKubernetesConf() {
        String path = String.format("%s/%s", API_BASE_PATH, "refresh/kubernetes_conf");
        return this.getClient().post(path, null, this.client.getAuthHeader());
    }

    public String refreshUnlimitedUsers() {
        String path = String.format("%s/%s", API_BASE_PATH, "refresh/unlimited_users");
        return this.getClient().post(path, null, this.client.getAuthHeader());
    }

    public String refreshDenyUsers() {
        String path = String.format("%s/%s", API_BASE_PATH, "refresh/deny_users");
        return this.getClient().post(path, null, this.client.getAuthHeader());
    }

    public String refreshDenyIps() {
        String path = String.format("%s/%s", API_BASE_PATH, "refresh/deny_ips");
        return this.getClient().post(path, null, this.client.getAuthHeader());
    }

    @Deprecated
    public String deleteEngine(String engineType, String shareLevel, String subdomain, String hs2ProxyUser) {
        LOG.warn("The method `deleteEngine(engineType, shareLevel, subdomain, hs2ProxyUser)` is deprecated since 1.10.0, using `deleteEngine(engineType, shareLevel, subdomain, hs2ProxyUser, kill)` instead.");
        return this.deleteEngine(engineType, shareLevel, subdomain, hs2ProxyUser, false);
    }

    public String deleteEngine(String engineType, String shareLevel, String subdomain, String hs2ProxyUser, boolean kill) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", engineType);
        params.put("sharelevel", shareLevel);
        params.put("subdomain", subdomain);
        params.put("hive.server2.proxy.user", hs2ProxyUser);
        params.put("kill", kill);
        return this.getClient().delete("admin/engine", params, this.client.getAuthHeader());
    }

    public List<Engine> listEngines(String engineType, String shareLevel, String subdomain, String hs2ProxyUser) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("type", engineType);
        params.put("sharelevel", shareLevel);
        params.put("subdomain", subdomain);
        params.put("hive.server2.proxy.user", hs2ProxyUser);
        Engine[] result = this.getClient().get("admin/engine", params, Engine[].class, this.client.getAuthHeader());
        return Arrays.asList(result);
    }

    public List<SessionData> listSessions() {
        return this.listSessions(Collections.emptyList(), null);
    }

    public List<SessionData> listSessions(List<String> users, String sessionType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (users != null && !users.isEmpty()) {
            params.put("users", String.join((CharSequence)",", users));
        }
        if (StringUtils.isNotBlank((CharSequence)sessionType)) {
            params.put("sessionType", sessionType);
        }
        SessionData[] result = this.getClient().get("admin/sessions", params, SessionData[].class, this.client.getAuthHeader());
        return Arrays.asList(result);
    }

    public String closeSession(String sessionHandleStr) {
        String url = String.format("%s/sessions/%s", API_BASE_PATH, sessionHandleStr);
        return this.getClient().delete(url, null, this.client.getAuthHeader());
    }

    public List<OperationData> listOperations() {
        return this.listOperations(Collections.emptyList(), null, null);
    }

    public List<OperationData> listOperations(List<String> users, String sessionHandleStr, String sessionType) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (users != null && !users.isEmpty()) {
            params.put("users", String.join((CharSequence)",", users));
        }
        if (StringUtils.isNotBlank((CharSequence)sessionHandleStr)) {
            params.put("sessionHandle", sessionHandleStr);
        }
        if (StringUtils.isNotBlank((CharSequence)sessionType)) {
            params.put("sessionType", sessionType);
        }
        OperationData[] result = this.getClient().get("admin/operations", params, OperationData[].class, this.client.getAuthHeader());
        return Arrays.asList(result);
    }

    public String closeOperation(String operationHandleStr) {
        String url = String.format("%s/operations/%s", API_BASE_PATH, operationHandleStr);
        return this.getClient().delete(url, null, this.client.getAuthHeader());
    }

    public List<ServerData> listServers() {
        ServerData[] result = this.getClient().get("admin/server", null, ServerData[].class, this.client.getAuthHeader());
        return Arrays.asList(result);
    }

    private IRestClient getClient() {
        return this.client.getHttpClient();
    }
}

