<!--
- Licensed to the Apache Software Foundation (ASF) under one or more
- contributor license agreements.  See the NOTICE file distributed with
- this work for additional information regarding copyright ownership.
- The ASF licenses this file to You under the Apache License, Version 2.0
- (the "License"); you may not use this file except in compliance with
- the License.  You may obtain a copy of the License at
-
-   http://www.apache.org/licenses/LICENSE-2.0
-
- Unless required by applicable law or agreed to in writing, software
- distributed under the License is distributed on an "AS IS" BASIS,
- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
- See the License for the specific language governing permissions and
- limitations under the License.
-->

# The Share Level Of Kyuubi Engines

The share level of Kyuubi engines describes the relationship between sessions and engines.
It determines whether a new session can share an existing backend engine with other sessions or not.
The sessions are also known as JDBC/ODBC/Thrift connections from clients that end-users create, and the engines are standalone applications with the full capabilities of Spark SQL, Flink SQL(under dev), running on single-node machines or clusters.

The share level of Kyuubi engines works the same whether in HA or single node mode.
In other words, an engine is cluster widely shared by all Kyuubi server peers if could.

## Why do we need this feature?

Apache Spark is a unified engine for large-scale data analytics.
Using Spark to process data is like driving an all-wheel-drive hefty horsepower supercar.
However,

- Cars have their limit of 0-60 times.
  In a similar way, all Spark applications also have to warm up before go full speed.
- Cars have a constant number of seats and are not allowed to be overloaded.
  Due to the master-slave architecture of Spark and the resource configured ahead, the overall workload of a single application is predictable.
- Cars have various shapes to meet our needs.

With this feature, Kyuubi give you a more flexible way to handle different big data workloads.

## The current supported share levels

The current supported share levels are,

|  Share Level   |            Syntax            |           Scenario           |               Isolation Degree               |     Shareability      |
|----------------|------------------------------|------------------------------|----------------------------------------------|-----------------------|
| **CONNECTION** | One engine per session       | Large-scale ETL </br> Ad hoc | High                                         | Low                   |
| **USER**       | One engine per user          | Ad hoc </br> Small-scale ETL | Medium                                       | Medium                |
| **GROUP**      | One engine per primary group | Ad hoc </br> Small-scale ETL | Low                                          | High                  |
| **SERVER**     | One engine per cluster       | Admin                        | Highest If Secured </br> Lowest If Unsecured | Admin ONLY If Secured |

- Better isolation degree of engines gives us better stability of an engine and the query executions running on it.
- Better shareability of engines means we are more likely to reuse an engine which is already in full speed.

### CONNECTION

<body><div class="mxgraph" style="max-width:100%;border:1px solid transparent;" data-mxgraph="{&quot;nav&quot;:true,&quot;resize&quot;:true,&quot;toolbar&quot;:&quot;zoom layers tags lightbox&quot;,&quot;edit&quot;:&quot;_blank&quot;,&quot;xml&quot;:&quot;&lt;mxfile host=\&quot;Electron\&quot; modified=\&quot;2021-11-15T06:45:25.722Z\&quot; agent=\&quot;5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) draw.io/15.4.0 Chrome/91.0.4472.164 Electron/13.5.0 Safari/537.36\&quot; etag=\&quot;Ezilsd919XixL4tEBK0L\&quot; version=\&quot;15.4.0\&quot; type=\&quot;device\&quot;&gt;&lt;diagram id=\&quot;RaWIMvdSY7jaPepMtQGd\&quot; name=\&quot;第 1 页\&quot;&gt;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&lt;/diagram&gt;&lt;/mxfile&gt;&quot;}"></div>
<script type="text/javascript" src="https://viewer.diagrams.net/js/viewer-static.min.js"></script>
</body>
<div align=center>

*Figure.1 CONNECTION Share Level*

</div>

Each session with CONNECTION share level has a standalone engine for itself which is unreachable for anyone else.
Within the session, a user or client can send multiple operation request, including metadata calls or queries, to the corresponding engine.

Although it is still an interactive form, this model does allow for more practical batch processing jobs as well.

When closing session, the corresponding engine will be shutdown at the same time.

### USER(Default)

<body><div class="mxgraph" style="max-width:100%;border:1px solid transparent;" data-mxgraph="{&quot;nav&quot;:true,&quot;resize&quot;:true,&quot;toolbar&quot;:&quot;zoom layers tags lightbox&quot;,&quot;edit&quot;:&quot;_blank&quot;,&quot;xml&quot;:&quot;&lt;mxfile host=\&quot;Electron\&quot; modified=\&quot;2021-11-15T06:49:50.020Z\&quot; agent=\&quot;5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) draw.io/15.4.0 Chrome/91.0.4472.164 Electron/13.5.0 Safari/537.36\&quot; etag=\&quot;VF19OpQAZ9kOgUIGNFVS\&quot; version=\&quot;15.4.0\&quot; type=\&quot;device\&quot;&gt;&lt;diagram id=\&quot;RaWIMvdSY7jaPepMtQGd\&quot; name=\&quot;第 1 页\&quot;&gt;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&lt;/diagram&gt;&lt;/mxfile&gt;&quot;}"></div>
<script type="text/javascript" src="https://viewer.diagrams.net/js/viewer-static.min.js"></script>
</body>
<div align=center>

*Figure.2 USER Share Level*

</div>

All sessions with USER share level use the same engine if and only if the session user is the same.

Those sessions share the same engine with objects belong to the one and only `SparkContext` instance, including `Classes/Classloaders`, `SparkConf`, `Driver`/`Executor`s, `Hive Metastore Client`, etc.
But each session can still have its own `SparkSession` instance, which contains separate session state, including temporary views, SQL config, UDFs etc.
Setting `kyuubi.engine.single.spark.session` to true will make `SparkSession` instance a singleton and share across sessions.

When closing session, the corresponding engine will not be shutdown.
When all sessions are closed, the corresponding engine still has a time-to-live lifespan.
This TTL allows new sessions to be established quickly without waiting for the engine to start.

### GROUP

<body><div class="mxgraph" style="max-width:100%;border:1px solid transparent;" data-mxgraph="{&quot;nav&quot;:true,&quot;resize&quot;:true,&quot;toolbar&quot;:&quot;zoom layers tags lightbox&quot;,&quot;edit&quot;:&quot;_blank&quot;,&quot;xml&quot;:&quot;&lt;mxfile host=\&quot;Electron\&quot; modified=\&quot;2021-11-15T06:39:03.927Z\&quot; agent=\&quot;5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) draw.io/15.4.0 Chrome/91.0.4472.164 Electron/13.5.0 Safari/537.36\&quot; etag=\&quot;2zkT4mpS6xGWcv7C_dim\&quot; version=\&quot;15.4.0\&quot; type=\&quot;device\&quot;&gt;&lt;diagram id=\&quot;RaWIMvdSY7jaPepMtQGd\&quot; name=\&quot;第 1 页\&quot;&gt;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&lt;/diagram&gt;&lt;/mxfile&gt;&quot;}"></div>
<script type="text/javascript" src="https://viewer.diagrams.net/js/viewer-static.min.js"></script>
</body>
<div align=center>

*Figure.3 GROUP Share Level*

</div>

An engine will be shared by all sessions created by all users belong to the same primary group name.
The engine will be launched by the group name as the effective username, so here the group name is kind of special user who is able to visit the compute resources/data of a team.
It follows the [Hadoop GroupsMapping](https://hadoop.apache.org/docs/current/hadoop-project-dist/hadoop-common/GroupsMapping.html) to map user to a primary group. If the primary group is not found, it falls back to the USER level.

The mechanisms of `SparkContext`, `SparkSession` and TTL works similarly to USER share level.

Here is an example to configure `HadoopGroupProvider` to use LDAP-based group mapping.
1. Add the properties shown in the example below to the `core-site.xml` file. You will need to provide the value for the bind user, the bind password, and other properties specific to your LDAP instance, and make sure that object class, user, and group filters match the values specified in your LDAP instance.

```xml
<property>
  <name>hadoop.security.group.mapping</name>
  <value>org.apache.hadoop.security.LdapGroupsMapping</value>
</property>

<property>
  <name>hadoop.security.group.mapping.ldap.url</name>
  <value>ldap://localhost:389</value>
</property>

<property>
  <name>hadoop.security.group.mapping.ldap.base</name>
  <value>dc=example,dc=com</value>
</property>

<property>
  <name>hadoop.security.group.mapping.ldap.bind.user</name>
  <value>cn=Manager,dc=example,dc=com</value>
</property>

<property>
  <name>hadoop.security.group.mapping.ldap.bind.password</name>
  <value>example</value>
</property>

<property>
  <name>hadoop.security.group.mapping.ldap.search.filter.user</name>
  <value>(&(objectClass=posixAccount)(cn={0}))</value>
</property>

<property>
  <name>hadoop.security.group.mapping.ldap.search.filter.group</name>
  <value>(objectClass=posixGroup)</value>
</property>

<property>
  <name>hadoop.security.group.mapping.ldap.search.attr.member</name>
  <value>memberuid</value>
</property>

<property>
  <name>hadoop.security.group.mapping.ldap.search.attr.group.name</name>
  <value>cn</value>
</property>
```

2. Use the applicable instructions to re-start the HDFS NameNode and the YARN ResourceManager.
3. Verify LDAP group mapping by running the `hdfs groups` command. This command will fetch groups from LDAP for the current user. Note that with LDAP group mapping configured, the HDFS permissions can leverage groups defined in LDAP for access control.

**Tips for authorization in GROUP share level**:

The session user and the primary group name(as sparkUser/execute user) will be both accessible at engine-side.
By default, the sparkUser will be used to check the YARN/HDFS ACLs.
If you want fine-grained access control for session user, you need to get it from `SparkContext.getLocalProperty("kyuubi.session.user")` and send it to security service, like Apache Ranger.

### SERVER

<body><div class="mxgraph" style="max-width:100%;border:1px solid transparent;" data-mxgraph="{&quot;nav&quot;:true,&quot;resize&quot;:true,&quot;toolbar&quot;:&quot;zoom layers tags lightbox&quot;,&quot;edit&quot;:&quot;_blank&quot;,&quot;xml&quot;:&quot;&lt;mxfile host=\&quot;Electron\&quot; modified=\&quot;2021-11-15T07:07:11.985Z\&quot; agent=\&quot;5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) draw.io/15.4.0 Chrome/91.0.4472.164 Electron/13.5.0 Safari/537.36\&quot; etag=\&quot;Rz8IyKHxPEwylu8o5bz_\&quot; version=\&quot;15.4.0\&quot; type=\&quot;device\&quot;&gt;&lt;diagram id=\&quot;RaWIMvdSY7jaPepMtQGd\&quot; name=\&quot;第 1 页\&quot;&gt;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&lt;/diagram&gt;&lt;/mxfile&gt;&quot;}"></div>
<script type="text/javascript" src="https://viewer.diagrams.net/js/viewer-static.min.js"></script>
</body>
<div align=center>

*Figure.4 SERVER Share Level*

</div>

Literally, this model is similar to Spark Thrift Server with High availability.

### Subdomain

For USER, GROUP, or SERVER share levels, you can further use `kyuubi.engine.share.level.subdomain` to isolate the engine.
That is, you can also create multiple engines for a single user, group or server(cluster).
For example, in USER share level, you can use `kyuubi.engine.share.level.subdomain=sd1` and `kyuubi.engine.share.level.subdomain=sd2` to create two standalone engines for user `Tom`.

The `kyuubi.engine.share.level.subdomain` shall be configured in the JDBC connection URL to tell the Kyuubi server which engine you want to use.

### Hybrid

All supported share levels can be used together in a single Kyuubi server or cluster.

## Related Configurations

- kyuubi.engine.share.level(kyuubi.session.engine.share.level)
  - Default: USER
  - Candidates: USER, CONNECTION, GROUP, SERVER
  - Meaning: The base level for how an engine is created, cached and shared to sessions.
  - Usage: It can be set both in the server configuration file and also connection URL. The latter has higher priority.
- kyuubi.session.engine.idle.timeout
  - Default: PT30M (30 min)
  - Candidates: a proper timeout
  - Meaning: Time to live since engine becomes idle
  - Usage: It can be set both in the server configuration file and also connection URL. The latter has higher priority.
- kyuubi.engine.share.level.subdomain(kyuubi.engine.share.level.sub.domain)
  - Default: <none>
  - Candidates: a valid zookeeper a child node
  - Meaning: Add a subdomain under the base level to make further isolation for engines
  - Usage: It can be set both in the server configuration file and also connection URL. The latter has higher priority.

## Conclusion

With this feature, end-users are able to leverage engines in different ways to handle their different workloads, such as large-scale ETL jobs and interactive ad hoc queries.
