/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.ha;

import java.time.Duration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kyuubi.config.ConfigBuilder;
import org.apache.kyuubi.config.ConfigEntry;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.config.OptionalConfigEntry;
import org.apache.kyuubi.ha.client.RetryPolicies$;
import org.apache.kyuubi.ha.client.ZooKeeperAuthTypes$;
import scala.Function1;
import scala.Option;
import scala.Serializable;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet$;
import scala.math.Ordering;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class HighAvailabilityConf$ {
    public static HighAvailabilityConf$ MODULE$;
    private final ConfigEntry<String> HA_ZK_QUORUM;
    private final ConfigEntry<String> HA_ZK_NAMESPACE;
    private final ConfigEntry<Object> HA_ZK_ACL_ENABLED;
    private final ConfigEntry<String> HA_ZK_AUTH_TYPE;
    private final ConfigEntry<String> HA_ZK_ENGINE_AUTH_TYPE;
    private final ConfigEntry<Option<String>> HA_ZK_AUTH_PRINCIPAL;
    private final ConfigEntry<Option<String>> HA_ZK_AUTH_KEYTAB;
    private final OptionalConfigEntry<String> HA_ZK_AUTH_DIGEST;
    private final ConfigEntry<Object> HA_ZK_CONN_MAX_RETRIES;
    private final ConfigEntry<Object> HA_ZK_CONN_BASE_RETRY_WAIT;
    private final ConfigEntry<Object> HA_ZK_CONN_MAX_RETRY_WAIT;
    private final ConfigEntry<Object> HA_ZK_CONN_TIMEOUT;
    private final ConfigEntry<Object> HA_ZK_SESSION_TIMEOUT;
    private final ConfigEntry<String> HA_ZK_CONN_RETRY_POLICY;
    private final ConfigEntry<Object> HA_ZK_NODE_TIMEOUT;
    private final OptionalConfigEntry<String> HA_ZK_ENGINE_REF_ID;
    private final ConfigEntry<Object> HA_ZK_PUBLISH_CONFIGS;

    static {
        new HighAvailabilityConf$();
    }

    private ConfigBuilder buildConf(String key) {
        return KyuubiConf$.MODULE$.buildConf(key);
    }

    public ConfigEntry<String> HA_ZK_QUORUM() {
        return this.HA_ZK_QUORUM;
    }

    public ConfigEntry<String> HA_ZK_NAMESPACE() {
        return this.HA_ZK_NAMESPACE;
    }

    public ConfigEntry<Object> HA_ZK_ACL_ENABLED() {
        return this.HA_ZK_ACL_ENABLED;
    }

    public ConfigEntry<String> HA_ZK_AUTH_TYPE() {
        return this.HA_ZK_AUTH_TYPE;
    }

    public ConfigEntry<String> HA_ZK_ENGINE_AUTH_TYPE() {
        return this.HA_ZK_ENGINE_AUTH_TYPE;
    }

    public ConfigEntry<Option<String>> HA_ZK_AUTH_PRINCIPAL() {
        return this.HA_ZK_AUTH_PRINCIPAL;
    }

    public ConfigEntry<Option<String>> HA_ZK_AUTH_KEYTAB() {
        return this.HA_ZK_AUTH_KEYTAB;
    }

    public OptionalConfigEntry<String> HA_ZK_AUTH_DIGEST() {
        return this.HA_ZK_AUTH_DIGEST;
    }

    public ConfigEntry<Object> HA_ZK_CONN_MAX_RETRIES() {
        return this.HA_ZK_CONN_MAX_RETRIES;
    }

    public ConfigEntry<Object> HA_ZK_CONN_BASE_RETRY_WAIT() {
        return this.HA_ZK_CONN_BASE_RETRY_WAIT;
    }

    public ConfigEntry<Object> HA_ZK_CONN_MAX_RETRY_WAIT() {
        return this.HA_ZK_CONN_MAX_RETRY_WAIT;
    }

    public ConfigEntry<Object> HA_ZK_CONN_TIMEOUT() {
        return this.HA_ZK_CONN_TIMEOUT;
    }

    public ConfigEntry<Object> HA_ZK_SESSION_TIMEOUT() {
        return this.HA_ZK_SESSION_TIMEOUT;
    }

    public ConfigEntry<String> HA_ZK_CONN_RETRY_POLICY() {
        return this.HA_ZK_CONN_RETRY_POLICY;
    }

    public ConfigEntry<Object> HA_ZK_NODE_TIMEOUT() {
        return this.HA_ZK_NODE_TIMEOUT;
    }

    public OptionalConfigEntry<String> HA_ZK_ENGINE_REF_ID() {
        return this.HA_ZK_ENGINE_REF_ID;
    }

    public ConfigEntry<Object> HA_ZK_PUBLISH_CONFIGS() {
        return this.HA_ZK_PUBLISH_CONFIGS;
    }

    private HighAvailabilityConf$() {
        MODULE$ = this;
        this.HA_ZK_QUORUM = this.buildConf("ha.zookeeper.quorum").doc("The connection string for the zookeeper ensemble").version("1.0.0").stringConf().createWithDefault("");
        this.HA_ZK_NAMESPACE = this.buildConf("ha.zookeeper.namespace").doc("The root directory for the service to deploy its instance uri. Additionally, it will creates a -[username] suffixed root directory for each application").version("1.0.0").stringConf().createWithDefault("kyuubi");
        this.HA_ZK_ACL_ENABLED = this.buildConf("ha.zookeeper.acl.enabled").doc("Set to true if the zookeeper ensemble is kerberized").version("1.0.0").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)UserGroupInformation.isSecurityEnabled()));
        this.HA_ZK_AUTH_TYPE = this.buildConf("ha.zookeeper.auth.type").doc(new StringBuilder(57).append("The type of zookeeper authentication, all candidates are ").append(ZooKeeperAuthTypes$.MODULE$.values().mkString("<ul><li>", "</li><li> ", "</li></ul>")).toString()).version("1.3.2").stringConf().checkValues((Set<String>)((Set)ZooKeeperAuthTypes$.MODULE$.values().map((Function1 & java.io.Serializable & Serializable)x$1 -> x$1.toString(), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$)))).createWithDefault(ZooKeeperAuthTypes$.MODULE$.NONE().toString());
        this.HA_ZK_ENGINE_AUTH_TYPE = this.buildConf("ha.zookeeper.engine.auth.type").doc(new StringBuilder(68).append("The type of zookeeper authentication for engine, all candidates are ").append(ZooKeeperAuthTypes$.MODULE$.values().mkString("<ul><li>", "</li><li> ", "</li></ul>")).toString()).version("1.3.2").fallbackConf(this.HA_ZK_AUTH_TYPE());
        this.HA_ZK_AUTH_PRINCIPAL = this.buildConf("ha.zookeeper.auth.principal").doc("Name of the Kerberos principal is used for zookeeper authentication.").version("1.3.2").fallbackConf(KyuubiConf$.MODULE$.SERVER_PRINCIPAL());
        this.HA_ZK_AUTH_KEYTAB = this.buildConf("ha.zookeeper.auth.keytab").doc("Location of Kyuubi server's keytab is used for zookeeper authentication.").version("1.3.2").fallbackConf(KyuubiConf$.MODULE$.SERVER_KEYTAB());
        this.HA_ZK_AUTH_DIGEST = this.buildConf("ha.zookeeper.auth.digest").doc("The digest auth string is used for zookeeper authentication, like: username:password.").version("1.3.2").stringConf().createOptional();
        this.HA_ZK_CONN_MAX_RETRIES = this.buildConf("ha.zookeeper.connection.max.retries").doc("Max retry times for connecting to the zookeeper ensemble").version("1.0.0").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)3));
        this.HA_ZK_CONN_BASE_RETRY_WAIT = this.buildConf("ha.zookeeper.connection.base.retry.wait").doc("Initial amount of time to wait between retries to the zookeeper ensemble").version("1.0.0").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)1000));
        this.HA_ZK_CONN_MAX_RETRY_WAIT = this.buildConf("ha.zookeeper.connection.max.retry.wait").doc(new StringBuilder(137).append("Max amount of time to wait between retries for").append(" ").append(RetryPolicies$.MODULE$.BOUNDED_EXPONENTIAL_BACKOFF()).append(" policy can reach, or max time until").append(" elapsed for ").append(RetryPolicies$.MODULE$.UNTIL_ELAPSED()).append(" policy to connect the zookeeper ensemble").toString()).version("1.0.0").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)30000));
        this.HA_ZK_CONN_TIMEOUT = this.buildConf("ha.zookeeper.connection.timeout").doc("The timeout(ms) of creating the connection to the zookeeper ensemble").version("1.0.0").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)15000));
        this.HA_ZK_SESSION_TIMEOUT = this.buildConf("ha.zookeeper.session.timeout").doc("The timeout(ms) of a connected session to be idled").version("1.0.0").intConf().createWithDefault(BoxesRunTime.boxToInteger((int)60000));
        this.HA_ZK_CONN_RETRY_POLICY = this.buildConf("ha.zookeeper.connection.retry.policy").doc(new StringBuilder(79).append("The retry policy for connecting to the zookeeper ensemble, all candidates are:").append(" ").append(RetryPolicies$.MODULE$.values().mkString("<ul><li>", "</li><li> ", "</li></ul>")).toString()).version("1.0.0").stringConf().checkValues((Set<String>)((Set)RetryPolicies$.MODULE$.values().map((Function1 & java.io.Serializable & Serializable)x$2 -> x$2.toString(), SortedSet$.MODULE$.newCanBuildFrom((Ordering)Ordering.String$.MODULE$)))).createWithDefault(RetryPolicies$.MODULE$.EXPONENTIAL_BACKOFF().toString());
        this.HA_ZK_NODE_TIMEOUT = this.buildConf("ha.zookeeper.node.creation.timeout").doc("Timeout for creating zookeeper node").version("1.2.0").timeConf().checkValue((Function1<Object, Object>)(JFunction1.mcZJ.sp & java.io.Serializable & Serializable)x$3 -> x$3 > 0L, "Must be positive").createWithDefault(BoxesRunTime.boxToLong((long)Duration.ofSeconds(120L).toMillis()));
        this.HA_ZK_ENGINE_REF_ID = this.buildConf("ha.engine.ref.id").doc("The engine reference id will be attached to zookeeper node when engine started, and the kyuubi server will check it cyclically.").internal().version("1.3.2").stringConf().createOptional();
        this.HA_ZK_PUBLISH_CONFIGS = this.buildConf("ha.zookeeper.publish.configs").doc("When set to true, publish Kerberos configs to Zookeeper.Note that the Hive driver needs to be greater than 1.3 or 2.0 or apply HIVE-11581 patch.").version("1.4.0").booleanConf().createWithDefault(BoxesRunTime.boxToBoolean((boolean)false));
    }
}

