/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.com.google.common.cache;

import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.kyuubi.shade.com.google.common.annotations.Beta;
import org.apache.kyuubi.shade.com.google.common.annotations.VisibleForTesting;
import org.apache.kyuubi.shade.com.google.common.base.Objects;
import org.apache.kyuubi.shade.com.google.common.base.Preconditions;
import org.apache.kyuubi.shade.com.google.common.base.Splitter;
import org.apache.kyuubi.shade.com.google.common.cache.CacheBuilder;
import org.apache.kyuubi.shade.com.google.common.cache.LocalCache;
import org.apache.kyuubi.shade.com.google.common.collect.ImmutableList;
import org.apache.kyuubi.shade.com.google.common.collect.ImmutableMap;

@Beta
public final class CacheBuilderSpec {
    private static final Splitter KEYS_SPLITTER = Splitter.on(',').trimResults();
    private static final Splitter KEY_VALUE_SPLITTER = Splitter.on('=').trimResults();
    private static final ImmutableMap<String, ValueParser> VALUE_PARSERS = ImmutableMap.builder().put("initialCapacity", new InitialCapacityParser()).put("maximumSize", (InitialCapacityParser)((Object)new MaximumSizeParser())).put("maximumWeight", (InitialCapacityParser)((Object)new MaximumWeightParser())).put("concurrencyLevel", (InitialCapacityParser)((Object)new ConcurrencyLevelParser())).put("weakKeys", (InitialCapacityParser)((Object)new KeyStrengthParser(LocalCache.Strength.WEAK))).put("softValues", (InitialCapacityParser)((Object)new ValueStrengthParser(LocalCache.Strength.SOFT))).put("weakValues", (InitialCapacityParser)((Object)new ValueStrengthParser(LocalCache.Strength.WEAK))).put("expireAfterAccess", (InitialCapacityParser)((Object)new AccessDurationParser())).put("expireAfterWrite", (InitialCapacityParser)((Object)new WriteDurationParser())).put("refreshAfterWrite", (InitialCapacityParser)((Object)new RefreshDurationParser())).put("refreshInterval", (InitialCapacityParser)((Object)new RefreshDurationParser())).build();
    @VisibleForTesting
    Integer initialCapacity;
    @VisibleForTesting
    Long maximumSize;
    @VisibleForTesting
    Long maximumWeight;
    @VisibleForTesting
    Integer concurrencyLevel;
    @VisibleForTesting
    LocalCache.Strength keyStrength;
    @VisibleForTesting
    LocalCache.Strength valueStrength;
    @VisibleForTesting
    long writeExpirationDuration;
    @VisibleForTesting
    TimeUnit writeExpirationTimeUnit;
    @VisibleForTesting
    long accessExpirationDuration;
    @VisibleForTesting
    TimeUnit accessExpirationTimeUnit;
    @VisibleForTesting
    long refreshDuration;
    @VisibleForTesting
    TimeUnit refreshTimeUnit;
    private final String specification;

    private CacheBuilderSpec(String specification) {
        this.specification = specification;
    }

    public static CacheBuilderSpec parse(String cacheBuilderSpecification) {
        CacheBuilderSpec spec = new CacheBuilderSpec(cacheBuilderSpecification);
        if (!cacheBuilderSpecification.isEmpty()) {
            for (String keyValuePair : KEYS_SPLITTER.split(cacheBuilderSpecification)) {
                ImmutableList<String> keyAndValue = ImmutableList.copyOf(KEY_VALUE_SPLITTER.split(keyValuePair));
                Preconditions.checkArgument(!keyAndValue.isEmpty(), "blank key-value pair");
                Preconditions.checkArgument(keyAndValue.size() <= 2, "key-value pair %s with more than one equals sign", keyValuePair);
                String key = (String)keyAndValue.get(0);
                ValueParser valueParser = VALUE_PARSERS.get(key);
                Preconditions.checkArgument(valueParser != null, "unknown key %s", key);
                String value = keyAndValue.size() == 1 ? null : (String)keyAndValue.get(1);
                valueParser.parse(spec, key, value);
            }
        }
        return spec;
    }

    public static CacheBuilderSpec disableCaching() {
        return CacheBuilderSpec.parse("maximumSize=0");
    }

    CacheBuilder<Object, Object> toCacheBuilder() {
        CacheBuilder<Object, Object> builder = CacheBuilder.newBuilder();
        if (this.initialCapacity != null) {
            builder.initialCapacity(this.initialCapacity);
        }
        if (this.maximumSize != null) {
            builder.maximumSize(this.maximumSize);
        }
        if (this.maximumWeight != null) {
            builder.maximumWeight(this.maximumWeight);
        }
        if (this.concurrencyLevel != null) {
            builder.concurrencyLevel(this.concurrencyLevel);
        }
        if (this.keyStrength != null) {
            switch (this.keyStrength) {
                case WEAK: {
                    builder.weakKeys();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (this.valueStrength != null) {
            switch (this.valueStrength) {
                case SOFT: {
                    builder.softValues();
                    break;
                }
                case WEAK: {
                    builder.weakValues();
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        if (this.writeExpirationTimeUnit != null) {
            builder.expireAfterWrite(this.writeExpirationDuration, this.writeExpirationTimeUnit);
        }
        if (this.accessExpirationTimeUnit != null) {
            builder.expireAfterAccess(this.accessExpirationDuration, this.accessExpirationTimeUnit);
        }
        if (this.refreshTimeUnit != null) {
            builder.refreshAfterWrite(this.refreshDuration, this.refreshTimeUnit);
        }
        return builder;
    }

    public String toParsableString() {
        return this.specification;
    }

    public String toString() {
        return Objects.toStringHelper(this).addValue(this.toParsableString()).toString();
    }

    public int hashCode() {
        return Objects.hashCode(new Object[]{this.initialCapacity, this.maximumSize, this.maximumWeight, this.concurrencyLevel, this.keyStrength, this.valueStrength, CacheBuilderSpec.durationInNanos(this.writeExpirationDuration, this.writeExpirationTimeUnit), CacheBuilderSpec.durationInNanos(this.accessExpirationDuration, this.accessExpirationTimeUnit), CacheBuilderSpec.durationInNanos(this.refreshDuration, this.refreshTimeUnit)});
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CacheBuilderSpec)) {
            return false;
        }
        CacheBuilderSpec that = (CacheBuilderSpec)obj;
        return Objects.equal(this.initialCapacity, that.initialCapacity) && Objects.equal(this.maximumSize, that.maximumSize) && Objects.equal(this.maximumWeight, that.maximumWeight) && Objects.equal(this.concurrencyLevel, that.concurrencyLevel) && Objects.equal((Object)this.keyStrength, (Object)that.keyStrength) && Objects.equal((Object)this.valueStrength, (Object)that.valueStrength) && Objects.equal(CacheBuilderSpec.durationInNanos(this.writeExpirationDuration, this.writeExpirationTimeUnit), CacheBuilderSpec.durationInNanos(that.writeExpirationDuration, that.writeExpirationTimeUnit)) && Objects.equal(CacheBuilderSpec.durationInNanos(this.accessExpirationDuration, this.accessExpirationTimeUnit), CacheBuilderSpec.durationInNanos(that.accessExpirationDuration, that.accessExpirationTimeUnit)) && Objects.equal(CacheBuilderSpec.durationInNanos(this.refreshDuration, this.refreshTimeUnit), CacheBuilderSpec.durationInNanos(that.refreshDuration, that.refreshTimeUnit));
    }

    @Nullable
    private static Long durationInNanos(long duration, @Nullable TimeUnit unit) {
        return unit == null ? null : Long.valueOf(unit.toNanos(duration));
    }

    static class RefreshDurationParser
    extends DurationParser {
        RefreshDurationParser() {
        }

        @Override
        protected void parseDuration(CacheBuilderSpec spec, long duration, TimeUnit unit) {
            Preconditions.checkArgument(spec.refreshTimeUnit == null, "refreshAfterWrite already set");
            spec.refreshDuration = duration;
            spec.refreshTimeUnit = unit;
        }
    }

    static class WriteDurationParser
    extends DurationParser {
        WriteDurationParser() {
        }

        @Override
        protected void parseDuration(CacheBuilderSpec spec, long duration, TimeUnit unit) {
            Preconditions.checkArgument(spec.writeExpirationTimeUnit == null, "expireAfterWrite already set");
            spec.writeExpirationDuration = duration;
            spec.writeExpirationTimeUnit = unit;
        }
    }

    static class AccessDurationParser
    extends DurationParser {
        AccessDurationParser() {
        }

        @Override
        protected void parseDuration(CacheBuilderSpec spec, long duration, TimeUnit unit) {
            Preconditions.checkArgument(spec.accessExpirationTimeUnit == null, "expireAfterAccess already set");
            spec.accessExpirationDuration = duration;
            spec.accessExpirationTimeUnit = unit;
        }
    }

    static abstract class DurationParser
    implements ValueParser {
        DurationParser() {
        }

        protected abstract void parseDuration(CacheBuilderSpec var1, long var2, TimeUnit var4);

        @Override
        public void parse(CacheBuilderSpec spec, String key, String value) {
            Preconditions.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            try {
                TimeUnit timeUnit;
                char lastChar = value.charAt(value.length() - 1);
                switch (lastChar) {
                    case 'd': {
                        timeUnit = TimeUnit.DAYS;
                        break;
                    }
                    case 'h': {
                        timeUnit = TimeUnit.HOURS;
                        break;
                    }
                    case 'm': {
                        timeUnit = TimeUnit.MINUTES;
                        break;
                    }
                    case 's': {
                        timeUnit = TimeUnit.SECONDS;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format("key %s invalid format.  was %s, must end with one of [dDhHmMsS]", key, value));
                    }
                }
                long duration = Long.parseLong(value.substring(0, value.length() - 1));
                this.parseDuration(spec, duration, timeUnit);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be integer", key, value));
            }
        }
    }

    static class ValueStrengthParser
    implements ValueParser {
        private final LocalCache.Strength strength;

        public ValueStrengthParser(LocalCache.Strength strength) {
            this.strength = strength;
        }

        @Override
        public void parse(CacheBuilderSpec spec, String key, @Nullable String value) {
            Preconditions.checkArgument(value == null, "key %s does not take values", key);
            Preconditions.checkArgument(spec.valueStrength == null, "%s was already set to %s", new Object[]{key, spec.valueStrength});
            spec.valueStrength = this.strength;
        }
    }

    static class KeyStrengthParser
    implements ValueParser {
        private final LocalCache.Strength strength;

        public KeyStrengthParser(LocalCache.Strength strength) {
            this.strength = strength;
        }

        @Override
        public void parse(CacheBuilderSpec spec, String key, @Nullable String value) {
            Preconditions.checkArgument(value == null, "key %s does not take values", key);
            Preconditions.checkArgument(spec.keyStrength == null, "%s was already set to %s", new Object[]{key, spec.keyStrength});
            spec.keyStrength = this.strength;
        }
    }

    static class ConcurrencyLevelParser
    extends IntegerParser {
        ConcurrencyLevelParser() {
        }

        @Override
        protected void parseInteger(CacheBuilderSpec spec, int value) {
            Preconditions.checkArgument(spec.concurrencyLevel == null, "concurrency level was already set to ", spec.concurrencyLevel);
            spec.concurrencyLevel = value;
        }
    }

    static class MaximumWeightParser
    extends LongParser {
        MaximumWeightParser() {
        }

        @Override
        protected void parseLong(CacheBuilderSpec spec, long value) {
            Preconditions.checkArgument(spec.maximumWeight == null, "maximum weight was already set to ", spec.maximumWeight);
            Preconditions.checkArgument(spec.maximumSize == null, "maximum size was already set to ", spec.maximumSize);
            spec.maximumWeight = value;
        }
    }

    static class MaximumSizeParser
    extends LongParser {
        MaximumSizeParser() {
        }

        @Override
        protected void parseLong(CacheBuilderSpec spec, long value) {
            Preconditions.checkArgument(spec.maximumSize == null, "maximum size was already set to ", spec.maximumSize);
            Preconditions.checkArgument(spec.maximumWeight == null, "maximum weight was already set to ", spec.maximumWeight);
            spec.maximumSize = value;
        }
    }

    static class InitialCapacityParser
    extends IntegerParser {
        InitialCapacityParser() {
        }

        @Override
        protected void parseInteger(CacheBuilderSpec spec, int value) {
            Preconditions.checkArgument(spec.initialCapacity == null, "initial capacity was already set to ", spec.initialCapacity);
            spec.initialCapacity = value;
        }
    }

    static abstract class LongParser
    implements ValueParser {
        LongParser() {
        }

        protected abstract void parseLong(CacheBuilderSpec var1, long var2);

        @Override
        public void parse(CacheBuilderSpec spec, String key, String value) {
            Preconditions.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            try {
                this.parseLong(spec, Long.parseLong(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be integer", key, value), e);
            }
        }
    }

    static abstract class IntegerParser
    implements ValueParser {
        IntegerParser() {
        }

        protected abstract void parseInteger(CacheBuilderSpec var1, int var2);

        @Override
        public void parse(CacheBuilderSpec spec, String key, String value) {
            Preconditions.checkArgument(value != null && !value.isEmpty(), "value of key %s omitted", key);
            try {
                this.parseInteger(spec, Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("key %s value set to %s, must be integer", key, value), e);
            }
        }
    }

    private static interface ValueParser {
        public void parse(CacheBuilderSpec var1, String var2, @Nullable String var3);
    }
}

