/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.hive.service.auth.ldap;

import java.util.Collection;
import javax.naming.NamingException;
import javax.security.sasl.AuthenticationException;
import org.apache.kyuubi.shade.org.apache.hadoop.hive.conf.HiveConf;
import org.apache.kyuubi.shade.org.apache.hive.service.auth.ldap.DirSearch;
import org.apache.kyuubi.shade.org.apache.hive.service.auth.ldap.Filter;
import org.apache.kyuubi.shade.org.apache.hive.service.auth.ldap.FilterFactory;

public final class UserSearchFilterFactory
implements FilterFactory {
    @Override
    public Filter getInstance(HiveConf conf) {
        Collection groupFilter = conf.getStringCollection(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_GROUPFILTER.varname);
        Collection userFilter = conf.getStringCollection(HiveConf.ConfVars.HIVE_SERVER2_PLAIN_LDAP_USERFILTER.varname);
        if (groupFilter.isEmpty() && userFilter.isEmpty()) {
            return null;
        }
        return new UserSearchFilter();
    }

    private static final class UserSearchFilter
    implements Filter {
        private UserSearchFilter() {
        }

        @Override
        public void apply(DirSearch client, String user) throws AuthenticationException {
            try {
                String userDn = client.findUserDn(user);
                if (userDn == null) {
                    throw new AuthenticationException("Authentication failed: User search failed");
                }
            }
            catch (NamingException e) {
                throw new AuthenticationException("LDAP Authentication failed for user", e);
            }
        }
    }
}

