/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine;

import com.codahale.metrics.MetricRegistry;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.locks.InterProcessSemaphoreMutex;
import org.apache.curator.utils.ZKPaths;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Logging;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.EngineRef$;
import org.apache.kyuubi.engine.EngineType$;
import org.apache.kyuubi.engine.ShareLevel$;
import org.apache.kyuubi.engine.spark.SparkProcessBuilder;
import org.apache.kyuubi.ha.HighAvailabilityConf$;
import org.apache.kyuubi.ha.client.ServiceDiscovery$;
import org.apache.kyuubi.metrics.MetricsConstants$;
import org.apache.kyuubi.metrics.MetricsSystem;
import org.apache.kyuubi.metrics.MetricsSystem$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005]f!\u0002\u0011\"\u0001\rJ\u0003\u0002\u0003\u001b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001c\t\u0011q\u0002!\u0011!Q\u0001\nuB\u0001\u0002\u0013\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\u0006\u0013\u0002!\tA\u0013\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0011\u0019\u0011\u0006\u0001)A\u0005{!91\u000b\u0001b\u0001\n\u0013!\u0006B\u0002-\u0001A\u0003%Q\u000bC\u0004Z\u0001\t\u0007I\u0011\u0002.\t\r)\u0004\u0001\u0015!\u0003\\\u0011\u001dY\u0007A1A\u0005\n1Da\u0001\u001e\u0001!\u0002\u0013i\u0007bB;\u0001\u0005\u0004%IA\u001e\u0005\u0007u\u0002\u0001\u000b\u0011B<\t\u000fm\u0004!\u0019!C\u0005m\"1A\u0010\u0001Q\u0001\n]D\u0001\" \u0001C\u0002\u0013\u00051%\u0015\u0005\u0007}\u0002\u0001\u000b\u0011B\u001f\t\u0013\u0005e\u0001A1A\u0005\u0002\r\n\u0006bBA\u000e\u0001\u0001\u0006I!\u0010\u0005\n\u0003;\u0001!\u0019!C\u0001GECq!a\b\u0001A\u0003%Q\b\u0003\u0006\u0002$\u0001A)\u0019!C\u0001GECq!a\n\u0001\t\u0013\tI\u0003C\u0004\u0002d\u0001!I!!\u001a\t\u000f\u0005%\u0005\u0001\"\u0001\u0002\f\"I\u0011\u0011\u0013\u0001\u0012\u0002\u0013\u0005\u00111S\u0004\u000b\u0003S\u000b\u0013\u0011!E\u0001G\u0005-f!\u0003\u0011\"\u0003\u0003E\taIAW\u0011\u0019IU\u0004\"\u0001\u00020\"I\u0011\u0011W\u000f\u0012\u0002\u0013\u0005\u00111\u0017\u0002\n\u000b:<\u0017N\\3SK\u001aT!AI\u0012\u0002\r\u0015tw-\u001b8f\u0015\t!S%\u0001\u0004lsV,(-\u001b\u0006\u0003M\u001d\na!\u00199bG\",'\"\u0001\u0015\u0002\u0007=\u0014xmE\u0002\u0001UA\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012a!\u00118z%\u00164\u0007CA\u00193\u001b\u0005\u0019\u0013BA\u001a$\u0005\u001daunZ4j]\u001e\fAaY8oM\u000e\u0001\u0001CA\u001c;\u001b\u0005A$BA\u001d$\u0003\u0019\u0019wN\u001c4jO&\u00111\b\u000f\u0002\u000b\u0017f,XOY5D_:4\u0017\u0001B;tKJ\u0004\"AP#\u000f\u0005}\u001a\u0005C\u0001!-\u001b\u0005\t%B\u0001\"6\u0003\u0019a$o\\8u}%\u0011A\tL\u0001\u0007!J,G-\u001a4\n\u0005\u0019;%AB*ue&twM\u0003\u0002EY\u0005YQM\\4j]\u0016\u0014VMZ%e\u0003\u0019a\u0014N\\5u}Q!1*\u0014(P!\ta\u0005!D\u0001\"\u0011\u0015!D\u00011\u00017\u0011\u0015aD\u00011\u0001>\u0011\u001dAE\u0001%AA\u0002u\n1b]3sm\u0016\u00148\u000b]1dKV\tQ(\u0001\u0007tKJ4XM]*qC\u000e,\u0007%A\u0004uS6,w.\u001e;\u0016\u0003U\u0003\"a\u000b,\n\u0005]c#\u0001\u0002'p]\u001e\f\u0001\u0002^5nK>,H\u000fI\u0001\u000bg\"\f'/\u001a'fm\u0016dW#A.\u0011\u0005q;gBA/f\u001d\tqFM\u0004\u0002`G:\u0011\u0001M\u0019\b\u0003\u0001\u0006L\u0011\u0001K\u0005\u0003M\u001dJ!\u0001J\u0013\n\u0005\t\u001a\u0013B\u00014\"\u0003)\u0019\u0006.\u0019:f\u0019\u00164X\r\\\u0005\u0003Q&\u0014!b\u00155be\u0016dUM^3m\u0015\t1\u0017%A\u0006tQ\u0006\u0014X\rT3wK2\u0004\u0013AC3oO&tW\rV=qKV\tQ\u000e\u0005\u0002oc:\u0011Ql\\\u0005\u0003a\u0006\n!\"\u00128hS:,G+\u001f9f\u0013\t\u00118O\u0001\u0006F]\u001eLg.\u001a+za\u0016T!\u0001]\u0011\u0002\u0017\u0015tw-\u001b8f)f\u0004X\rI\u0001\u000ea>|G\u000e\u00165sKNDw\u000e\u001c3\u0016\u0003]\u0004\"a\u000b=\n\u0005ed#aA%oi\u0006q\u0001o\\8m)\"\u0014Xm\u001d5pY\u0012\u0004\u0013AD2mS\u0016tG\u000fU8pYNK'0Z\u0001\u0010G2LWM\u001c;Q_>d7+\u001b>fA\u0005I1/\u001e2e_6\f\u0017N\\\u0001\u000bgV\u0014Gm\\7bS:\u0004\u0003f\u0001\n\u0002\u0002A!\u00111AA\u000b\u001b\t\t)A\u0003\u0003\u0002\b\u0005%\u0011aC1o]>$\u0018\r^5p]NTA!a\u0003\u0002\u000e\u000511m\\7n_:TA!a\u0004\u0002\u0012\u00051qm\\8hY\u0016T!!a\u0005\u0002\u0007\r|W.\u0003\u0003\u0002\u0018\u0005\u0015!!\u0005,jg&\u0014G.\u001a$peR+7\u000f^5oO\u00069\u0011\r\u001d9Vg\u0016\u0014\u0018\u0001C1qaV\u001bXM\u001d\u0011\u0002#\u0011,g-Y;mi\u0016sw-\u001b8f\u001d\u0006lW-\u0001\neK\u001a\fW\u000f\u001c;F]\u001eLg.\u001a(b[\u0016\u0004\u0003f\u0001\f\u0002\u0002\u0005YQM\\4j]\u0016\u001c\u0006/Y2fQ\r9\u0012\u0011A\u0001\fiJLx+\u001b;i\u0019>\u001c7.\u0006\u0003\u0002,\u0005MB\u0003BA\u0017\u0003\u001f\"B!a\f\u0002FA!\u0011\u0011GA\u001a\u0019\u0001!q!!\u000e\u0019\u0005\u0004\t9DA\u0001U#\u0011\tI$a\u0010\u0011\u0007-\nY$C\u0002\u0002>1\u0012qAT8uQ&tw\rE\u0002,\u0003\u0003J1!a\u0011-\u0005\r\te.\u001f\u0005\t\u0003\u000fBB\u00111\u0001\u0002J\u0005\ta\rE\u0003,\u0003\u0017\ny#C\u0002\u0002N1\u0012\u0001\u0002\u00102z]\u0006lWM\u0010\u0005\b\u0003#B\u0002\u0019AA*\u0003!Q8n\u00117jK:$\b\u0003BA+\u0003?j!!a\u0016\u000b\t\u0005e\u00131L\u0001\nMJ\fW.Z<pe.T1!!\u0018&\u0003\u001d\u0019WO]1u_JLA!!\u0019\u0002X\t\u00012)\u001e:bi>\u0014hI]1nK^|'o[\u0001\u0007GJ,\u0017\r^3\u0015\r\u0005\u001d\u0014QNA8!\u0015Y\u0013\u0011N\u001fx\u0013\r\tY\u0007\f\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005E\u0013\u00041\u0001\u0002T!9\u0011\u0011O\rA\u0002\u0005M\u0014AD3yiJ\fWI\\4j]\u0016dun\u001a\t\u0006W\u0005U\u0014\u0011P\u0005\u0004\u0003ob#AB(qi&|g\u000e\u0005\u0003\u0002|\u0005\u0015UBAA?\u0015\u0011\ty(!!\u0002\u00071|wMC\u0002\u0002\u0004\u000e\n\u0011b\u001c9fe\u0006$\u0018n\u001c8\n\t\u0005\u001d\u0015Q\u0010\u0002\r\u001fB,'/\u0019;j_:dunZ\u0001\fO\u0016$xJ]\"sK\u0006$X\r\u0006\u0004\u0002h\u00055\u0015q\u0012\u0005\b\u0003#R\u0002\u0019AA*\u0011%\t\tH\u0007I\u0001\u0002\u0004\t\u0019(A\u000bhKR|%o\u0011:fCR,G\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005U%\u0006BA:\u0003/[#!!'\u0011\t\u0005m\u0015QU\u0007\u0003\u0003;SA!a(\u0002\"\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003Gc\u0013AC1o]>$\u0018\r^5p]&!\u0011qUAO\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\n\u000b:<\u0017N\\3SK\u001a\u0004\"\u0001T\u000f\u0014\u0005uQCCAAV\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0017\u0016\u0004{\u0005]\u0005")
public class EngineRef
implements Logging {
    @VisibleForTesting
    private String engineSpace;
    private final KyuubiConf conf;
    private final String user;
    private final String engineRefId;
    private final String serverSpace;
    private final long timeout;
    private final Enumeration.Value shareLevel;
    private final Enumeration.Value engineType;
    private final int poolThreshold;
    private final int clientPoolSize;
    @VisibleForTesting
    private final String subdomain;
    private final String appUser;
    @VisibleForTesting
    private final String defaultEngineName;
    private transient Logger org$apache$kyuubi$Logging$$log_;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$3() {
        return EngineRef$.MODULE$.$lessinit$greater$default$3();
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public void debug(Function0<Object> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.info$((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.error$((Logging)this, message);
    }

    public void initializeLoggerIfNecessary(boolean isInterpreter) {
        Logging.initializeLoggerIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public Logger org$apache$kyuubi$Logging$$log_() {
        return this.org$apache$kyuubi$Logging$$log_;
    }

    public void org$apache$kyuubi$Logging$$log__$eq(Logger x$1) {
        this.org$apache$kyuubi$Logging$$log_ = x$1;
    }

    private String serverSpace() {
        return this.serverSpace;
    }

    private long timeout() {
        return this.timeout;
    }

    private Enumeration.Value shareLevel() {
        return this.shareLevel;
    }

    private Enumeration.Value engineType() {
        return this.engineType;
    }

    private int poolThreshold() {
        return this.poolThreshold;
    }

    private int clientPoolSize() {
        return this.clientPoolSize;
    }

    public String subdomain() {
        return this.subdomain;
    }

    public String appUser() {
        return this.appUser;
    }

    public String defaultEngineName() {
        return this.defaultEngineName;
    }

    private String engineSpace$lzycompute() {
        EngineRef engineRef = this;
        synchronized (engineRef) {
            if (!this.bitmap$0) {
                String commonParent = new StringBuilder(2).append(this.serverSpace()).append("_").append(this.shareLevel()).append("_").append(this.engineType()).toString();
                Enumeration.Value value = this.shareLevel();
                Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
                Enumeration.Value value3 = value;
                String string = !(value2 != null ? !value2.equals(value3) : value3 != null) ? ZKPaths.makePath((String)commonParent, (String)this.appUser(), (String[])new String[]{this.engineRefId}) : ZKPaths.makePath((String)commonParent, (String)this.appUser(), (String[])new String[]{this.subdomain()});
                this.engineSpace = string;
                this.bitmap$0 = true;
            }
        }
        return this.engineSpace;
    }

    public String engineSpace() {
        return !this.bitmap$0 ? this.engineSpace$lzycompute() : this.engineSpace;
    }

    private <T> T tryWithLock(CuratorFramework zkClient, Function0<T> f) {
        Object object;
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            object = f.apply();
        } else {
            Object object2;
            String lockPath = ZKPaths.makePath((String)new StringBuilder(1).append(this.serverSpace()).append("_").append(this.shareLevel()).toString(), (String)"lock", (String[])new String[]{this.appUser(), this.subdomain()});
            InterProcessSemaphoreMutex lock = null;
            try {
                try {
                    lock = new InterProcessSemaphoreMutex(zkClient, lockPath);
                    lock.acquire(this.timeout(), TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(22).append("Lock failed on path [").append(lockPath).append("]").toString(), (Throwable)e, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                }
                object2 = f.apply();
            }
            catch (Throwable throwable) {
                try {
                    if (lock != null) {
                        lock.release();
                    }
                }
                catch (Exception exception) {}
                throw throwable;
            }
            Object object3 = object2;
            try {
                if (lock != null) {
                    lock.release();
                }
            }
            catch (Exception exception) {}
            object = object3;
        }
        return (T)object;
    }

    private Tuple2<String, Object> create(CuratorFramework zkClient, Option<OperationLog> extraEngineLog) {
        Tuple2 tuple2;
        Object object = new Object();
        try {
            tuple2 = (Tuple2)this.tryWithLock(zkClient, (Function0 & Serializable & scala.Serializable)() -> {
                Tuple2 tuple2;
                Option engineRef = ServiceDiscovery$.MODULE$.getServerHost(zkClient, this.engineSpace());
                if (engineRef.nonEmpty()) {
                    throw new NonLocalReturnControl(object, engineRef.get());
                }
                $this.conf.set(HighAvailabilityConf$.MODULE$.HA_ZK_NAMESPACE(), (Object)this.engineSpace());
                $this.conf.set(HighAvailabilityConf$.MODULE$.HA_ZK_ENGINE_REF_ID(), (Object)$this.engineRefId);
                Enumeration.Value value = this.engineType();
                Enumeration.Value value2 = EngineType$.MODULE$.SPARK_SQL();
                Enumeration.Value value3 = value;
                if (value2 != null ? !value2.equals(value3) : value3 != null) {
                    throw new UnsupportedOperationException(new StringBuilder(25).append("Unsupported engine type: ").append(this.engineType()).toString());
                }
                $this.conf.setIfMissing("spark.app.name", this.defaultEngineName());
                $this.conf.set("spark.yarn.tags", new StringBuilder(6).append((String)$this.conf.getOption("spark.yarn.tags").map((Function1 & Serializable & scala.Serializable)x$1 -> new StringBuilder(1).append((String)x$1).append(",").toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).append("KYUUBI").toString());
                SparkProcessBuilder sparkProcessBuilder = new SparkProcessBuilder(this.appUser(), $this.conf, extraEngineLog);
                MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$2 -> {
                    x$2.incCount(MetricsConstants$.MODULE$.ENGINE_TOTAL());
                    return BoxedUnit.UNIT;
                });
                try (SparkProcessBuilder builder = sparkProcessBuilder;){
                    this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("Launching engine:\n").append(builder).toString());
                    Process process = builder.start();
                    long started = System.currentTimeMillis();
                    None$ exitValue = None$.MODULE$;
                    while (engineRef.isEmpty()) {
                        if (exitValue.isEmpty() && process.waitFor(1L, TimeUnit.SECONDS) && BoxesRunTime.unboxToInt((Object)(exitValue = new Some((Object)BoxesRunTime.boxToInteger((int)process.exitValue()))).get()) != 0) {
                            Throwable error = builder.getError();
                            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)ms -> {
                                EngineRef.$anonfun$create$6(this, error, ms);
                                return BoxedUnit.UNIT;
                            });
                            throw error;
                        }
                        if (started + this.timeout() <= System.currentTimeMillis()) {
                            String killMessage = builder.killApplication(builder.killApplication$default$1());
                            process.destroyForcibly();
                            MetricsSystem$.MODULE$.tracing((Function1 & Serializable & scala.Serializable)x$3 -> {
                                x$3.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_TIMEOUT(), (String[])new String[]{this.appUser()}));
                                return BoxedUnit.UNIT;
                            });
                            throw KyuubiSQLException$.MODULE$.apply(new StringBuilder(40).append("Timeout(").append(this.timeout()).append(" ms) to launched ").append(this.engineType()).append(" engine with ").append(builder).append(". ").append(killMessage).toString(), builder.getError(), KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                        }
                        engineRef = ServiceDiscovery$.MODULE$.getEngineByRefId(zkClient, this.engineSpace(), $this.engineRefId);
                    }
                    tuple2 = (Tuple2)engineRef.get();
                }
                return tuple2;
            });
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                tuple2 = (Tuple2)ex.value();
            }
            throw ex;
        }
        return tuple2;
    }

    public Tuple2<String, Object> getOrCreate(CuratorFramework zkClient, Option<OperationLog> extraEngineLog) {
        return (Tuple2)ServiceDiscovery$.MODULE$.getServerHost(zkClient, this.engineSpace()).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.create(zkClient, extraEngineLog));
    }

    public Option<OperationLog> getOrCreate$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$create$6(EngineRef $this, Throwable error$1, MetricsSystem ms) {
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{$this.appUser()}));
        ms.incCount(MetricRegistry.name((String)MetricsConstants$.MODULE$.ENGINE_FAIL(), (String[])new String[]{error$1.getClass().getSimpleName()}));
    }

    public EngineRef(KyuubiConf conf, String user, String engineRefId) {
        String string;
        String string2;
        this.conf = conf;
        this.user = user;
        this.engineRefId = engineRefId;
        Logging.$init$((Logging)this);
        this.serverSpace = (String)conf.get(HighAvailabilityConf$.MODULE$.HA_ZK_NAMESPACE());
        this.timeout = BoxesRunTime.unboxToLong((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_INIT_TIMEOUT()));
        this.shareLevel = ShareLevel$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL()));
        this.engineType = EngineType$.MODULE$.withName((String)conf.get(KyuubiConf$.MODULE$.ENGINE_TYPE()));
        this.poolThreshold = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SIZE_THRESHOLD()));
        this.clientPoolSize = BoxesRunTime.unboxToInt((Object)conf.get(KyuubiConf$.MODULE$.ENGINE_POOL_SIZE()));
        Option option = (Option)conf.get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL_SUBDOMAIN());
        if (option instanceof Some) {
            String _subdomain;
            Some some = (Some)option;
            string2 = _subdomain = (String)some.value();
        } else if (None$.MODULE$.equals(option) && this.clientPoolSize() > 0) {
            int poolSize = package$.MODULE$.min(this.clientPoolSize(), this.poolThreshold());
            if (poolSize < this.clientPoolSize()) {
                this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Request engine pool size(").append(this.clientPoolSize()).append(") exceeds, fallback to ").append("system threshold ").append(this.poolThreshold()).toString());
            }
            string2 = new StringBuilder(12).append("engine-pool-").append(Random$.MODULE$.nextInt(poolSize)).toString();
        } else {
            string2 = "default";
        }
        this.subdomain = string2;
        Enumeration.Value value = this.shareLevel();
        Enumeration.Value value2 = ShareLevel$.MODULE$.SERVER();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            string = Utils$.MODULE$.currentUser();
        } else {
            Enumeration.Value value4 = ShareLevel$.MODULE$.GROUP();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                String string3;
                UserGroupInformation clientUGI = UserGroupInformation.createRemoteUser((String)user);
                Option option2 = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])clientUGI.getGroupNames())).headOption();
                if (option2 instanceof Some) {
                    String primaryGroup;
                    Some some = (Some)option2;
                    string3 = primaryGroup = (String)some.value();
                } else if (None$.MODULE$.equals(option2)) {
                    this.warn((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(74).append("There is no primary group for ").append($this.user).append(", use the client user name as group directly").toString());
                    string3 = user;
                } else {
                    throw new MatchError((Object)option2);
                }
                string = string3;
            } else {
                string = user;
            }
        }
        this.appUser = string;
        String commonNamePrefix = new StringBuilder(9).append("kyuubi_").append(this.shareLevel()).append("_").append(this.engineType()).append("_").append(this.appUser()).toString();
        Enumeration.Value value6 = this.shareLevel();
        Enumeration.Value value7 = ShareLevel$.MODULE$.CONNECTION();
        Enumeration.Value value8 = value6;
        String string4 = !(value7 != null ? !value7.equals(value8) : value8 != null) ? new StringBuilder(1).append(commonNamePrefix).append("_").append(engineRefId).toString() : new StringBuilder(2).append(commonNamePrefix).append("_").append(this.subdomain()).append("_").append(engineRefId).toString();
        this.defaultEngineName = string4;
    }
}

