/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.server.api.v1;

import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.hive.service.rpc.thrift.TGetInfoType;
import org.apache.hive.service.rpc.thrift.TGetInfoValue;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.cli.HandleIdentifier;
import org.apache.kyuubi.operation.OperationHandle;
import org.apache.kyuubi.server.api.ApiRequestContext;
import org.apache.kyuubi.server.api.v1.ExecPoolStatistic;
import org.apache.kyuubi.server.api.v1.GetColumnsRequest;
import org.apache.kyuubi.server.api.v1.GetFunctionsRequest;
import org.apache.kyuubi.server.api.v1.GetSchemasRequest;
import org.apache.kyuubi.server.api.v1.GetTablesRequest;
import org.apache.kyuubi.server.api.v1.InfoDetail;
import org.apache.kyuubi.server.api.v1.SessionDetail;
import org.apache.kyuubi.server.api.v1.SessionList;
import org.apache.kyuubi.server.api.v1.SessionOpenCount;
import org.apache.kyuubi.server.api.v1.SessionOpenRequest;
import org.apache.kyuubi.server.api.v1.SessionOverview;
import org.apache.kyuubi.server.api.v1.StatementRequest;
import org.apache.kyuubi.service.BackendService;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionHandle;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.reflect.ScalaSignature;
import scala.util.control.NonFatal$;

@Tag(name="Session")
@Produces(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\t}g!\u0002\n\u0014\u0001My\u0002\"\u0002\u0016\u0001\t\u0003a\u0003\"B\u0018\u0001\t\u0003\u0001\u0004\"\u00022\u0001\t\u0003\u0019\u0007bBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003s\u0001A\u0011AA\u001e\u0011\u001d\t\u0019\u0006\u0001C\u0001\u0003+Bq!!\u001c\u0001\t\u0003\ty\u0007C\u0004\u0002\"\u0002!\t!a)\t\u000f\u0005\u001d\u0007\u0001\"\u0001\u0002J\"9\u00111\u001f\u0001\u0005\u0002\u0005U\bb\u0002B\u0006\u0001\u0011\u0005!Q\u0002\u0005\b\u0005G\u0001A\u0011\u0001B\u0013\u0011\u001d\u0011\u0019\u0005\u0001C\u0001\u0005\u000bBqAa\u0019\u0001\t\u0003\u0011)\u0007C\u0004\u0003|\u0001!\tA! \t\u000f\tm\u0005\u0001\"\u0001\u0003\u001e\"9!1\u0018\u0001\u0005\u0002\tu&\u0001E*fgNLwN\\:SKN|WO]2f\u0015\t!R#\u0001\u0002wc)\u0011acF\u0001\u0004CBL'B\u0001\r\u001a\u0003\u0019\u0019XM\u001d<fe*\u0011!dG\u0001\u0007Wf,XOY5\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(Q5\tQ#\u0003\u0002*+\t\t\u0012\t]5SKF,Xm\u001d;D_:$X\r\u001f;\u0002\rqJg.\u001b;?\u0007\u0001!\u0012!\f\t\u0003]\u0001i\u0011aE\u0001\u0010g\u0016\u001c8/[8o\u0013:4w\u000eT5tiR\t\u0011\u0007\u0005\u0002/e%\u00111g\u0005\u0002\f'\u0016\u001c8/[8o\u0019&\u001cH\u000f\u000b\u0002\u0003kA\u0011a'P\u0007\u0002o)\u0011\u0001(O\u0001\u0003eNT!AO\u001e\u0002\u0005]\u001c(\"\u0001\u001f\u0002\u000b)\fg/\u0019=\n\u0005y:$aA$F)\"B!\u0001\u0011)R'R{\u0006\r\u0005\u0002B\u001d6\t!I\u0003\u0002D\t\u0006I!/Z:q_:\u001cXm\u001d\u0006\u0003\u000b\u001a\u000b1\"\u00198o_R\fG/[8og*\u0011q\tS\u0001\u0004_\u0006\u001c(BA%K\u0003\t18G\u0003\u0002L\u0019\u000691o^1hO\u0016\u0014(\"A'\u0002\u0005%|\u0017BA(C\u0005-\t\u0005/\u001b*fgB|gn]3\u0002\u0019I,7\u000f]8og\u0016\u001cu\u000eZ3\"\u0003I\u000b1A\r\u00191\u0003\u001d\u0019wN\u001c;f]Rd\u0013!V\u0016\u0004-rk\u0006CA,[\u001b\u0005A&BA-E\u0003\u0015iW\rZ5b\u0013\tY\u0006LA\u0004D_:$XM\u001c;\u0002\u00135,G-[1UsB,\u0017%\u00010\u0002!\u0005\u0004\b\u000f\\5dCRLwN\\\u0018kg>t\u0017a\u00033fg\u000e\u0014\u0018\u000e\u001d;j_:\f\u0013!Y\u00012O\u0016$\b%\u00197mAQDW\rI:fgNLwN\u001c\u0011mSN$\b\u0005[8ti\u0016$\u0007%\u001b8!'\u0016\u001c8/[8o\u001b\u0006t\u0017mZ3s\u0003-\u0019Xm]:j_:LeNZ8\u0015\u0005\u0011<\u0007C\u0001\u0018f\u0013\t17CA\u0007TKN\u001c\u0018n\u001c8EKR\f\u0017\u000e\u001c\u0005\u0006Q\u000e\u0001\r![\u0001\u0011g\u0016\u001c8/[8o\u0011\u0006tG\r\\3TiJ\u0004\"A[9\u000f\u0005-|\u0007C\u00017#\u001b\u0005i'B\u00018,\u0003\u0019a$o\\8u}%\u0011\u0001OI\u0001\u0007!J,G-\u001a4\n\u0005I\u001c(AB*ue&twM\u0003\u0002qE!\"q-\u001e=z!\t1d/\u0003\u0002xo\tI\u0001+\u0019;i!\u0006\u0014\u0018-\\\u0001\u0006m\u0006dW/Z\u0011\u0002u\u0006i1/Z:tS>t\u0007*\u00198eY\u0016DCa\u0001?y\u007fB\u0011a'`\u0005\u0003}^\u0012A\u0001U1uQ\u0006\u0012\u0011\u0011A\u0001\u0010wN,7o]5p]\"\u000bg\u000e\u001a7f{\"\u00121!\u000e\u0015\u000b\u0007\u0001\u0003\u0016kUA\u0004?\u0006%A&A+\"\u0005\u0005-\u0011aK4fi\u0002\n\u0007e]3tg&|g\u000e\t<jC\u0002\u001aXm]:j_:\u0004\u0003.\u00198eY\u0016\u0004\u0013\u000eZ3oi&4\u0017.\u001a:\u0002\u000f\u001d,G/\u00138g_R1\u0011\u0011CA\f\u00037\u00012ALA\n\u0013\r\t)b\u0005\u0002\u000b\u0013:4w\u000eR3uC&d\u0007\"\u00025\u0005\u0001\u0004I\u0007&BA\fkbL\bbBA\u000f\t\u0001\u0007\u0011qD\u0001\tS:4w\u000eV=qKB\u0019\u0011%!\t\n\u0007\u0005\r\"EA\u0002J]RDc!a\u0007vq\u0006\u001d\u0012EAA\u000fQ\u0015!A\u0010_A\u0016C\t\ti#A\u0010|g\u0016\u001c8/[8o\u0011\u0006tG\r\\3~_%tgm\\\u0018|S:4w\u000eV=qKvD#\u0001B\u001b)\u0015\u0011\u0001\u0005+U*\u00024}\u000b)\u0004L\u0001VC\t\t9$\u0001,hKR\u0004\u0013\rI5oM>\u0014X.\u0019;j_:\u0004C-\u001a;bS2\u0004c/[1!g\u0016\u001c8/[8oA!\fg\u000e\u001a7fA%$WM\u001c;jM&,'\u000fI1oI\u0002\n\u0007e\u001d9fG&4\u0017n\u0019\u0011j]\u001a|'/\\1uS>t\u0007\u0005^=qK\u0006a1/Z:tS>t7i\\;oiR\u0011\u0011Q\b\t\u0004]\u0005}\u0012bAA!'\t\u00012+Z:tS>tw\n]3o\u0007>,h\u000e\u001e\u0015\u0006\u000bqD\u0018QI\u0011\u0003\u0003\u000f\nQaY8v]RD#!B\u001b)\u0015\u0015\u0001\u0005+U*\u0002N}\u000by\u0005L\u0001VC\t\t\t&\u0001\u0012HKR\u0004C\u000f[3!GV\u0014(/\u001a8uA=\u0004XM\u001c\u0011tKN\u001c\u0018n\u001c8!G>,h\u000e^\u0001\u0012Kb,7\rU8pYN#\u0018\r^5ti&\u001cGCAA,!\rq\u0013\u0011L\u0005\u0004\u00037\u001a\"!E#yK\u000e\u0004vn\u001c7Ti\u0006$\u0018n\u001d;jG\"*a\u0001 =\u0002`\u0005\u0012\u0011\u0011M\u0001\u0013Kb,7\rU8pY>\u001aH/\u0019;jgRL7\r\u000b\u0002\u0007k!Ra\u0001\u0011)R'\u0006\u001dt,!\u001b-\u0003U\u000b#!a\u001b\u0002U\u001d+G\u000fI:uCRL7\u000f^5dA%tgm\u001c\u0011pM\u0002\u0012\u0017mY6he>,h\u000e\u001a\u0011fq\u0016\u001cW\u000f^8sg\u0006Yq\u000e]3o'\u0016\u001c8/[8o)\u0011\t\t(! \u0011\t\u0005M\u0014\u0011P\u0007\u0003\u0003kR1!a\u001e\u001a\u0003\u001d\u0019Xm]:j_:LA!a\u001f\u0002v\ti1+Z:tS>t\u0007*\u00198eY\u0016Dq!a \b\u0001\u0004\t\t)A\u0004sKF,Xm\u001d;\u0011\u00079\n\u0019)C\u0002\u0002\u0006N\u0011!cU3tg&|gn\u00149f]J+\u0017/^3ti\"2q!!#y\u0003\u001f\u00032ANAF\u0013\r\tii\u000e\u0002\t\u0007>t7/^7fg2\nQ\fK\u0002\b\u0003'\u00032ANAK\u0013\r\t9j\u000e\u0002\u0005!>\u001bF\u000b\u000b\u0006\b\u0001B\u000b6+a'`\u0003;c\u0013!V\u0011\u0003\u0003?\u000bac\u00149f]\"\u001a'/Z1uK&\u0002\u0013\rI:fgNLwN\\\u0001\rG2|7/Z*fgNLwN\u001c\u000b\u0005\u0003K\u000b\t\f\u0005\u0003\u0002(\u00065VBAAU\u0015\r\tYkN\u0001\u0005G>\u0014X-\u0003\u0003\u00020\u0006%&\u0001\u0003*fgB|gn]3\t\u000b!D\u0001\u0019A5)\u000b\u0005EV\u000f_=)\t!a\bp \u0015\u0004\u0011\u0005e\u0006c\u0001\u001c\u0002<&\u0019\u0011QX\u001c\u0003\r\u0011+E*\u0012+FQ)A\u0001\tU)T\u0003\u0003|\u00161\u0019\u0017\u0002+\u0006\u0012\u0011QY\u0001\u0010\u00072|7/\u001a\u0011bAM,7o]5p]\u0006\u0001R\r_3dkR,7\u000b^1uK6,g\u000e\u001e\u000b\u0007\u0003\u0017\f9.a7\u0011\t\u00055\u00171[\u0007\u0003\u0003\u001fT1!!5\u001a\u0003%y\u0007/\u001a:bi&|g.\u0003\u0003\u0002V\u0006='aD(qKJ\fG/[8o\u0011\u0006tG\r\\3\t\u000b!L\u0001\u0019A5)\u000b\u0005]W\u000f_=\t\u000f\u0005}\u0014\u00021\u0001\u0002^B\u0019a&a8\n\u0007\u0005\u00058C\u0001\tTi\u0006$X-\\3oiJ+\u0017/^3ti\"*\u0011\u0002 =\u0002f\u0006\u0012\u0011q]\u0001%wN,7o]5p]\"\u000bg\u000e\u001a7f{>z\u0007/\u001a:bi&|gn]\u0018ti\u0006$X-\\3oi\"\u001a\u0011\"a%)\u0015%\u0001\u0005+U*\u0002n~\u000by\u000fL\u0001VC\t\t\t0A\u0018De\u0016\fG/\u001a\u0011b]\u0002z\u0007/\u001a:bi&|g\u000eI<ji\"\u0004S\tW#D+R+ul\u0015+B)\u0016kUI\u0014+!if\u0004X-A\u0006hKR$\u0016\u0010]3J]\u001a|G\u0003BAf\u0003oDQ\u0001\u001b\u0006A\u0002%DS!a>vqfDSA\u0003?y\u0003{\f#!a@\u0002Gm\u001cXm]:j_:D\u0015M\u001c3mKv|s\u000e]3sCRLwN\\:0if\u0004X-\u00138g_\"\u001a!\"a%)\u0015)\u0001\u0005+U*\u0003\u0006}\u00139\u0001L\u0001VC\t\u0011I!A\u0016De\u0016\fG/\u001a\u0011b]\u0002z\u0007/\u001a:bi&|g\u000eI<ji\"\u0004s)\u0012+`)f\u0003ViX%O\r>\u0003C/\u001f9f\u0003-9W\r^\"bi\u0006dwnZ:\u0015\t\u0005-'q\u0002\u0005\u0006Q.\u0001\r!\u001b\u0015\u0006\u0005\u001f)\b0\u001f\u0015\u0006\u0017qD(QC\u0011\u0003\u0005/\t1e_:fgNLwN\u001c%b]\u0012dW-`\u0018pa\u0016\u0014\u0018\r^5p]N|3-\u0019;bY><7\u000fK\u0002\f\u0003'C#b\u0003!Q#N\u0013ib\u0018B\u0010Y\u0005)\u0016E\u0001B\u0011\u0003)\u001a%/Z1uK\u0002\ng\u000eI8qKJ\fG/[8oA]LG\u000f\u001b\u0011H\u000bR{6)\u0011+B\u0019>;5\u000b\t;za\u0016\f!bZ3u'\u000eDW-\\1t)\u0019\tYMa\n\u0003,!)\u0001\u000e\u0004a\u0001S\"*!qE;ys\"9\u0011q\u0010\u0007A\u0002\t5\u0002c\u0001\u0018\u00030%\u0019!\u0011G\n\u0003#\u001d+GoU2iK6\f7OU3rk\u0016\u001cH\u000fK\u0003\ryb\u0014)$\t\u0002\u00038\u0005\u00113p]3tg&|g\u000eS1oI2,WpL8qKJ\fG/[8og>\u001a8\r[3nCND3\u0001DAJQ)a\u0001\tU)T\u0005{y&q\b\u0017\u0002+\u0006\u0012!\u0011I\u0001*\u0007J,\u0017\r^3!C:\u0004s\u000e]3sCRLwN\u001c\u0011xSRD\u0007eR#U?N\u001b\u0005*R'B'\u0002\"\u0018\u0010]3\u0002\u0013\u001d,G\u000fV1cY\u0016\u001cHCBAf\u0005\u000f\u0012Y\u0005C\u0003i\u001b\u0001\u0007\u0011\u000eK\u0003\u0003HUD\u0018\u0010C\u0004\u0002\u00005\u0001\rA!\u0014\u0011\u00079\u0012y%C\u0002\u0003RM\u0011\u0001cR3u)\u0006\u0014G.Z:SKF,Xm\u001d;)\u000b5a\bP!\u0016\"\u0005\t]\u0013!I>tKN\u001c\u0018n\u001c8IC:$G.Z?0_B,'/\u0019;j_:\u001cx\u0006^1cY\u0016\u001c\bfA\u0007\u0002\u0014\"RQ\u0002\u0011)R'\nusLa\u0018-\u0003U\u000b#A!\u0019\u0002Q\r\u0013X-\u0019;fA\u0005t\u0007e\u001c9fe\u0006$\u0018n\u001c8!o&$\b\u000eI$F)~#\u0016I\u0011'F'\u0002\"\u0018\u0010]3\u0002\u001b\u001d,G\u000fV1cY\u0016$\u0016\u0010]3t)\u0011\tYMa\u001a\t\u000b!t\u0001\u0019A5)\u000b\t\u001dT\u000f_=)\u000b9a\bP!\u001c\"\u0005\t=\u0014!J>tKN\u001c\u0018n\u001c8IC:$G.Z?0_B,'/\u0019;j_:\u001cx\u0006^1cY\u0016$\u0016\u0010]3tQ\rq\u00111\u0013\u0015\u000b\u001d\u0001\u0003\u0016k\u0015B;?\n]D&A+\"\u0005\te\u0014!L\"sK\u0006$X\rI1oA=\u0004XM]1uS>t\u0007e^5uQ\u0002:U\tV0U\u0003\ncUi\u0018+Z!\u0016\u001b\u0006\u0005^=qK\u0006Qq-\u001a;D_2,XN\\:\u0015\r\u0005-'q\u0010BB\u0011\u0015Aw\u00021\u0001jQ\u0015\u0011y(\u001e=z\u0011\u001d\tyh\u0004a\u0001\u0005\u000b\u00032A\fBD\u0013\r\u0011Ii\u0005\u0002\u0012\u000f\u0016$8i\u001c7v[:\u001c(+Z9vKN$\b&B\b}q\n5\u0015E\u0001BH\u0003\tZ8/Z:tS>t\u0007*\u00198eY\u0016lxf\u001c9fe\u0006$\u0018n\u001c8t_\r|G.^7og\"\u001aq\"a%)\u0015=\u0001\u0005+U*\u0003\u0016~\u00139\nL\u0001VC\t\u0011I*A\u0015De\u0016\fG/\u001a\u0011b]\u0002z\u0007/\u001a:bi&|g\u000eI<ji\"\u0004s)\u0012+`\u0007>cU+\u0014(TAQL\b/Z\u0001\rO\u0016$h)\u001e8di&|gn\u001d\u000b\u0007\u0003\u0017\u0014yJa)\t\u000b!\u0004\u0002\u0019A5)\u000b\t}U\u000f_=\t\u000f\u0005}\u0004\u00031\u0001\u0003&B\u0019aFa*\n\u0007\t%6CA\nHKR4UO\\2uS>t7OU3rk\u0016\u001cH\u000fK\u0003\u0011yb\u0014i+\t\u0002\u00030\u0006!3p]3tg&|g\u000eS1oI2,WpL8qKJ\fG/[8og>2WO\\2uS>t7\u000fK\u0002\u0011\u0003'C#\u0002\u0005!Q#N\u0013)l\u0018B\\Y\u0005)\u0016E\u0001B]\u0003-\u001a%/Z1uK\u0002\ng\u000eI8qKJ\fG/[8oA]LG\u000f\u001b\u0011H\u000bR{f)\u0016(D)&{ej\u0015\u0011usB,\u0017\u0001E4fiN+7o]5p]\"\u000bg\u000e\u001a7f)\u0011\t\tHa0\t\u000b!\f\u0002\u0019A5)\r\u0001\u0011\u0019\r\u001fBe!\r1$QY\u0005\u0004\u0005\u000f<$\u0001\u0003)s_\u0012,8-Z:-\u0003uCs\u0001\u0001Bg\u00053\u0014Y\u000e\u0005\u0003\u0003P\nUWB\u0001Bi\u0015\r\u0011\u0019\u000eR\u0001\u0005i\u0006<7/\u0003\u0003\u0003X\nE'a\u0001+bO\u0006!a.Y7fC\t\u0011i.A\u0004TKN\u001c\u0018n\u001c8")
public class SessionsResource
implements ApiRequestContext {
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    @Override
    public BackendService backendService() {
        return ApiRequestContext.backendService$(this);
    }

    @Override
    public ServletContext servletContext() {
        return this.servletContext;
    }

    @Override
    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    @Override
    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    @Override
    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="get all the session list hosted in SessionManager")
    @GET
    public SessionList sessionInfoList() {
        return new SessionList((Seq<SessionOverview>)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter((ConcurrentMap)this.backendService().sessionManager().getSessionList()).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SessionHandle handle = (SessionHandle)tuple2._1();
            Session session = (Session)tuple2._2();
            SessionOverview sessionOverview = new SessionOverview(session.user(), session.ipAddress(), session.createTime(), handle);
            return sessionOverview;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="get a session via session handle identifier")
    @GET
    @Path(value="{sessionHandle}")
    public SessionDetail sessionInfo(@PathParam(value="sessionHandle") String sessionHandleStr) {
        SessionDetail sessionDetail;
        SessionHandle sessionHandle = this.getSessionHandle(sessionHandleStr);
        try {
            Session session = this.backendService().sessionManager().getSession(sessionHandle);
            sessionDetail = new SessionDetail(session.user(), session.ipAddress(), session.createTime(), sessionHandle, session.lastAccessTime(), session.lastIdleTime(), session.getNoOperationTime(), (Map<String, String>)session.conf());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                Utils$.MODULE$.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("Invalid ").append(sessionHandle).toString(), e);
                throw new NotFoundException(new StringBuilder(8).append("Invalid ").append(sessionHandle).toString());
            }
            throw throwable;
        }
        return sessionDetail;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="get a information detail via session handle identifier and a specific information type")
    @GET
    @Path(value="{sessionHandle}/info/{infoType}")
    public InfoDetail getInfo(@PathParam(value="sessionHandle") String sessionHandleStr, @PathParam(value="infoType") int infoType) {
        InfoDetail infoDetail;
        SessionHandle sessionHandle = this.getSessionHandle(sessionHandleStr);
        TGetInfoType info = TGetInfoType.findByValue((int)infoType);
        try {
            TGetInfoValue infoValue = this.backendService().getInfo(sessionHandle, info);
            infoDetail = new InfoDetail(info.toString(), infoValue.getStringValue());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                Utils$.MODULE$.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Unrecognized GetInfoType value: ").append(infoType).toString(), e);
                throw new NotFoundException(new StringBuilder(32).append("Unrecognized GetInfoType value: ").append(infoType).toString());
            }
            throw throwable;
        }
        return infoDetail;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Get the current open session count")
    @GET
    @Path(value="count")
    public SessionOpenCount sessionCount() {
        return new SessionOpenCount(this.backendService().sessionManager().getOpenSessionCount());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Get statistic info of background executors")
    @GET
    @Path(value="execPool/statistic")
    public ExecPoolStatistic execPoolStatistic() {
        return new ExecPoolStatistic(this.backendService().sessionManager().getExecPoolSize(), this.backendService().sessionManager().getActiveCount());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Open(create) a session")
    @POST
    @Consumes(value={"application/json"})
    public SessionHandle openSession(SessionOpenRequest request) {
        return this.backendService().openSession(TProtocolVersion.findByValue((int)request.protocolVersion()), request.user(), request.password(), request.ipAddr(), request.configs());
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Close a session")
    @DELETE
    @Path(value="{sessionHandle}")
    public Response closeSession(@PathParam(value="sessionHandle") String sessionHandleStr) {
        SessionHandle sessionHandle = this.getSessionHandle(sessionHandleStr);
        this.backendService().closeSession(sessionHandle);
        return Response.ok().build();
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Create an operation with EXECUTE_STATEMENT type")
    @POST
    @Path(value="{sessionHandle}/operations/statement")
    public OperationHandle executeStatement(@PathParam(value="sessionHandle") String sessionHandleStr, StatementRequest request) {
        OperationHandle operationHandle;
        SessionHandle sessionHandle = this.getSessionHandle(sessionHandleStr);
        try {
            operationHandle = this.backendService().executeStatement(sessionHandle, request.statement(), request.runAsync(), request.queryTimeout());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                throw new NotFoundException("Error executing statement");
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Create an operation with GET_TYPE_INFO type")
    @POST
    @Path(value="{sessionHandle}/operations/typeInfo")
    public OperationHandle getTypeInfo(@PathParam(value="sessionHandle") String sessionHandleStr) {
        OperationHandle operationHandle;
        SessionHandle sessionHandle = this.getSessionHandle(sessionHandleStr);
        try {
            operationHandle = this.backendService().getTypeInfo(sessionHandle);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                throw new NotFoundException("Error getting type information");
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Create an operation with GET_CATALOGS type")
    @POST
    @Path(value="{sessionHandle}/operations/catalogs")
    public OperationHandle getCatalogs(@PathParam(value="sessionHandle") String sessionHandleStr) {
        OperationHandle operationHandle;
        SessionHandle sessionHandle = this.getSessionHandle(sessionHandleStr);
        try {
            operationHandle = this.backendService().getCatalogs(sessionHandle);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                throw new NotFoundException("Error getting catalogs");
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Create an operation with GET_SCHEMAS type")
    @POST
    @Path(value="{sessionHandle}/operations/schemas")
    public OperationHandle getSchemas(@PathParam(value="sessionHandle") String sessionHandleStr, GetSchemasRequest request) {
        OperationHandle operationHandle;
        SessionHandle sessionHandle = this.getSessionHandle(sessionHandleStr);
        try {
            operationHandle = this.backendService().getSchemas(sessionHandle, request.catalogName(), request.schemaName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                throw new NotFoundException("Error getting schemas");
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Create an operation with GET_TABLES type")
    @POST
    @Path(value="{sessionHandle}/operations/tables")
    public OperationHandle getTables(@PathParam(value="sessionHandle") String sessionHandleStr, GetTablesRequest request) {
        OperationHandle operationHandle;
        SessionHandle sessionHandle = this.getSessionHandle(sessionHandleStr);
        try {
            operationHandle = this.backendService().getTables(sessionHandle, request.catalogName(), request.schemaName(), request.tableName(), request.tableTypes());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                throw new NotFoundException("Error getting tables");
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Create an operation with GET_TABLE_TYPES type")
    @POST
    @Path(value="{sessionHandle}/operations/tableTypes")
    public OperationHandle getTableTypes(@PathParam(value="sessionHandle") String sessionHandleStr) {
        OperationHandle operationHandle;
        SessionHandle sessionHandle = this.getSessionHandle(sessionHandleStr);
        try {
            operationHandle = this.backendService().getTableTypes(sessionHandle);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                throw new NotFoundException("Error getting table types");
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Create an operation with GET_COLUMNS type")
    @POST
    @Path(value="{sessionHandle}/operations/columns")
    public OperationHandle getColumns(@PathParam(value="sessionHandle") String sessionHandleStr, GetColumnsRequest request) {
        OperationHandle operationHandle;
        SessionHandle sessionHandle = this.getSessionHandle(sessionHandleStr);
        try {
            operationHandle = this.backendService().getColumns(sessionHandle, request.catalogName(), request.schemaName(), request.tableName(), request.columnName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                throw new NotFoundException("Error getting columns");
            }
            throw throwable;
        }
        return operationHandle;
    }

    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json")}, description="Create an operation with GET_FUNCTIONS type")
    @POST
    @Path(value="{sessionHandle}/operations/functions")
    public OperationHandle getFunctions(@PathParam(value="sessionHandle") String sessionHandleStr, GetFunctionsRequest request) {
        OperationHandle operationHandle;
        SessionHandle sessionHandle = this.getSessionHandle(sessionHandleStr);
        try {
            operationHandle = this.backendService().getFunctions(sessionHandle, request.catalogName(), request.schemaName(), request.functionName());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                throw new NotFoundException("Error getting functions");
            }
            throw throwable;
        }
        return operationHandle;
    }

    public SessionHandle getSessionHandle(String sessionHandleStr) {
        SessionHandle sessionHandle;
        try {
            String[] splitSessionHandle = sessionHandleStr.split("\\|");
            HandleIdentifier handleIdentifier = new HandleIdentifier(UUID.fromString(splitSessionHandle[0]), UUID.fromString(splitSessionHandle[1]));
            TProtocolVersion protocolVersion = TProtocolVersion.findByValue((int)new StringOps(Predef$.MODULE$.augmentString(splitSessionHandle[2])).toInt());
            SessionHandle sessionHandle2 = new SessionHandle(handleIdentifier, protocolVersion);
            this.backendService().sessionManager().getSession(sessionHandle2);
            sessionHandle = sessionHandle2;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                Utils$.MODULE$.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Error getting sessionHandle by ").append(sessionHandleStr).append(".").toString(), e);
                throw new NotFoundException(new StringBuilder(32).append("Error getting sessionHandle by ").append(sessionHandleStr).append(".").toString());
            }
            throw throwable;
        }
        return sessionHandle;
    }

    public SessionsResource() {
        ApiRequestContext.$init$(this);
    }
}

