/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.org.apache.zookeeper.server.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.apache.kyuubi.shade.org.apache.jute.BinaryInputArchive;
import org.apache.kyuubi.shade.org.apache.jute.BinaryOutputArchive;
import org.apache.kyuubi.shade.org.apache.jute.InputArchive;
import org.apache.kyuubi.shade.org.apache.jute.OutputArchive;
import org.apache.kyuubi.shade.org.apache.jute.Record;
import org.apache.kyuubi.shade.org.apache.zookeeper.server.ServerStats;
import org.apache.kyuubi.shade.org.apache.zookeeper.server.persistence.FileHeader;
import org.apache.kyuubi.shade.org.apache.zookeeper.server.persistence.FilePadding;
import org.apache.kyuubi.shade.org.apache.zookeeper.server.persistence.TxnLog;
import org.apache.kyuubi.shade.org.apache.zookeeper.server.persistence.Util;
import org.apache.kyuubi.shade.org.apache.zookeeper.server.util.SerializeUtils;
import org.apache.kyuubi.shade.org.apache.zookeeper.txn.TxnHeader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileTxnLog
implements TxnLog {
    private static final Logger LOG;
    public static final int TXNLOG_MAGIC;
    public static final int VERSION = 2;
    public static final String LOG_FILE_PREFIX = "log";
    static final String FSYNC_WARNING_THRESHOLD_MS_PROPERTY = "fsync.warningthresholdms";
    static final String ZOOKEEPER_FSYNC_WARNING_THRESHOLD_MS_PROPERTY = "zookeeper.fsync.warningthresholdms";
    private static final long fsyncWarningThresholdMS;
    long lastZxidSeen;
    volatile BufferedOutputStream logStream = null;
    volatile OutputArchive oa;
    volatile FileOutputStream fos = null;
    File logDir;
    private final boolean forceSync = !System.getProperty("zookeeper.forceSync", "yes").equals("no");
    long dbId;
    private LinkedList<FileOutputStream> streamsToFlush = new LinkedList();
    File logFileWrite = null;
    private FilePadding filePadding = new FilePadding();
    private ServerStats serverStats;

    public FileTxnLog(File logDir) {
        this.logDir = logDir;
    }

    public static void setPreallocSize(long size) {
        FilePadding.setPreallocSize(size);
    }

    @Override
    public synchronized void setServerStats(ServerStats serverStats) {
        this.serverStats = serverStats;
    }

    protected Checksum makeChecksumAlgorithm() {
        return new Adler32();
    }

    @Override
    public synchronized void rollLog() throws IOException {
        if (this.logStream != null) {
            this.logStream.flush();
            this.logStream = null;
            this.oa = null;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.logStream != null) {
            this.logStream.close();
        }
        for (FileOutputStream log : this.streamsToFlush) {
            log.close();
        }
    }

    @Override
    public synchronized boolean append(TxnHeader hdr, Record txn) throws IOException {
        if (hdr == null) {
            return false;
        }
        if (hdr.getZxid() <= this.lastZxidSeen) {
            LOG.warn("Current zxid " + hdr.getZxid() + " is <= " + this.lastZxidSeen + " for " + hdr.getType());
        } else {
            this.lastZxidSeen = hdr.getZxid();
        }
        if (this.logStream == null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Creating new log file: " + Util.makeLogName(hdr.getZxid()));
            }
            this.logFileWrite = new File(this.logDir, Util.makeLogName(hdr.getZxid()));
            this.fos = new FileOutputStream(this.logFileWrite);
            this.logStream = new BufferedOutputStream(this.fos);
            this.oa = BinaryOutputArchive.getArchive(this.logStream);
            FileHeader fhdr = new FileHeader(TXNLOG_MAGIC, 2, this.dbId);
            fhdr.serialize(this.oa, "fileheader");
            this.logStream.flush();
            this.filePadding.setCurrentSize(this.fos.getChannel().position());
            this.streamsToFlush.add(this.fos);
        }
        this.filePadding.padFile(this.fos.getChannel());
        byte[] buf = Util.marshallTxnEntry(hdr, txn);
        if (buf == null || buf.length == 0) {
            throw new IOException("Faulty serialization for header and txn");
        }
        Checksum crc = this.makeChecksumAlgorithm();
        crc.update(buf, 0, buf.length);
        this.oa.writeLong(crc.getValue(), "txnEntryCRC");
        Util.writeTxnBytes(this.oa, buf);
        return true;
    }

    public static File[] getLogFiles(File[] logDirList, long snapshotZxid) {
        List<File> files = Util.sortDataDir(logDirList, LOG_FILE_PREFIX, true);
        long logZxid = 0L;
        for (File f : files) {
            long fzxid = Util.getZxidFromName(f.getName(), LOG_FILE_PREFIX);
            if (fzxid > snapshotZxid || fzxid <= logZxid) continue;
            logZxid = fzxid;
        }
        ArrayList<File> v = new ArrayList<File>(5);
        for (File f : files) {
            long fzxid = Util.getZxidFromName(f.getName(), LOG_FILE_PREFIX);
            if (fzxid < logZxid) continue;
            v.add(f);
        }
        return v.toArray(new File[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLastLoggedZxid() {
        long maxLog;
        File[] files = FileTxnLog.getLogFiles(this.logDir.listFiles(), 0L);
        long zxid = maxLog = files.length > 0 ? Util.getZxidFromName(files[files.length - 1].getName(), LOG_FILE_PREFIX) : -1L;
        TxnLog.TxnIterator itr = null;
        try {
            FileTxnLog txn = new FileTxnLog(this.logDir);
            itr = txn.read(maxLog);
            while (itr.next()) {
                TxnHeader hdr = itr.getHeader();
                zxid = hdr.getZxid();
            }
            this.close(itr);
        }
        catch (IOException e) {
            try {
                LOG.warn("Unexpected exception", (Throwable)e);
                this.close(itr);
            }
            catch (Throwable throwable) {
                this.close(itr);
                throw throwable;
            }
        }
        return zxid;
    }

    private void close(TxnLog.TxnIterator itr) {
        if (itr != null) {
            try {
                itr.close();
            }
            catch (IOException ioe) {
                LOG.warn("Error closing file iterator", (Throwable)ioe);
            }
        }
    }

    @Override
    public synchronized void commit() throws IOException {
        if (this.logStream != null) {
            this.logStream.flush();
        }
        for (FileOutputStream log : this.streamsToFlush) {
            log.flush();
            if (!this.forceSync) continue;
            long startSyncNS = System.nanoTime();
            log.getChannel().force(false);
            long syncElapsedMS = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startSyncNS);
            if (syncElapsedMS <= fsyncWarningThresholdMS) continue;
            if (this.serverStats != null) {
                this.serverStats.incrementFsyncThresholdExceedCount();
            }
            LOG.warn("fsync-ing the write ahead log in " + Thread.currentThread().getName() + " took " + syncElapsedMS + "ms which will adversely effect operation latency. See the ZooKeeper troubleshooting guide");
        }
        while (this.streamsToFlush.size() > 1) {
            this.streamsToFlush.removeFirst().close();
        }
    }

    @Override
    public TxnLog.TxnIterator read(long zxid) throws IOException {
        return new FileTxnIterator(this.logDir, zxid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean truncate(long zxid) throws IOException {
        FileTxnIterator itr = null;
        try {
            itr = new FileTxnIterator(this.logDir, zxid);
            PositionInputStream input = itr.inputStream;
            if (input == null) {
                throw new IOException("No log files found to truncate! This could happen if you still have snapshots from an old setup or log files were deleted accidentally or dataLogDir was changed in zoo.cfg.");
            }
            long pos = input.getPosition();
            RandomAccessFile raf = new RandomAccessFile(itr.logFile, "rw");
            raf.setLength(pos);
            raf.close();
            while (itr.goToNextLog()) {
                if (itr.logFile.delete()) continue;
                LOG.warn("Unable to truncate {}", (Object)itr.logFile);
            }
            this.close(itr);
        }
        catch (Throwable throwable) {
            this.close(itr);
            throw throwable;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileHeader readHeader(File file) throws IOException {
        InputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(file));
            BinaryInputArchive ia = BinaryInputArchive.getArchive(is);
            FileHeader hdr = new FileHeader();
            hdr.deserialize(ia, "fileheader");
            FileHeader fileHeader = hdr;
            return fileHeader;
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                LOG.warn("Ignoring exception during close", (Throwable)e);
            }
        }
    }

    @Override
    public long getDbId() throws IOException {
        FileTxnIterator itr = new FileTxnIterator(this.logDir, 0L);
        FileHeader fh = FileTxnLog.readHeader(itr.logFile);
        itr.close();
        if (fh == null) {
            throw new IOException("Unsupported Format.");
        }
        return fh.getDbid();
    }

    public boolean isForceSync() {
        return this.forceSync;
    }

    static {
        TXNLOG_MAGIC = ByteBuffer.wrap("ZKLG".getBytes()).getInt();
        LOG = LoggerFactory.getLogger(FileTxnLog.class);
        Long fsyncWarningThreshold = Long.getLong(ZOOKEEPER_FSYNC_WARNING_THRESHOLD_MS_PROPERTY);
        if (fsyncWarningThreshold == null) {
            fsyncWarningThreshold = Long.getLong(FSYNC_WARNING_THRESHOLD_MS_PROPERTY, 1000L);
        }
        fsyncWarningThresholdMS = fsyncWarningThreshold;
    }

    public static class FileTxnIterator
    implements TxnLog.TxnIterator {
        File logDir;
        long zxid;
        TxnHeader hdr;
        Record record;
        File logFile;
        InputArchive ia;
        static final String CRC_ERROR = "CRC check failed";
        PositionInputStream inputStream = null;
        private ArrayList<File> storedFiles;

        public FileTxnIterator(File logDir, long zxid) throws IOException {
            this.logDir = logDir;
            this.zxid = zxid;
            this.init();
        }

        void init() throws IOException {
            this.storedFiles = new ArrayList();
            List<File> files = Util.sortDataDir(FileTxnLog.getLogFiles(this.logDir.listFiles(), 0L), FileTxnLog.LOG_FILE_PREFIX, false);
            for (File f : files) {
                if (Util.getZxidFromName(f.getName(), FileTxnLog.LOG_FILE_PREFIX) >= this.zxid) {
                    this.storedFiles.add(f);
                    continue;
                }
                if (Util.getZxidFromName(f.getName(), FileTxnLog.LOG_FILE_PREFIX) >= this.zxid) continue;
                this.storedFiles.add(f);
                break;
            }
            this.goToNextLog();
            if (!this.next()) {
                return;
            }
            while (this.hdr.getZxid() < this.zxid) {
                if (this.next()) continue;
                return;
            }
        }

        private boolean goToNextLog() throws IOException {
            if (this.storedFiles.size() > 0) {
                this.logFile = this.storedFiles.remove(this.storedFiles.size() - 1);
                this.ia = this.createInputArchive(this.logFile);
                return true;
            }
            return false;
        }

        protected void inStreamCreated(InputArchive ia, InputStream is) throws IOException {
            FileHeader header = new FileHeader();
            header.deserialize(ia, "fileheader");
            if (header.getMagic() != TXNLOG_MAGIC) {
                throw new IOException("Transaction log: " + this.logFile + " has invalid magic number " + header.getMagic() + " != " + TXNLOG_MAGIC);
            }
        }

        protected InputArchive createInputArchive(File logFile) throws IOException {
            if (this.inputStream == null) {
                this.inputStream = new PositionInputStream(new BufferedInputStream(new FileInputStream(logFile)));
                LOG.debug("Created new input stream " + logFile);
                this.ia = BinaryInputArchive.getArchive(this.inputStream);
                this.inStreamCreated(this.ia, this.inputStream);
                LOG.debug("Created new input archive " + logFile);
            }
            return this.ia;
        }

        protected Checksum makeChecksumAlgorithm() {
            return new Adler32();
        }

        @Override
        public boolean next() throws IOException {
            if (this.ia == null) {
                return false;
            }
            try {
                long crcValue = this.ia.readLong("crcvalue");
                byte[] bytes = Util.readTxnBytes(this.ia);
                if (bytes == null || bytes.length == 0) {
                    throw new EOFException("Failed to read " + this.logFile);
                }
                Checksum crc = this.makeChecksumAlgorithm();
                crc.update(bytes, 0, bytes.length);
                if (crcValue != crc.getValue()) {
                    throw new IOException(CRC_ERROR);
                }
                this.hdr = new TxnHeader();
                this.record = SerializeUtils.deserializeTxn(bytes, this.hdr);
            }
            catch (EOFException e) {
                LOG.debug("EOF excepton " + e);
                this.inputStream.close();
                this.inputStream = null;
                this.ia = null;
                this.hdr = null;
                if (!this.goToNextLog()) {
                    return false;
                }
                return this.next();
            }
            catch (IOException e) {
                this.inputStream.close();
                throw e;
            }
            return true;
        }

        @Override
        public TxnHeader getHeader() {
            return this.hdr;
        }

        @Override
        public Record getTxn() {
            return this.record;
        }

        @Override
        public void close() throws IOException {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
    }

    static class PositionInputStream
    extends FilterInputStream {
        long position = 0L;

        protected PositionInputStream(InputStream in) {
            super(in);
        }

        @Override
        public int read() throws IOException {
            int rc = super.read();
            if (rc > -1) {
                ++this.position;
            }
            return rc;
        }

        @Override
        public int read(byte[] b) throws IOException {
            int rc = super.read(b);
            if (rc > 0) {
                this.position += (long)rc;
            }
            return rc;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int rc = super.read(b, off, len);
            if (rc > 0) {
                this.position += (long)rc;
            }
            return rc;
        }

        @Override
        public long skip(long n) throws IOException {
            long rc = super.skip(n);
            if (rc > 0L) {
                this.position += rc;
            }
            return rc;
        }

        public long getPosition() {
            return this.position;
        }

        @Override
        public boolean markSupported() {
            return false;
        }

        @Override
        public void mark(int readLimit) {
            throw new UnsupportedOperationException("mark");
        }

        @Override
        public void reset() {
            throw new UnsupportedOperationException("reset");
        }
    }
}

