/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.jdbc.hive.common;

import java.sql.Date;
import java.util.TimeZone;

public class DateUtils {
    private static final String[] FIELD_NAME = new String[]{"ERA", "YEAR", "MONTH", "WEEK_OF_YEAR", "WEEK_OF_MONTH", "DAY_OF_MONTH", "DAY_OF_YEAR", "DAY_OF_WEEK", "DAY_OF_WEEK_IN_MONTH", "AM_PM", "HOUR", "HOUR_OF_DAY", "MINUTE", "SECOND", "MILLISECOND", "ZONE_OFFSET", "DST_OFFSET"};
    private static final long MILLIS_PER_DAY = 86400000L;

    public static int parseNumericValueWithRange(String fieldName, String strVal, int minValue, int maxValue) throws IllegalArgumentException {
        int result = 0;
        if (strVal != null && ((result = Integer.parseInt(strVal)) < minValue || result > maxValue)) {
            throw new IllegalArgumentException(String.format("%s value %d outside range [%d, %d]", fieldName, result, minValue, maxValue));
        }
        return result;
    }

    public static String getFieldName(int field) {
        return FIELD_NAME[field];
    }

    public static Date internalToDate(int v) {
        long t = (long)v * 86400000L;
        return new Date(t - (long)TimeZone.getDefault().getOffset(t));
    }
}

